package com.estimote.cloud_plugin.internal.rest

import android.content.Context
import android.content.SharedPreferences
import com.estimote.coresdk.cloud.internal.ApiUtils
import com.estimote.coresdk.common.config.EstimoteSDK
import com.estimote.coresdk.repackaged.okio_v1_3_0.okio.ByteString
import okhttp3.Interceptor
import okhttp3.Response
import javax.inject.Inject

internal class ContentTypeHeaderInterceptor @Inject constructor() : Interceptor {
    override fun intercept(chain: Interceptor.Chain): Response = chain.proceed(buildHeader(chain))

    private fun buildHeader(chain: Interceptor.Chain) =
            chain.request().newBuilder().addHeader("Accept", "application/json").build()
}

internal class UserAgentHeaderInterceptor @Inject constructor(private val context: Context) : Interceptor {
    override fun intercept(chain: Interceptor.Chain): Response = chain.proceed(buildHeader(chain))

    private fun buildHeader(chain: Interceptor.Chain) =
            chain.request().newBuilder().addHeader("User-Agent", ApiUtils.userAgent(context)).build()
}

internal class AuthorizationHeaderInterceptor @Inject constructor(private val sharedPreferences: SharedPreferences) : Interceptor {
    override fun intercept(chain: Interceptor.Chain): Response {
        return if(sharedPreferences.contains("auth_cookie")) chain.proceed(buildCookieHeader(chain))
        else chain.proceed(buildBasicAuthHeader(chain))
    }

    private fun buildCookieHeader(chain: Interceptor.Chain) =
            chain.request().newBuilder().addHeader("Cookie", sharedPreferences.getString("auth_cookie", "-")).build()

    private fun buildBasicAuthHeader(chain: Interceptor.Chain) =
            chain.request().newBuilder().addHeader("Authorization", "Basic " + ByteString.encodeUtf8(EstimoteSDK.getAppId() + ":" + EstimoteSDK.getAppToken()).base64()).build()
}