package com.estimote.cloud_plugin.internal.rest

import com.google.gson.Gson
import com.jakewharton.retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory
import okhttp3.Interceptor
import okhttp3.OkHttpClient
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import javax.inject.Inject

internal class CloudRestApiFactory@Inject constructor(
        private val gson: Gson,
        private val contentTypeHeader: ContentTypeHeaderInterceptor,
        private val userAgentHeader: UserAgentHeaderInterceptor,
        private val authorizationHeader: AuthorizationHeaderInterceptor) {

    fun createRestApiFactory(endpoint: String): CloudRestApi {
        return Retrofit.Builder()
                .baseUrl(endpoint)
                .addConverterFactory(GsonConverterFactory.create(gson))
                .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
                .client(getHttpClient(contentTypeHeader, userAgentHeader, authorizationHeader))
                .build()
                .create(CloudRestApi::class.java)
    }

    private fun getHttpClient(vararg interceptors: Interceptor): OkHttpClient {
        val clientBuilder = OkHttpClient().newBuilder()
        interceptors.forEach { clientBuilder.addInterceptor(it) }
        return clientBuilder.build()
    }
}