package com.estimote.cloud_plugin.internal.rest

import com.estimote.cloud_plugin.internal.MeshSettingsVersionUpdate
import com.estimote.cloud_plugin.internal.dagger.model.MeshId
import com.estimote.internal_plugins_api.cloud.CloudMeshMessage
import io.reactivex.Completable
import io.reactivex.Observable
import retrofit2.http.Body
import retrofit2.http.GET
import retrofit2.http.POST
import retrofit2.http.Path

internal interface CloudRestApi {
    @GET("v3/devices/{id}")
    fun getDeviceMeshId(@Path("id") id: String): Observable<MeshId>

    @GET("v3/mesh/{mesh_id}/message_buffer")
    fun getMeshMessage(@Path("mesh_id") id: Long): Observable<CloudMeshMessage>

    @POST("/v3/devices/{id}")
    fun updateSettingsVersion(@Path("id") deviceId: String, @Body data: MeshSettingsVersionUpdate): Completable
}