package com.estimote.cloud_plugin.internal.dagger

import android.content.Context
import android.content.SharedPreferences
import com.estimote.cloud_plugin.internal.EstimoteCloudManager
import com.estimote.cloud_plugin.internal.rest.*
import com.estimote.cloud_plugin.internal.rest.gson.GsonFactory
import com.estimote.coresdk.cloud.internal.ApiUtils
import com.estimote.internal_plugins_api.cloud.CloudManager
import com.google.gson.Gson
import dagger.Module
import dagger.Provides
import javax.inject.Singleton

@Module
internal class CloudPluginModule(private val appContext: Context) {
    @Provides @Singleton internal fun provideApplicationContext(): Context = appContext

    @Provides @Singleton internal fun provideSharedPreferences(context: Context): SharedPreferences = ApiUtils.getSharedPreferences(context)

    @Provides @Singleton internal fun provideGson(): Gson = GsonFactory().createGson()

    @Provides @Singleton internal fun provideCloudRestApi(cloudRestApiFactory: CloudRestApiFactory): CloudRestApi = cloudRestApiFactory.createRestApiFactory("https://cloud.estimote.com:443")

    @Provides @Singleton internal fun provideCloudManager(restApi: CloudRestApi): CloudManager = EstimoteCloudManager(restApi)
}