package com.estimote.cloud_plugin

import android.content.Context
import com.estimote.cloud_plugin.internal.dagger.CloudPluginModule
import com.estimote.cloud_plugin.internal.dagger.DaggerCloudPluginComponent

import com.estimote.internal_plugins_api.cloud.CloudManager
import javax.inject.Inject

class CloudManagerFactory(applicationContext: Context) {
    @Inject internal lateinit var cloudManager: CloudManager

    init { DaggerCloudPluginComponent.builder().cloudPluginModule(CloudPluginModule(applicationContext)).build().inject(this) }

    fun create(): CloudManager =cloudManager
}
