/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.OperatorDistance;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.PolygonUtils;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentIterator;

class OperatorDistanceLocal
extends OperatorDistance {
    OperatorDistanceLocal() {
    }

    @Override
    public double execute(Geometry geom1, Geometry geom2, ProgressTracker progressTracker) {
        if (null == geom1 || null == geom2) {
            throw new IllegalArgumentException();
        }
        Geometry geometryA = geom1;
        Geometry geometryB = geom2;
        if (geometryA.getType().equals((Object)Geometry.Type.Point)) {
            MultiPoint multiPointA = new MultiPoint();
            multiPointA.add((Point)geometryA);
            geometryA = multiPointA;
        } else if (geometryA.getType().equals((Object)Geometry.Type.Envelope)) {
            Polygon polygonA = new Polygon();
            polygonA.addEnvelope((Envelope)geometryA, false);
            geometryB = polygonA;
        }
        if (geometryB.getType().equals((Object)Geometry.Type.Point)) {
            MultiPoint multiPointB = new MultiPoint();
            multiPointB.add((Point)geometryB);
            geometryB = multiPointB;
        } else if (geometryB.getType().equals((Object)Geometry.Type.Envelope)) {
            Polygon polygonB = new Polygon();
            polygonB.addEnvelope((Envelope)geometryB, false);
            geometryB = polygonB;
        }
        DistanceCalculator distanceCalculator = new DistanceCalculator(progressTracker);
        double distance = distanceCalculator.calculate(geometryA, geometryB);
        return distance;
    }

    class DistanceCalculator {
        private ProgressTracker m_progressTracker;
        private Envelope2D m_env2DgeometryA;
        private Envelope2D m_env2DgeometryB;

        private void swapEnvelopes_() {
            double temp = this.m_env2DgeometryA.xmin;
            this.m_env2DgeometryA.xmin = this.m_env2DgeometryB.xmin;
            this.m_env2DgeometryB.xmin = temp;
            temp = this.m_env2DgeometryA.xmax;
            this.m_env2DgeometryA.xmax = this.m_env2DgeometryB.xmax;
            this.m_env2DgeometryB.xmax = temp;
            temp = this.m_env2DgeometryA.ymin;
            this.m_env2DgeometryA.ymin = this.m_env2DgeometryB.ymin;
            this.m_env2DgeometryB.ymin = temp;
            temp = this.m_env2DgeometryA.ymax;
            this.m_env2DgeometryA.ymax = this.m_env2DgeometryB.ymax;
            this.m_env2DgeometryB.ymax = temp;
        }

        private double executeBruteForce_(Geometry geometryA, Geometry geometryB) {
            boolean geometriesAreDisjoint;
            if (this.m_progressTracker != null && !this.m_progressTracker.progress(-1, -1)) {
                throw new RuntimeException("user_canceled");
            }
            boolean bl = geometriesAreDisjoint = !this.m_env2DgeometryA.isIntersecting(this.m_env2DgeometryB);
            if (Geometry.isMultiPath(geometryA.getType().value()) && Geometry.isMultiPath(geometryB.getType().value())) {
                if (((MultiPath)geometryA).getPointCount() > ((MultiPath)geometryB).getPointCount()) {
                    return this.bruteForceMultiPathMultiPath_((MultiPath)geometryA, (MultiPath)geometryB, geometriesAreDisjoint);
                }
                this.swapEnvelopes_();
                double answer = this.bruteForceMultiPathMultiPath_((MultiPath)geometryB, (MultiPath)geometryA, geometriesAreDisjoint);
                this.swapEnvelopes_();
                return answer;
            }
            if (geometryA.getType() == Geometry.Type.MultiPoint && Geometry.isMultiPath(geometryB.getType().value())) {
                this.swapEnvelopes_();
                double answer = this.bruteForceMultiPathMultiPoint_((MultiPath)geometryB, (MultiPoint)geometryA, geometriesAreDisjoint);
                this.swapEnvelopes_();
                return answer;
            }
            if (geometryB.getType() == Geometry.Type.MultiPoint && Geometry.isMultiPath(geometryA.getType().value())) {
                return this.bruteForceMultiPathMultiPoint_((MultiPath)geometryA, (MultiPoint)geometryB, geometriesAreDisjoint);
            }
            if (geometryA.getType() == Geometry.Type.MultiPoint && geometryB.getType() == Geometry.Type.MultiPoint) {
                if (((MultiPoint)geometryA).getPointCount() > ((MultiPoint)geometryB).getPointCount()) {
                    return this.bruteForceMultiPointMultiPoint_((MultiPoint)geometryA, (MultiPoint)geometryB, geometriesAreDisjoint);
                }
                this.swapEnvelopes_();
                double answer = this.bruteForceMultiPointMultiPoint_((MultiPoint)geometryB, (MultiPoint)geometryA, geometriesAreDisjoint);
                this.swapEnvelopes_();
                return answer;
            }
            return 0.0;
        }

        private double bruteForceMultiPathMultiPath_(MultiPath geometryA, MultiPath geometryB, boolean geometriesAreDisjoint) {
            SegmentIterator segIterA = geometryA.querySegmentIterator();
            SegmentIterator segIterB = geometryB.querySegmentIterator();
            Envelope2D env2DSegmentA = new Envelope2D();
            Envelope2D env2DSegmentB = new Envelope2D();
            double minSqrDistance = NumberUtils.doubleMax();
            if (!geometriesAreDisjoint && this.weakIntersectionTest_(geometryA, geometryB, segIterA, segIterB)) {
                return 0.0;
            }
            while (segIterA.nextPath()) {
                while (segIterA.hasNextSegment()) {
                    Segment segmentA = segIterA.nextSegment();
                    segmentA.queryEnvelope2D(env2DSegmentA);
                    if (env2DSegmentA.sqrDistance(this.m_env2DgeometryB) > minSqrDistance) continue;
                    while (segIterB.nextPath()) {
                        while (segIterB.hasNextSegment()) {
                            Segment segmentB = segIterB.nextSegment();
                            segmentB.queryEnvelope2D(env2DSegmentB);
                            if (!(env2DSegmentA.sqrDistance(env2DSegmentB) < minSqrDistance)) continue;
                            double sqrDistance = segmentA.distance(segmentB, geometriesAreDisjoint);
                            if (!((sqrDistance *= sqrDistance) < minSqrDistance)) continue;
                            if (sqrDistance == 0.0) {
                                return 0.0;
                            }
                            minSqrDistance = sqrDistance;
                        }
                    }
                    segIterB.resetToFirstPath();
                }
            }
            return Math.sqrt(minSqrDistance);
        }

        private double bruteForceMultiPathMultiPoint_(MultiPath geometryA, MultiPoint geometryB, boolean geometriesAreDisjoint) {
            boolean bDoPiPTest;
            SegmentIterator segIterA = geometryA.querySegmentIterator();
            Envelope2D env2DSegmentA = new Envelope2D();
            double minSqrDistance = NumberUtils.doubleMax();
            Point2D inputPoint = new Point2D();
            double t = -1.0;
            double sqrDistance = minSqrDistance;
            MultiPointImpl multiPointImplB = (MultiPointImpl)geometryB._getImpl();
            int pointCountB = multiPointImplB.getPointCount();
            boolean bl = bDoPiPTest = !geometriesAreDisjoint && geometryA.getType() == Geometry.Type.Polygon;
            while (segIterA.nextPath()) {
                while (segIterA.hasNextSegment()) {
                    Segment segmentA = segIterA.nextSegment();
                    segmentA.queryEnvelope2D(env2DSegmentA);
                    if (pointCountB > 1 && env2DSegmentA.sqrDistance(this.m_env2DgeometryB) > minSqrDistance) continue;
                    for (int i = 0; i < pointCountB; ++i) {
                        multiPointImplB.getXY(i, inputPoint);
                        if (bDoPiPTest && PolygonUtils.isPointInPolygon2D((Polygon)geometryA, inputPoint, 0.0) != PolygonUtils.PiPResult.PiPOutside) {
                            return 0.0;
                        }
                        t = segmentA.getClosestCoordinate(inputPoint, false);
                        inputPoint.sub(segmentA.getCoord2D(t));
                        sqrDistance = inputPoint.sqrLength();
                        if (!(sqrDistance < minSqrDistance)) continue;
                        if (sqrDistance == 0.0) {
                            return 0.0;
                        }
                        minSqrDistance = sqrDistance;
                    }
                    bDoPiPTest = false;
                }
            }
            return Math.sqrt(minSqrDistance);
        }

        private double bruteForceMultiPointMultiPoint_(MultiPoint geometryA, MultiPoint geometryB, boolean geometriesAreDisjoint) {
            double minSqrDistance = NumberUtils.doubleMax();
            Point2D pointA = new Point2D();
            Point2D pointB = new Point2D();
            double sqrDistance = minSqrDistance;
            MultiPointImpl multiPointImplA = (MultiPointImpl)geometryA._getImpl();
            MultiPointImpl multiPointImplB = (MultiPointImpl)geometryB._getImpl();
            int pointCountA = multiPointImplA.getPointCount();
            int pointCountB = multiPointImplB.getPointCount();
            for (int i = 0; i < pointCountA; ++i) {
                multiPointImplA.getXY(i, pointA);
                if (pointCountB > 1 && this.m_env2DgeometryB.sqrDistance(pointA) > minSqrDistance) continue;
                for (int j = 0; j < pointCountB; ++j) {
                    multiPointImplB.getXY(j, pointB);
                    sqrDistance = Point2D.sqrDistance(pointA, pointB);
                    if (!(sqrDistance < minSqrDistance)) continue;
                    if (sqrDistance == 0.0) {
                        return 0.0;
                    }
                    minSqrDistance = sqrDistance;
                }
            }
            return Math.sqrt(minSqrDistance);
        }

        private boolean weakIntersectionTest_(Geometry geometryA, Geometry geometryB, SegmentIterator segIterA, SegmentIterator segIterB) {
            if (geometryA.getType() == Geometry.Type.Polygon) {
                while (segIterB.nextPath()) {
                    Segment segmentB;
                    if (!segIterB.hasNextSegment() || PolygonUtils.isPointInPolygon2D((Polygon)geometryA, (segmentB = segIterB.nextSegment()).getEndXY(), 0.0) == PolygonUtils.PiPResult.PiPOutside) continue;
                    return true;
                }
                segIterB.resetToFirstPath();
            }
            if (geometryB.getType() == Geometry.Type.Polygon) {
                while (segIterA.nextPath()) {
                    Segment segmentA;
                    if (!segIterA.hasNextSegment() || PolygonUtils.isPointInPolygon2D((Polygon)geometryB, (segmentA = segIterA.nextSegment()).getEndXY(), 0.0) == PolygonUtils.PiPResult.PiPOutside) continue;
                    return true;
                }
                segIterA.resetToFirstPath();
            }
            return false;
        }

        DistanceCalculator(ProgressTracker progressTracker) {
            this.m_progressTracker = progressTracker;
            this.m_env2DgeometryA = new Envelope2D();
            this.m_env2DgeometryA.setEmpty();
            this.m_env2DgeometryB = new Envelope2D();
            this.m_env2DgeometryB.setEmpty();
        }

        double calculate(Geometry geometryA, Geometry geometryB) {
            if (geometryA.isEmpty() || geometryB.isEmpty()) {
                return 0.0;
            }
            geometryA.queryEnvelope2D(this.m_env2DgeometryA);
            geometryB.queryEnvelope2D(this.m_env2DgeometryB);
            return this.executeBruteForce_(geometryA, geometryB);
        }
    }
}

