/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.JSONUtils;
import com.esri.core.geometry.JsonParserCursor;
import com.esri.core.geometry.MapGeometry;
import com.esri.core.geometry.MapGeometryCursor;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.SpatialReference;
import java.io.IOException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

class OperatorImportMapGeometryFromJsonParserCursor
extends MapGeometryCursor {
    JsonParserCursor m_inputJsonParsers;
    int m_type;
    int m_index = -1;

    public OperatorImportMapGeometryFromJsonParserCursor(int type, JsonParserCursor jsonParsers) {
        if (jsonParsers == null) {
            throw new IllegalArgumentException();
        }
        this.m_type = type;
        this.m_inputJsonParsers = jsonParsers;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }

    @Override
    public MapGeometry next() {
        JsonParser jsonParser = this.m_inputJsonParsers.next();
        if (jsonParser != null) {
            this.m_index = this.m_inputJsonParsers.getID();
            return this.importFromJsonParser(jsonParser);
        }
        return null;
    }

    private MapGeometry importFromJsonParser(JsonParser parser) {
        try {
            if (!JSONUtils.isObjectStart(parser)) {
                return null;
            }
            switch (this.m_type) {
                case 197: {
                    return OperatorImportMapGeometryFromJsonParserCursor.fromJsonToEnvelope(parser);
                }
                case 33: {
                    return OperatorImportMapGeometryFromJsonParserCursor.fromJsonToPoint(parser);
                }
                case 1736: {
                    return OperatorImportMapGeometryFromJsonParserCursor.fromJsonToPolygon(parser);
                }
                case 1607: {
                    return OperatorImportMapGeometryFromJsonParserCursor.fromJsonToPolyline(parser);
                }
                case 550: {
                    return OperatorImportMapGeometryFromJsonParserCursor.fromJsonToMultiPoint(parser);
                }
                case 0: {
                    return OperatorImportMapGeometryFromJsonParserCursor.fromJsonToUnknown(parser);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public static MapGeometry fromJsonToUnknown(JsonParser parser) throws Exception {
        SpatialReference spatialReference = null;
        Geometry geom = null;
        boolean isPoint = false;
        boolean isEnvelope = false;
        double x = Double.NaN;
        double y = Double.NaN;
        double xmin = Double.NaN;
        double ymin = Double.NaN;
        double xmax = Double.NaN;
        double ymax = Double.NaN;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = parser.getCurrentName();
            parser.nextToken();
            if ("paths".equals(fieldName)) {
                geom = OperatorImportMapGeometryFromJsonParserCursor.parsePolyline(parser);
                continue;
            }
            if ("rings".equals(fieldName)) {
                geom = OperatorImportMapGeometryFromJsonParserCursor.parsePolygon(parser);
                continue;
            }
            if ("points".equals(fieldName)) {
                geom = OperatorImportMapGeometryFromJsonParserCursor.parseMultiPoint(parser);
                continue;
            }
            if ("spatialReference".equals(fieldName)) {
                spatialReference = SpatialReference.fromJson(parser);
                continue;
            }
            if ("x".equals(fieldName)) {
                isPoint = true;
                x = JSONUtils.readDouble(parser);
                continue;
            }
            if ("y".equals(fieldName)) {
                y = JSONUtils.readDouble(parser);
                continue;
            }
            if ("xmin".equals(fieldName)) {
                isEnvelope = true;
                xmin = JSONUtils.readDouble(parser);
                continue;
            }
            if ("ymin".equals(fieldName)) {
                ymin = JSONUtils.readDouble(parser);
                continue;
            }
            if ("xmax".equals(fieldName)) {
                xmax = JSONUtils.readDouble(parser);
                continue;
            }
            if ("ymax".equals(fieldName)) {
                ymax = JSONUtils.readDouble(parser);
                continue;
            }
            OperatorImportMapGeometryFromJsonParserCursor.windup(parser);
        }
        if (isPoint && !NumberUtils.isNaN(x) && !NumberUtils.isNaN(y)) {
            geom = new Point(x, y);
        } else if (isPoint) {
            geom = new Point();
        } else if (!(!isEnvelope || NumberUtils.isNaN(xmin) || NumberUtils.isNaN(ymin) || NumberUtils.isNaN(xmax) || NumberUtils.isNaN(ymax))) {
            geom = new Envelope(xmin, ymin, xmax, ymax);
        } else if (isEnvelope) {
            geom = new Envelope();
        }
        return new MapGeometry(geom, spatialReference);
    }

    public static MapGeometry fromJsonToEnvelope(JsonParser parser) throws Exception {
        SpatialReference spatialReference = null;
        double xmin = Double.NaN;
        double ymin = Double.NaN;
        double xmax = Double.NaN;
        double ymax = Double.NaN;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = parser.getCurrentName();
            parser.nextToken();
            if ("xmin".equals(fieldName)) {
                xmin = JSONUtils.readDouble(parser);
                continue;
            }
            if ("ymin".equals(fieldName)) {
                ymin = JSONUtils.readDouble(parser);
                continue;
            }
            if ("xmax".equals(fieldName)) {
                xmax = JSONUtils.readDouble(parser);
                continue;
            }
            if ("ymax".equals(fieldName)) {
                ymax = JSONUtils.readDouble(parser);
                continue;
            }
            if ("spatialReference".equals(fieldName)) {
                spatialReference = SpatialReference.fromJson(parser);
                continue;
            }
            OperatorImportMapGeometryFromJsonParserCursor.windup(parser);
        }
        Envelope env = !NumberUtils.isNaN(xmin) && !NumberUtils.isNaN(ymin) && !NumberUtils.isNaN(xmax) && !NumberUtils.isNaN(ymax) ? new Envelope(xmin, ymin, xmax, ymax) : new Envelope();
        return new MapGeometry(env, spatialReference);
    }

    public static MapGeometry fromJsonToPoint(JsonParser parser) throws Exception {
        SpatialReference spatialReference = null;
        double x = Double.NaN;
        double y = Double.NaN;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = parser.getCurrentName();
            parser.nextToken();
            if ("x".equals(fieldName)) {
                x = JSONUtils.readDouble(parser);
                continue;
            }
            if ("y".equals(fieldName)) {
                y = JSONUtils.readDouble(parser);
                continue;
            }
            if ("spatialReference".equals(fieldName)) {
                spatialReference = SpatialReference.fromJson(parser);
                continue;
            }
            OperatorImportMapGeometryFromJsonParserCursor.windup(parser);
        }
        Point pt = !NumberUtils.isNaN(x) && !NumberUtils.isNaN(y) ? new Point(x, y) : new Point();
        return new MapGeometry(pt, spatialReference);
    }

    public static MapGeometry fromJsonToPolygon(JsonParser parser) throws Exception {
        SpatialReference spatialReference = null;
        Geometry geom = null;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = parser.getCurrentName();
            parser.nextToken();
            if ("rings".equals(fieldName)) {
                geom = OperatorImportMapGeometryFromJsonParserCursor.parsePolygon(parser);
                continue;
            }
            if ("spatialReference".equals(fieldName)) {
                spatialReference = SpatialReference.fromJson(parser);
                continue;
            }
            OperatorImportMapGeometryFromJsonParserCursor.windup(parser);
        }
        return new MapGeometry(geom, spatialReference);
    }

    public static MapGeometry fromJsonToPolyline(JsonParser parser) throws Exception {
        SpatialReference spatialReference = null;
        Geometry geom = null;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = parser.getCurrentName();
            parser.nextToken();
            if ("paths".equals(fieldName)) {
                geom = OperatorImportMapGeometryFromJsonParserCursor.parsePolyline(parser);
                continue;
            }
            if ("spatialReference".equals(fieldName)) {
                spatialReference = SpatialReference.fromJson(parser);
                continue;
            }
            OperatorImportMapGeometryFromJsonParserCursor.windup(parser);
        }
        return new MapGeometry(geom, spatialReference);
    }

    public static MapGeometry fromJsonToMultiPoint(JsonParser parser) throws Exception {
        SpatialReference spatialReference = null;
        Geometry geom = null;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = parser.getCurrentName();
            parser.nextToken();
            if ("points".equals(fieldName)) {
                geom = OperatorImportMapGeometryFromJsonParserCursor.parseMultiPoint(parser);
                continue;
            }
            if ("spatialReference".equals(fieldName)) {
                spatialReference = SpatialReference.fromJson(parser);
                continue;
            }
            OperatorImportMapGeometryFromJsonParserCursor.windup(parser);
        }
        return new MapGeometry(geom, spatialReference);
    }

    private static void windup(JsonParser parser) throws IOException, JsonParseException {
        parser.skipChildren();
    }

    private static Geometry parseMultiPoint(JsonParser parser) throws Exception {
        MultiPoint mpt = new MultiPoint();
        if (parser.getCurrentToken() == JsonToken.START_ARRAY) {
            while (parser.nextToken() != JsonToken.END_ARRAY) {
                if (parser.getCurrentToken() != JsonToken.START_ARRAY) continue;
                parser.nextToken();
                double x = JSONUtils.readDouble(parser);
                parser.nextToken();
                double y = JSONUtils.readDouble(parser);
                parser.nextToken();
                if (parser.getCurrentToken() != JsonToken.END_ARRAY) {
                    parser.nextToken();
                    if (parser.getCurrentToken() != JsonToken.END_ARRAY) {
                        parser.nextToken();
                    }
                }
                mpt.add(x, y);
            }
        }
        return mpt;
    }

    private static Geometry parsePolygon(JsonParser parser) throws Exception {
        Polygon polygon = new Polygon();
        if (parser.getCurrentToken() == JsonToken.START_ARRAY) {
            while (parser.nextToken() != JsonToken.END_ARRAY) {
                boolean newPath = true;
                double x = 0.0;
                double y = 0.0;
                if (parser.getCurrentToken() != JsonToken.START_ARRAY) continue;
                JsonToken nextToken = parser.nextToken();
                while (nextToken != JsonToken.END_ARRAY) {
                    if (parser.getCurrentToken() == JsonToken.START_ARRAY) {
                        parser.nextToken();
                        x = JSONUtils.readDouble(parser);
                        parser.nextToken();
                        y = JSONUtils.readDouble(parser);
                    }
                    parser.nextToken();
                    if (parser.getCurrentToken() != JsonToken.END_ARRAY) {
                        parser.nextToken();
                        if (parser.getCurrentToken() != JsonToken.END_ARRAY) {
                            parser.nextToken();
                        }
                    }
                    nextToken = parser.nextToken();
                    if (newPath) {
                        newPath = false;
                        polygon.startPath(x, y);
                        continue;
                    }
                    if (nextToken == JsonToken.END_ARRAY) continue;
                    polygon.lineTo(x, y);
                }
            }
        }
        return polygon;
    }

    private static Geometry parsePolyline(JsonParser parser) throws Exception {
        Polyline polyline = new Polyline();
        if (parser.getCurrentToken() == JsonToken.START_ARRAY) {
            while (parser.nextToken() != JsonToken.END_ARRAY) {
                boolean newPath = true;
                if (parser.getCurrentToken() != JsonToken.START_ARRAY) continue;
                while (parser.nextToken() != JsonToken.END_ARRAY) {
                    if (parser.getCurrentToken() != JsonToken.START_ARRAY) continue;
                    parser.nextToken();
                    double x = JSONUtils.readDouble(parser);
                    parser.nextToken();
                    double y = JSONUtils.readDouble(parser);
                    parser.nextToken();
                    if (parser.getCurrentToken() != JsonToken.END_ARRAY) {
                        parser.nextToken();
                        if (parser.getCurrentToken() != JsonToken.END_ARRAY) {
                            parser.nextToken();
                        }
                    }
                    if (newPath) {
                        newPath = false;
                        polyline.startPath(x, y);
                        continue;
                    }
                    polyline.lineTo(x, y);
                }
            }
        }
        return polyline;
    }
}

