/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.JsonCursor;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.SpatialReference;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;

class OperatorExportToJsonCursor
extends JsonCursor {
    GeometryCursor m_inputGeometryCursor;
    int m_index = -1;
    int m_wkid = -1;
    int m_latest_wkid = -1;
    String m_wkt = null;
    private static JsonFactory factory = new JsonFactory();

    public OperatorExportToJsonCursor(SpatialReference spatialReference, GeometryCursor geometryCursor) {
        if (geometryCursor == null) {
            throw new IllegalArgumentException();
        }
        if (spatialReference != null && !spatialReference.isLocal()) {
            this.m_wkid = spatialReference.getOldID();
            this.m_wkt = spatialReference.getText();
            this.m_latest_wkid = spatialReference.getLatestID();
        }
        this.m_inputGeometryCursor = geometryCursor;
    }

    @Override
    public int getID() {
        return this.m_index;
    }

    @Override
    public String next() {
        Geometry geometry = this.m_inputGeometryCursor.next();
        if (geometry != null) {
            this.m_index = this.m_inputGeometryCursor.getGeometryID();
            return this.exportToJson(geometry);
        }
        return null;
    }

    private String exportToJson(Geometry geometry) {
        StringWriter sw = new StringWriter();
        try {
            JsonGenerator gen = factory.createJsonGenerator((Writer)sw);
            int type = geometry.getType().value();
            switch (type) {
                case 33: {
                    this.exportPointToJson(gen, (Point)geometry);
                    break;
                }
                case 550: {
                    this.exportMultiPointToJson(gen, (MultiPoint)geometry);
                    break;
                }
                case 1607: {
                    this.exportPolylineToJson(gen, (Polyline)geometry);
                    break;
                }
                case 1736: {
                    this.exportPolygonToJson(gen, (Polygon)geometry);
                    break;
                }
                case 197: {
                    this.exportEnvelopeToJson(gen, (Envelope)geometry);
                    break;
                }
                default: {
                    throw new RuntimeException("not implemented for this geometry type");
                }
            }
            return sw.getBuffer().toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void exportPolygonToJson(JsonGenerator g, Polygon pp) throws JsonGenerationException, IOException {
        this.exportPolypathToJson(g, pp, "rings");
    }

    private void exportPolylineToJson(JsonGenerator g, Polyline pp) throws JsonGenerationException, IOException {
        this.exportPolypathToJson(g, pp, "paths");
    }

    private void exportPolypathToJson(JsonGenerator g, MultiPath pp, String name) throws JsonGenerationException, IOException {
        boolean bExportZs = pp.hasAttribute(1);
        boolean bExportMs = pp.hasAttribute(2);
        g.writeStartObject();
        if (bExportZs) {
            g.writeFieldName("hasZ");
            g.writeBoolean(true);
        }
        if (bExportMs) {
            g.writeFieldName("hasM");
            g.writeBoolean(true);
        }
        g.writeFieldName(name);
        g.writeStartArray();
        if (!pp.isEmpty()) {
            int n = pp.getPathCount();
            MultiPathImpl mpImpl = (MultiPathImpl)pp._getImpl();
            AttributeStreamOfDbl zs = null;
            AttributeStreamOfDbl ms = null;
            if (bExportZs) {
                zs = (AttributeStreamOfDbl)mpImpl.getAttributeStreamRef(1);
            }
            if (bExportMs) {
                ms = (AttributeStreamOfDbl)mpImpl.getAttributeStreamRef(2);
            }
            boolean bPolygon = pp instanceof Polygon;
            Point2D pt = new Point2D();
            for (int i = 0; i < n; ++i) {
                g.writeStartArray();
                int startindex = pp.getPathStart(i);
                int numVertices = pp.getPathSize(i);
                for (int j = startindex; j < startindex + numVertices; ++j) {
                    pp.getXY(j, pt);
                    g.writeStartArray();
                    this.writeDouble(pt.x, g);
                    this.writeDouble(pt.y, g);
                    if (bExportZs) {
                        double z = zs.get(j);
                        this.writeDouble(z, g);
                    }
                    if (bExportMs) {
                        double m = ms.get(j);
                        this.writeDouble(m, g);
                    }
                    g.writeEndArray();
                }
                if (bPolygon) {
                    pp.getXY(startindex, pt);
                    g.writeStartArray();
                    g.writeNumber(pt.x);
                    g.writeNumber(pt.y);
                    if (bExportZs) {
                        double z = zs.get(startindex);
                        this.writeDouble(z, g);
                    }
                    if (bExportMs) {
                        double m = ms.get(startindex);
                        this.writeDouble(m, g);
                    }
                    g.writeEndArray();
                }
                g.writeEndArray();
            }
        }
        g.writeEndArray();
        this.writeSR(g);
        g.writeEndObject();
        g.close();
    }

    private void exportMultiPointToJson(JsonGenerator g, MultiPoint mpt) throws JsonGenerationException, IOException {
        boolean bExportZs = mpt.hasAttribute(1);
        boolean bExportMs = mpt.hasAttribute(2);
        g.writeStartObject();
        if (bExportZs) {
            g.writeFieldName("hasZ");
            g.writeBoolean(true);
        }
        if (bExportMs) {
            g.writeFieldName("hasM");
            g.writeBoolean(true);
        }
        g.writeFieldName("points");
        g.writeStartArray();
        if (!mpt.isEmpty()) {
            MultiPointImpl mpImpl = (MultiPointImpl)mpt._getImpl();
            AttributeStreamOfDbl zs = null;
            AttributeStreamOfDbl ms = null;
            if (bExportZs) {
                zs = (AttributeStreamOfDbl)mpImpl.getAttributeStreamRef(1);
            }
            if (bExportMs) {
                ms = (AttributeStreamOfDbl)mpImpl.getAttributeStreamRef(2);
            }
            Point2D pt = new Point2D();
            int n = mpt.getPointCount();
            for (int i = 0; i < n; ++i) {
                mpt.getXY(i, pt);
                g.writeStartArray();
                this.writeDouble(pt.x, g);
                this.writeDouble(pt.y, g);
                if (bExportZs) {
                    double z = zs.get(i);
                    this.writeDouble(z, g);
                }
                if (bExportMs) {
                    double m = ms.get(i);
                    this.writeDouble(m, g);
                }
                g.writeEndArray();
            }
        }
        g.writeEndArray();
        this.writeSR(g);
        g.writeEndObject();
        g.close();
    }

    private void exportPointToJson(JsonGenerator g, Point pt) throws JsonGenerationException, IOException {
        boolean bExportZs = pt.hasAttribute(1);
        boolean bExportMs = pt.hasAttribute(2);
        g.writeStartObject();
        if (pt.isEmpty()) {
            g.writeFieldName("x");
            g.writeNull();
            g.writeFieldName("y");
            g.writeNull();
            if (bExportZs) {
                g.writeFieldName("z");
                g.writeNull();
            }
            if (bExportMs) {
                g.writeFieldName("m");
                g.writeNull();
            }
        } else {
            g.writeFieldName("x");
            this.writeDouble(pt.getX(), g);
            g.writeFieldName("y");
            this.writeDouble(pt.getY(), g);
            if (bExportZs) {
                g.writeFieldName("z");
                this.writeDouble(pt.getZ(), g);
            }
            if (bExportMs) {
                g.writeFieldName("m");
                this.writeDouble(pt.getM(), g);
            }
        }
        this.writeSR(g);
        g.writeEndObject();
        g.close();
    }

    private void exportEnvelopeToJson(JsonGenerator g, Envelope env) throws JsonGenerationException, IOException {
        boolean bExportZs = env.hasAttribute(1);
        boolean bExportMs = env.hasAttribute(2);
        g.writeStartObject();
        if (env.isEmpty()) {
            g.writeFieldName("xmin");
            g.writeNull();
            g.writeFieldName("ymin");
            g.writeNull();
            g.writeFieldName("xmax");
            g.writeNull();
            g.writeFieldName("ymax");
            g.writeNull();
            if (bExportZs) {
                g.writeFieldName("zmin");
                g.writeNull();
                g.writeFieldName("zmax");
                g.writeNull();
            }
            if (bExportMs) {
                g.writeFieldName("mmin");
                g.writeNull();
                g.writeFieldName("mmax");
                g.writeNull();
            }
        } else {
            g.writeFieldName("xmin");
            this.writeDouble(env.getXMin(), g);
            g.writeFieldName("ymin");
            this.writeDouble(env.getYMin(), g);
            g.writeFieldName("xmax");
            this.writeDouble(env.getXMax(), g);
            g.writeFieldName("ymax");
            this.writeDouble(env.getYMax(), g);
            if (bExportZs) {
                Envelope1D z = env.queryInterval(1, 0);
                g.writeFieldName("zmin");
                this.writeDouble(z.vmin, g);
                g.writeFieldName("zmax");
                this.writeDouble(z.vmax, g);
            }
            if (bExportMs) {
                Envelope1D m = env.queryInterval(2, 0);
                g.writeFieldName("mmin");
                this.writeDouble(m.vmin, g);
                g.writeFieldName("mmax");
                this.writeDouble(m.vmax, g);
            }
        }
        this.writeSR(g);
        g.writeEndObject();
        g.close();
    }

    private void writeDouble(double d, JsonGenerator g) throws IOException, JsonGenerationException {
        if (NumberUtils.isNaN(d)) {
            g.writeNull();
        } else {
            g.writeNumber(d);
        }
    }

    private void writeSR(JsonGenerator g) throws IOException, JsonGenerationException {
        if (this.m_wkid > 0) {
            g.writeFieldName("spatialReference");
            g.writeStartObject();
            g.writeFieldName("wkid");
            g.writeNumber(this.m_wkid);
            if (this.m_latest_wkid > 0 && this.m_latest_wkid != this.m_wkid) {
                g.writeFieldName("latestWkid");
                g.writeNumber(this.m_latest_wkid);
            }
            g.writeEndObject();
        } else if (this.m_wkt != null) {
            g.writeFieldName("spatialReference");
            g.writeStartObject();
            g.writeFieldName("wkt");
            g.writeString(this.m_wkt);
            g.writeEndObject();
        } else {
            return;
        }
    }
}

