/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

class NumberUtils {
    public static final double TheNaN = Double.NaN;

    NumberUtils() {
    }

    static int snap(int v, int minv, int maxv) {
        return v < minv ? minv : (v > maxv ? maxv : v);
    }

    static long snap(long v, long minv, long maxv) {
        return v < minv ? minv : (v > maxv ? maxv : v);
    }

    public static double snap(double v, double minv, double maxv) {
        return v < minv ? minv : (v > maxv ? maxv : v);
    }

    public static int sizeOf(double v) {
        return 8;
    }

    public static int sizeOfDouble() {
        return 8;
    }

    public static int sizeOf(int v) {
        return 4;
    }

    public static int sizeOf(long v) {
        return 8;
    }

    public static int sizeOf(byte v) {
        return 1;
    }

    public static boolean isNaN(double d) {
        return Double.isNaN(d);
    }

    public static double NaN() {
        return Double.NaN;
    }

    public static int hash(int n) {
        int hash = 5381;
        hash = (hash << 5) + hash + (n & 0xFF);
        hash = (hash << 5) + hash + (n >> 8 & 0xFF);
        hash = (hash << 5) + hash + (n >> 16 & 0xFF);
        hash = (hash << 5) + hash + (n >> 24 & 0xFF);
        return hash &= Integer.MAX_VALUE;
    }

    public static int hash(double d) {
        long bits = Double.doubleToLongBits(d);
        int hc = (int)(bits ^ bits >>> 32);
        return NumberUtils.hash(hc);
    }

    public static int hash(int hashIn, int n) {
        int hash = (hashIn << 5) + hashIn + (n & 0xFF);
        hash = (hash << 5) + hash + (n >> 8 & 0xFF);
        hash = (hash << 5) + hash + (n >> 16 & 0xFF);
        hash = (hash << 5) + hash + (n >> 24 & 0xFF);
        return hash &= Integer.MAX_VALUE;
    }

    public static int hash(int hash, double d) {
        long bits = Double.doubleToLongBits(d);
        int hc = (int)(bits ^ bits >>> 32);
        return NumberUtils.hash(hash, hc);
    }

    public static long doubleToInt64Bits(double d) {
        return Double.doubleToLongBits(d);
    }

    public static double negativeInf() {
        return Double.NEGATIVE_INFINITY;
    }

    public static double positiveInf() {
        return Double.POSITIVE_INFINITY;
    }

    public static int intMax() {
        return Integer.MAX_VALUE;
    }

    public static double doubleEps() {
        return 2.220446049250313E-16;
    }

    public static double doubleMax() {
        return Double.MAX_VALUE;
    }

    public static int nextRand(int prevRand) {
        return 1103515245 * prevRand + 12345 & NumberUtils.intMax();
    }
}

