/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.EditShape;
import com.esri.core.geometry.IndexHashTable;
import com.esri.core.geometry.IndexMultiList;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point2D;

final class Clusterer {
    Point2D m_origin = new Point2D();
    double m_tolerance;
    double m_cell_size;
    int[] m_bucket_array = new int[4];
    int m_dbg_candidate_check_count = 0;
    int m_hash_values = -1;
    EditShape m_shape;
    IndexMultiList m_clusters;
    ClusterHashFunction m_hash_function;
    IndexHashTable m_hash_table;

    static boolean executeReciprocal(EditShape shape, double tolerance) {
        Clusterer clusterer = new Clusterer();
        clusterer.m_shape = shape;
        clusterer.m_tolerance = tolerance;
        clusterer.m_cell_size = 2.0 * tolerance;
        return clusterer.clusterReciprocal_();
    }

    static boolean executeNonReciprocal(EditShape shape, double tolerance) {
        Clusterer clusterer = new Clusterer();
        clusterer.m_shape = shape;
        clusterer.m_tolerance = tolerance;
        clusterer.m_cell_size = 2.0 * tolerance;
        return clusterer.clusterNonReciprocal_();
    }

    static boolean isClusterCandidate(double x_1, double y1, double x2, double y2, double tolerance) {
        double dx = x_1 - x2;
        double dy = y1 - y2;
        return Math.sqrt(dx * dx + dy * dy) <= tolerance;
    }

    static int hashFunction_(double xi, double yi) {
        int h = NumberUtils.hash(xi);
        return NumberUtils.hash(h, yi);
    }

    void getNearestNeighbourCandidate_(int xyindex, Point2D pointOfInterest, int bucket_ptr, ClusterCandidate candidate) {
        candidate.cluster = IndexMultiList.nullNode();
        candidate.distance = NumberUtils.doubleMax();
        Point2D pt = new Point2D();
        int node = bucket_ptr;
        while (node != IndexHashTable.nullNode()) {
            int cluster = this.m_hash_table.getElement(node);
            int xyind = this.m_clusters.getFirstElement(cluster);
            if (xyindex != xyind) {
                this.m_shape.getXY(xyind, pt);
                if (Clusterer.isClusterCandidate(pointOfInterest.x, pointOfInterest.y, pt.x, pt.y, this.m_tolerance)) {
                    pt.sub(pointOfInterest);
                    double l = pt.length();
                    if (l < candidate.distance) {
                        candidate.distance = l;
                        candidate.cluster = cluster;
                    }
                }
            }
            node = this.m_hash_table.getNextInBucket(node);
        }
    }

    void findClusterCandidate_(int xyindex, ClusterCandidate candidate) {
        Point2D pointOfInterest = new Point2D();
        this.m_shape.getXY(xyindex, pointOfInterest);
        double x_0 = pointOfInterest.x - this.m_origin.x;
        double x = x_0 / this.m_cell_size;
        double y0 = pointOfInterest.y - this.m_origin.y;
        double y = y0 / this.m_cell_size;
        double xi = Math.round(x - 0.5);
        double yi = Math.round(y - 0.5);
        candidate.cluster = IndexHashTable.nullNode();
        candidate.distance = NumberUtils.doubleMax();
        ClusterCandidate c = new ClusterCandidate();
        for (double dx = 0.0; dx <= 1.0; dx += 1.0) {
            for (double dy = 0.0; dy <= 1.0; dy += 1.0) {
                int bucket_ptr = this.m_hash_table.getFirstInBucket(Clusterer.hashFunction_(xi + dx, yi + dy));
                if (bucket_ptr == IndexHashTable.nullNode()) continue;
                this.getNearestNeighbourCandidate_(xyindex, pointOfInterest, bucket_ptr, c);
                if (c.cluster == IndexHashTable.nullNode() || !(c.distance < candidate.distance)) continue;
                candidate = c;
            }
        }
    }

    void collectClusterCandidates_(int xyindex, AttributeStreamOfInt32 candidates) {
        int bucket_ptr;
        Point2D pointOfInterest = new Point2D();
        this.m_shape.getXY(xyindex, pointOfInterest);
        double x_0 = pointOfInterest.x - this.m_origin.x;
        double x = x_0 / this.m_cell_size;
        double y0 = pointOfInterest.y - this.m_origin.y;
        double y = y0 / this.m_cell_size;
        double xi = Math.round(x - 0.5);
        double yi = Math.round(y - 0.5);
        for (int i = 0; i < 4; ++i) {
            this.m_bucket_array[i] = -1;
        }
        int bucket_count = 0;
        for (double dx = 0.0; dx <= 1.0; dx += 1.0) {
            for (double dy = 0.0; dy <= 1.0; dy += 1.0) {
                int bucket_ptr2 = this.m_hash_table.getFirstInBucket(Clusterer.hashFunction_(xi + dx, yi + dy));
                if (bucket_ptr2 == IndexHashTable.nullNode()) continue;
                for (int j = 0; j < bucket_count; ++j) {
                    if (this.m_bucket_array[j] != bucket_ptr2) continue;
                    bucket_ptr2 = -1;
                    break;
                }
                if (bucket_ptr2 == -1) continue;
                this.m_bucket_array[bucket_count] = bucket_ptr2;
                ++bucket_count;
            }
        }
        for (int i = 0; i < 4 && (bucket_ptr = this.m_bucket_array[i]) != -1; ++i) {
            this.collectNearestNeighbourCandidates_(xyindex, pointOfInterest, bucket_ptr, candidates);
        }
    }

    void collectNearestNeighbourCandidates_(int xyindex, Point2D pointOfInterest, int bucket_ptr, AttributeStreamOfInt32 candidates) {
        Point2D pt = new Point2D();
        int node = bucket_ptr;
        while (node != IndexHashTable.nullNode()) {
            int cluster = this.m_hash_table.getElement(node);
            int xyind = this.m_clusters.getFirstElement(cluster);
            if (xyindex != xyind) {
                this.m_shape.getXY(xyind, pt);
                ++this.m_dbg_candidate_check_count;
                if (Clusterer.isClusterCandidate(pointOfInterest.x, pointOfInterest.y, pt.x, pt.y, this.m_tolerance)) {
                    candidates.add(node);
                }
            }
            node = this.m_hash_table.getNextInBucket(node);
        }
    }

    boolean mergeClusters_(int cluster_1, int cluster_2) {
        int xyindex_1 = this.m_clusters.getFirstElement(cluster_1);
        int xyindex_2 = this.m_clusters.getFirstElement(cluster_2);
        boolean res = this.mergeVertices_(xyindex_1, xyindex_2);
        this.m_clusters.concatenateLists(cluster_1, cluster_2);
        int hash = this.m_hash_function.calculateHash(cluster_1);
        this.m_shape.setUserIndex(xyindex_1, this.m_hash_values, hash);
        return res;
    }

    boolean mergeVertices_(int vert_1, int vert_2) {
        Point2D pt_1 = new Point2D();
        this.m_shape.getXY(vert_1, pt_1);
        Point2D pt_2 = new Point2D();
        this.m_shape.getXY(vert_2, pt_2);
        double w_1 = this.m_shape.getWeight(vert_1);
        double w_2 = this.m_shape.getWeight(vert_2);
        double w = w_1 + w_2;
        int r = 0;
        double x = pt_1.x;
        if (pt_1.x != pt_2.x) {
            x = (pt_1.x * w_1 + pt_2.x * w_2) / w;
            ++r;
        }
        double y = pt_1.y;
        if (pt_1.y != pt_2.y) {
            y = (pt_1.y * w_1 + pt_2.y * w_2) / w;
            ++r;
        }
        if (r > 0) {
            this.m_shape.setXY(vert_1, x, y);
        }
        this.m_shape.setWeight(vert_1, w);
        return r != 0;
    }

    boolean clusterReciprocal_() {
        this.m_hash_values = this.m_shape.createUserIndex();
        int point_count = this.m_shape.getTotalPointCount();
        this.m_shape.getXY(this.m_shape.getFirstVertex(this.m_shape.getFirstPath(this.m_shape.getFirstGeometry())), this.m_origin);
        this.m_clusters.clear();
        this.m_clusters.reserveLists(this.m_shape.getTotalPointCount());
        this.m_clusters.reserveNodes(this.m_shape.getTotalPointCount());
        this.m_hash_table = new IndexHashTable(point_count * 5 / 4, new ClusterHashFunction(this.m_clusters, this.m_shape, this.m_origin, this.m_tolerance, this.m_cell_size, this.m_hash_values));
        this.m_hash_table.reserveElements(this.m_shape.getTotalPointCount());
        boolean b_clustered = false;
        int geometry = this.m_shape.getFirstGeometry();
        while (geometry != -1) {
            int path = this.m_shape.getFirstPath(geometry);
            while (path != -1) {
                int vertex = this.m_shape.getFirstVertex(path);
                int nindex = this.m_shape.getPathSize(path);
                for (int index = 0; index < nindex; ++index) {
                    assert (vertex != -1);
                    int cluster = this.m_clusters.createList();
                    this.m_clusters.addElement(cluster, vertex);
                    int hash = this.m_hash_function.calculateHash(cluster);
                    this.m_shape.setUserIndex(vertex, this.m_hash_values, hash);
                    this.m_hash_table.addElement(cluster);
                    vertex = this.m_shape.getNextVertex(vertex);
                }
                path = this.m_shape.getNextPath(path);
            }
            geometry = this.m_shape.getNextGeometry(geometry);
        }
        AttributeStreamOfInt32 nn_chain = new AttributeStreamOfInt32(0);
        AttributeStreamOfDbl nn_chain_distances = new AttributeStreamOfDbl(0);
        ClusterCandidate candidate = new ClusterCandidate();
        while (this.m_hash_table.size() != 0 || nn_chain.size() != 0) {
            if (nn_chain.size() == 0) {
                int cluster = this.m_hash_table.getAnyElement();
                nn_chain.add(cluster);
                continue;
            }
            int cluster_1 = nn_chain.getLast();
            int xyindex = this.m_clusters.getFirstElement(cluster_1);
            this.findClusterCandidate_(xyindex, candidate);
            if (candidate.cluster == IndexHashTable.nullNode()) {
                assert (nn_chain.size() == 1);
                nn_chain.removeLast();
                continue;
            }
            if (nn_chain.size() == 1) {
                this.m_hash_table.deleteElement(candidate.cluster);
                if (candidate.distance == 0.0) {
                    this.m_clusters.concatenateLists(cluster_1, candidate.cluster);
                    int cluster_weight_1 = this.m_clusters.getFirstElement(cluster_1);
                    int cluster_weight_2 = this.m_clusters.getFirstElement(candidate.cluster);
                    this.m_shape.setWeight(cluster_weight_1, this.m_shape.getWeight(cluster_weight_1) + this.m_shape.getWeight(cluster_weight_2));
                    continue;
                }
                nn_chain.add(candidate.cluster);
                continue;
            }
            assert (nn_chain.size() > 1);
            if (nn_chain.get(nn_chain.size() - 2) == candidate.cluster) {
                nn_chain.clear(false);
                b_clustered |= this.mergeClusters_(cluster_1, candidate.cluster);
                this.m_hash_table.addElement(cluster_1);
                continue;
            }
            if (nn_chain_distances.get(nn_chain_distances.size()) <= candidate.distance) {
                nn_chain.clear(false);
                b_clustered |= this.mergeClusters_(cluster_1, candidate.cluster);
                this.m_hash_table.addElement(cluster_1);
                continue;
            }
            nn_chain.add(candidate.cluster);
            nn_chain_distances.add(candidate.distance);
        }
        if (b_clustered) {
            this.applyClusterPositions_();
        }
        this.m_shape.removeUserIndex(this.m_hash_values);
        return b_clustered;
    }

    boolean clusterNonReciprocal_() {
        int point_count = this.m_shape.getTotalPointCount();
        int geometry = this.m_shape.getFirstGeometry();
        int path = this.m_shape.getFirstPath(geometry);
        int vertex = this.m_shape.getFirstVertex(path);
        this.m_shape.getXY(vertex, this.m_origin);
        if (this.m_clusters == null) {
            this.m_clusters = new IndexMultiList();
        }
        this.m_clusters.clear();
        this.m_clusters.reserveLists(this.m_shape.getTotalPointCount());
        this.m_clusters.reserveNodes(this.m_shape.getTotalPointCount());
        this.m_hash_values = this.m_shape.createUserIndex();
        this.m_hash_function = new ClusterHashFunction(this.m_clusters, this.m_shape, this.m_origin, this.m_tolerance, this.m_cell_size, this.m_hash_values);
        this.m_hash_table = new IndexHashTable(point_count * 5, this.m_hash_function);
        this.m_hash_table.reserveElements(this.m_shape.getTotalPointCount());
        boolean b_clustered = false;
        int geometry2 = this.m_shape.getFirstGeometry();
        while (geometry2 != -1) {
            int path2 = this.m_shape.getFirstPath(geometry2);
            while (path2 != -1) {
                int vertex2 = this.m_shape.getFirstVertex(path2);
                int nindex = this.m_shape.getPathSize(path2);
                for (int index = 0; index < nindex; ++index) {
                    assert (vertex2 != -1);
                    int cluster = this.m_clusters.createList();
                    this.m_clusters.addElement(cluster, vertex2);
                    int hash = this.m_hash_function.calculateHash(cluster);
                    this.m_shape.setUserIndex(vertex2, this.m_hash_values, hash);
                    this.m_hash_table.addElement(cluster);
                    vertex2 = this.m_shape.getNextVertex(vertex2);
                }
                path2 = this.m_shape.getNextPath(path2);
            }
            geometry2 = this.m_shape.getNextGeometry(geometry2);
        }
        AttributeStreamOfInt32 candidates = new AttributeStreamOfInt32(0);
        while (this.m_hash_table.size() != 0) {
            int node = this.m_hash_table.getAnyNode();
            assert (node != IndexHashTable.nullNode());
            int cluster_1 = this.m_hash_table.getElement(node);
            this.m_hash_table.deleteNode(node);
            int xyindex = this.m_clusters.getFirstElement(cluster_1);
            this.collectClusterCandidates_(xyindex, candidates);
            if (candidates.size() == 0) continue;
            int ncandidates = candidates.size();
            for (int candidate_index = 0; candidate_index < ncandidates; ++candidate_index) {
                int cluster_node = candidates.get(candidate_index);
                int cluster = this.m_hash_table.getElement(cluster_node);
                this.m_hash_table.deleteNode(cluster_node);
                b_clustered |= this.mergeClusters_(cluster_1, cluster);
            }
            this.m_hash_table.addElement(cluster_1);
            candidates.clear(false);
        }
        if (b_clustered) {
            this.applyClusterPositions_();
        }
        this.m_shape.removeUserIndex(this.m_hash_values);
        return b_clustered;
    }

    void applyClusterPositions_() {
        Point2D cluster_pt = new Point2D();
        int list = this.m_clusters.getFirstList();
        while (list != IndexMultiList.nullNode()) {
            int node = this.m_clusters.getFirst(list);
            assert (node != IndexMultiList.nullNode());
            int vertex = this.m_clusters.getElement(node);
            this.m_shape.getXY(vertex, cluster_pt);
            node = this.m_clusters.getNext(node);
            while (node != IndexMultiList.nullNode()) {
                int vertex_1 = this.m_clusters.getElement(node);
                this.m_shape.setXY(vertex_1, cluster_pt);
                node = this.m_clusters.getNext(node);
            }
            list = this.m_clusters.getNextList(list);
        }
    }

    Clusterer() {
    }

    static class ClusterCandidate {
        public int cluster;
        double distance;

        ClusterCandidate() {
        }
    }

    class ClusterHashFunction
    extends IndexHashTable.HashFunction {
        IndexMultiList m_clusters;
        EditShape m_shape;
        double m_tolerance;
        double m_cell_size;
        Point2D m_origin = new Point2D();
        Point2D m_pt = new Point2D();
        Point2D m_pt_2 = new Point2D();
        int m_hash_values;

        public ClusterHashFunction(IndexMultiList clusters, EditShape shape, Point2D origin, double tolerance, double cell_size, int hash_values) {
            this.m_clusters = clusters;
            this.m_shape = shape;
            this.m_tolerance = tolerance;
            this.m_cell_size = cell_size;
            this.m_origin = origin;
            this.m_hash_values = hash_values;
            this.m_pt.setNaN();
            this.m_pt_2.setNaN();
        }

        @Override
        public int getHash(int element) {
            int vertex = this.m_clusters.getFirstElement(element);
            return this.m_shape.getUserIndex(vertex, this.m_hash_values);
        }

        int calculateHash(int element) {
            int vertex = this.m_clusters.getFirstElement(element);
            this.m_shape.getXY(vertex, this.m_pt);
            double dx = this.m_pt.x - this.m_origin.x;
            double xi = Math.round(dx / this.m_cell_size);
            double dy = this.m_pt.y - this.m_origin.y;
            double yi = Math.round(dy / this.m_cell_size);
            return Clusterer.hashFunction_(xi, yi);
        }

        @Override
        public boolean equal(int element_1, int element_2) {
            int xyindex_1 = this.m_clusters.getFirstElement(element_1);
            this.m_shape.getXY(xyindex_1, this.m_pt);
            int xyindex_2 = this.m_clusters.getFirstElement(element_2);
            this.m_shape.getXY(xyindex_2, this.m_pt_2);
            return Clusterer.isClusterCandidate(this.m_pt.x, this.m_pt.y, this.m_pt_2.x, this.m_pt_2.y, this.m_tolerance);
        }

        @Override
        public int getHash(Object element_descriptor) {
            return 0;
        }

        @Override
        public boolean equal(Object element_descriptor, int element) {
            return false;
        }
    }
}

