/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.EngineLevelExtensionServicesContext;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConst;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaResult;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.ViewDataVisitor;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.TimeBatchViewFactory;
import java.util.ArrayDeque;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeBatchView
extends ViewSupport
implements StoppableView,
StopCallback,
DataWindowView {
    private final TimeBatchViewFactory timeBatchViewFactory;
    protected final AgentInstanceViewFactoryChainContext agentInstanceContext;
    protected final ExprTimePeriodEvalDeltaConst timeDeltaComputation;
    protected final Long initialReferencePoint;
    protected final boolean isForceOutput;
    protected final boolean isStartEager;
    protected final ViewUpdatedCollection viewUpdatedCollection;
    protected final long scheduleSlot;
    protected EPStatementHandleCallback handle;
    protected Long currentReferencePoint;
    protected ArrayDeque<EventBean> lastBatch = null;
    protected ArrayDeque<EventBean> currentBatch = new ArrayDeque();
    protected boolean isCallbackScheduled;
    private static final Logger log = LoggerFactory.getLogger(TimeBatchView.class);

    public TimeBatchView(TimeBatchViewFactory timeBatchViewFactory, AgentInstanceViewFactoryChainContext agentInstanceContext, ExprTimePeriodEvalDeltaConst timeDeltaComputation, Long referencePoint, boolean forceOutput, boolean isStartEager, ViewUpdatedCollection viewUpdatedCollection) {
        this.agentInstanceContext = agentInstanceContext;
        this.timeBatchViewFactory = timeBatchViewFactory;
        this.timeDeltaComputation = timeDeltaComputation;
        this.initialReferencePoint = referencePoint;
        this.isStartEager = isStartEager;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.isForceOutput = forceOutput;
        this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
        if (isStartEager) {
            if (this.currentReferencePoint == null) {
                this.currentReferencePoint = agentInstanceContext.getStatementContext().getSchedulingService().getTime();
            }
            this.scheduleCallback();
            this.isCallbackScheduled = true;
        }
        agentInstanceContext.addTerminationCallback(this);
    }

    public ExprTimePeriodEvalDeltaConst getTimeDeltaComputation() {
        return this.timeDeltaComputation;
    }

    public final Long getInitialReferencePoint() {
        return this.initialReferencePoint;
    }

    public boolean isForceOutput() {
        return this.isForceOutput;
    }

    public boolean isStartEager() {
        return this.isStartEager;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (newData == null || newData.length == 0) {
            return;
        }
        if (this.currentBatch.isEmpty()) {
            if (this.currentReferencePoint == null) {
                this.currentReferencePoint = this.initialReferencePoint;
                if (this.currentReferencePoint == null) {
                    this.currentReferencePoint = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
                }
            }
            if (!this.isCallbackScheduled) {
                this.scheduleCallback();
                this.isCallbackScheduled = true;
            }
        }
        for (EventBean newEvent : newData) {
            this.currentBatch.add(newEvent);
        }
    }

    protected void sendBatch() {
        this.isCallbackScheduled = false;
        if (this.hasViews()) {
            EventBean[] newData = null;
            EventBean[] oldData = null;
            if (!this.currentBatch.isEmpty()) {
                newData = this.currentBatch.toArray(new EventBean[this.currentBatch.size()]);
            }
            if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
                oldData = this.lastBatch.toArray(new EventBean[this.lastBatch.size()]);
            }
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(newData, oldData);
            }
            if (newData != null || oldData != null || this.isForceOutput) {
                this.updateChildren(newData, oldData);
            }
        }
        if (!this.currentBatch.isEmpty() || this.lastBatch != null && !this.lastBatch.isEmpty() || this.isForceOutput) {
            this.scheduleCallback();
            this.isCallbackScheduled = true;
        }
        this.lastBatch = this.currentBatch;
        this.currentBatch = new ArrayDeque();
    }

    public boolean isEmpty() {
        if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
            return false;
        }
        return this.currentBatch.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.currentBatch.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " initialReferencePoint=" + this.initialReferencePoint;
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.currentBatch, true, this.timeBatchViewFactory.getViewName(), null);
        viewDataVisitor.visitPrimary(this.lastBatch, true, this.timeBatchViewFactory.getViewName(), null);
    }

    protected void scheduleCallback() {
        long current = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        ExprTimePeriodEvalDeltaResult deltaWReference = this.timeDeltaComputation.deltaAddWReference(current, this.currentReferencePoint);
        long afterTime = deltaWReference.getDelta();
        this.currentReferencePoint = deltaWReference.getLastReference();
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger(EngineLevelExtensionServicesContext extensionServicesContext) {
                TimeBatchView.this.sendBatch();
            }
        };
        this.handle = new EPStatementHandleCallback(this.agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
        this.agentInstanceContext.getStatementContext().getSchedulingService().add(afterTime, this.handle, this.scheduleSlot);
    }

    public void stopView() {
        this.stopSchedule();
        this.agentInstanceContext.removeTerminationCallback(this);
    }

    @Override
    public void stop() {
        this.stopSchedule();
    }

    public void stopSchedule() {
        if (this.handle != null) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.timeBatchViewFactory;
    }
}

