/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import com.espertech.esper.util.SimpleTypeCasterFactory;
import com.espertech.esper.util.TypeWidener;
import com.espertech.esper.util.TypeWidenerBoxedNumeric;
import com.espertech.esper.util.TypeWidenerCustomizer;
import com.espertech.esper.util.TypeWidenerException;
import com.espertech.esper.util.TypeWidenerObjectArrayToCollectionCoercer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;

public class TypeWidenerFactory {
    private static final SimpleTypeCasterFactory.CharacterCaster STRING_TO_CHAR_COERCER = new SimpleTypeCasterFactory.CharacterCaster();
    public static final TypeWidenerObjectArrayToCollectionCoercer OBJECT_ARRAY_TO_COLLECTION_COERCER = new TypeWidenerObjectArrayToCollectionCoercer();
    private static final TypeWidenerByteArrayToCollectionCoercer BYTE_ARRAY_TO_COLLECTION_COERCER = new TypeWidenerByteArrayToCollectionCoercer();
    private static final TypeWidenerShortArrayToCollectionCoercer SHORT_ARRAY_TO_COLLECTION_COERCER = new TypeWidenerShortArrayToCollectionCoercer();
    private static final TypeWidenerIntArrayToCollectionCoercer INT_ARRAY_TO_COLLECTION_COERCER = new TypeWidenerIntArrayToCollectionCoercer();
    private static final TypeWidenerLongArrayToCollectionCoercer LONG_ARRAY_TO_COLLECTION_COERCER = new TypeWidenerLongArrayToCollectionCoercer();
    private static final TypeWidenerFloatArrayToCollectionCoercer FLOAT_ARRAY_TO_COLLECTION_COERCER = new TypeWidenerFloatArrayToCollectionCoercer();
    private static final TypeWidenerDoubleArrayToCollectionCoercer DOUBLE_ARRAY_TO_COLLECTION_COERCER = new TypeWidenerDoubleArrayToCollectionCoercer();
    private static final TypeWidenerBooleanArrayToCollectionCoercer BOOLEAN_ARRAY_TO_COLLECTION_COERCER = new TypeWidenerBooleanArrayToCollectionCoercer();
    private static final TypeWidenerCharArrayToCollectionCoercer CHAR_ARRAY_TO_COLLECTION_COERCER = new TypeWidenerCharArrayToCollectionCoercer();
    public static final TypeWidenerByteArrayToByteBufferCoercer BYTE_ARRAY_TO_BYTE_BUFFER_COERCER = new TypeWidenerByteArrayToByteBufferCoercer();

    public static TypeWidener getCheckPropertyAssignType(String columnName, Class columnType, Class writeablePropertyType, String writeablePropertyName, boolean allowObjectArrayToCollectionConversion, TypeWidenerCustomizer customizer, String statementName, String engineURI) throws TypeWidenerException {
        TypeWidener custom;
        Class columnClassBoxed = JavaClassHelper.getBoxedType(columnType);
        Class targetClassBoxed = JavaClassHelper.getBoxedType(writeablePropertyType);
        if (customizer != null && (custom = customizer.widenerFor(columnName, columnType, writeablePropertyType, writeablePropertyName, statementName, engineURI)) != null) {
            return custom;
        }
        if (columnType == null) {
            if (writeablePropertyType.isPrimitive()) {
                String message = "Invalid assignment of column '" + columnName + "' of null type to event property '" + writeablePropertyName + "' typed as '" + writeablePropertyType.getName() + "', nullable type mismatch";
                throw new TypeWidenerException(message);
            }
        } else if (columnClassBoxed != targetClassBoxed) {
            if (columnClassBoxed == String.class && targetClassBoxed == Character.class) {
                return STRING_TO_CHAR_COERCER;
            }
            if (allowObjectArrayToCollectionConversion && columnClassBoxed.isArray() && !columnClassBoxed.getComponentType().isPrimitive() && JavaClassHelper.isImplementsInterface(targetClassBoxed, Collection.class)) {
                return OBJECT_ARRAY_TO_COLLECTION_COERCER;
            }
            if (!JavaClassHelper.isAssignmentCompatible(columnClassBoxed, targetClassBoxed)) {
                String writablePropName = writeablePropertyType.getName();
                if (writeablePropertyType.isArray()) {
                    writablePropName = writeablePropertyType.getComponentType().getName() + "[]";
                }
                String columnTypeName = columnType.getName();
                if (columnType.isArray()) {
                    columnTypeName = columnType.getComponentType().getName() + "[]";
                }
                String message = "Invalid assignment of column '" + columnName + "' of type '" + columnTypeName + "' to event property '" + writeablePropertyName + "' typed as '" + writablePropName + "', column and parameter types mismatch";
                throw new TypeWidenerException(message);
            }
            if (JavaClassHelper.isNumeric(writeablePropertyType)) {
                return new TypeWidenerBoxedNumeric(SimpleNumberCoercerFactory.getCoercer(columnClassBoxed, targetClassBoxed));
            }
        }
        return null;
    }

    public static TypeWidener getArrayToCollectionCoercer(Class componentType) {
        if (!componentType.isPrimitive()) {
            return OBJECT_ARRAY_TO_COLLECTION_COERCER;
        }
        if (componentType == Byte.TYPE) {
            return BYTE_ARRAY_TO_COLLECTION_COERCER;
        }
        if (componentType == Short.TYPE) {
            return SHORT_ARRAY_TO_COLLECTION_COERCER;
        }
        if (componentType == Integer.TYPE) {
            return INT_ARRAY_TO_COLLECTION_COERCER;
        }
        if (componentType == Long.TYPE) {
            return LONG_ARRAY_TO_COLLECTION_COERCER;
        }
        if (componentType == Float.TYPE) {
            return FLOAT_ARRAY_TO_COLLECTION_COERCER;
        }
        if (componentType == Double.TYPE) {
            return DOUBLE_ARRAY_TO_COLLECTION_COERCER;
        }
        if (componentType == Boolean.TYPE) {
            return BOOLEAN_ARRAY_TO_COLLECTION_COERCER;
        }
        if (componentType == Character.TYPE) {
            return CHAR_ARRAY_TO_COLLECTION_COERCER;
        }
        throw new IllegalStateException("Unrecognized class " + componentType);
    }

    protected static CodegenExpression codegenWidenArrayAsListMayNull(CodegenExpression expression, Class arrayType, CodegenMethodScope codegenMethodScope, Class generator, CodegenClassScope codegenClassScope) {
        CodegenMethodNode method = codegenMethodScope.makeChild(Collection.class, generator, codegenClassScope).addParam(Object.class, "input").getBlock().ifRefNullReturnNull("input").methodReturn(CodegenExpressionBuilder.staticMethod(Arrays.class, "asList", CodegenExpressionBuilder.cast(arrayType, (CodegenExpression)CodegenExpressionBuilder.ref("input"))));
        return CodegenExpressionBuilder.localMethodBuild(method).pass(expression).call();
    }

    private static class TypeWidenerByteArrayToByteBufferCoercer
    implements TypeWidener {
        private TypeWidenerByteArrayToByteBufferCoercer() {
        }

        @Override
        public Object widen(Object input) {
            return input == null ? null : ByteBuffer.wrap((byte[])input);
        }

        @Override
        public CodegenExpression widenCodegen(CodegenExpression expression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            CodegenMethodNode method = codegenMethodScope.makeChild(ByteBuffer.class, TypeWidenerByteArrayToByteBufferCoercer.class, codegenClassScope).addParam(Object.class, "input").getBlock().ifRefNullReturnNull("input").methodReturn(CodegenExpressionBuilder.staticMethod(ByteBuffer.class, "wrap", CodegenExpressionBuilder.cast(byte[].class, (CodegenExpression)CodegenExpressionBuilder.ref("input"))));
            return CodegenExpressionBuilder.localMethodBuild(method).pass(expression).call();
        }
    }

    private static class TypeWidenerCharArrayToCollectionCoercer
    implements TypeWidener {
        private TypeWidenerCharArrayToCollectionCoercer() {
        }

        @Override
        public Object widen(Object input) {
            return input == null ? null : Arrays.asList(new char[][]{(char[])input});
        }

        @Override
        public CodegenExpression widenCodegen(CodegenExpression expression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return TypeWidenerFactory.codegenWidenArrayAsListMayNull(expression, char[].class, codegenMethodScope, TypeWidenerCharArrayToCollectionCoercer.class, codegenClassScope);
        }
    }

    private static class TypeWidenerBooleanArrayToCollectionCoercer
    implements TypeWidener {
        private TypeWidenerBooleanArrayToCollectionCoercer() {
        }

        @Override
        public Object widen(Object input) {
            return input == null ? null : Arrays.asList(new boolean[][]{(boolean[])input});
        }

        @Override
        public CodegenExpression widenCodegen(CodegenExpression expression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return TypeWidenerFactory.codegenWidenArrayAsListMayNull(expression, boolean[].class, codegenMethodScope, TypeWidenerBooleanArrayToCollectionCoercer.class, codegenClassScope);
        }
    }

    private static class TypeWidenerDoubleArrayToCollectionCoercer
    implements TypeWidener {
        private TypeWidenerDoubleArrayToCollectionCoercer() {
        }

        @Override
        public Object widen(Object input) {
            return input == null ? null : Arrays.asList(new double[][]{(double[])input});
        }

        @Override
        public CodegenExpression widenCodegen(CodegenExpression expression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return TypeWidenerFactory.codegenWidenArrayAsListMayNull(expression, double[].class, codegenMethodScope, TypeWidenerDoubleArrayToCollectionCoercer.class, codegenClassScope);
        }
    }

    private static class TypeWidenerFloatArrayToCollectionCoercer
    implements TypeWidener {
        private TypeWidenerFloatArrayToCollectionCoercer() {
        }

        @Override
        public Object widen(Object input) {
            return input == null ? null : Arrays.asList(new float[][]{(float[])input});
        }

        @Override
        public CodegenExpression widenCodegen(CodegenExpression expression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return TypeWidenerFactory.codegenWidenArrayAsListMayNull(expression, float[].class, codegenMethodScope, TypeWidenerFloatArrayToCollectionCoercer.class, codegenClassScope);
        }
    }

    private static class TypeWidenerLongArrayToCollectionCoercer
    implements TypeWidener {
        private TypeWidenerLongArrayToCollectionCoercer() {
        }

        @Override
        public Object widen(Object input) {
            return input == null ? null : Arrays.asList(new long[][]{(long[])input});
        }

        @Override
        public CodegenExpression widenCodegen(CodegenExpression expression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return TypeWidenerFactory.codegenWidenArrayAsListMayNull(expression, long[].class, codegenMethodScope, TypeWidenerLongArrayToCollectionCoercer.class, codegenClassScope);
        }
    }

    private static class TypeWidenerIntArrayToCollectionCoercer
    implements TypeWidener {
        private TypeWidenerIntArrayToCollectionCoercer() {
        }

        @Override
        public Object widen(Object input) {
            return input == null ? null : Arrays.asList(new int[][]{(int[])input});
        }

        @Override
        public CodegenExpression widenCodegen(CodegenExpression expression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return TypeWidenerFactory.codegenWidenArrayAsListMayNull(expression, int[].class, codegenMethodScope, TypeWidenerIntArrayToCollectionCoercer.class, codegenClassScope);
        }
    }

    private static class TypeWidenerShortArrayToCollectionCoercer
    implements TypeWidener {
        private TypeWidenerShortArrayToCollectionCoercer() {
        }

        @Override
        public Object widen(Object input) {
            return input == null ? null : Arrays.asList(new short[][]{(short[])input});
        }

        @Override
        public CodegenExpression widenCodegen(CodegenExpression expression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return TypeWidenerFactory.codegenWidenArrayAsListMayNull(expression, short[].class, codegenMethodScope, TypeWidenerShortArrayToCollectionCoercer.class, codegenClassScope);
        }
    }

    private static class TypeWidenerByteArrayToCollectionCoercer
    implements TypeWidener {
        private TypeWidenerByteArrayToCollectionCoercer() {
        }

        @Override
        public Object widen(Object input) {
            return input == null ? null : Arrays.asList(new byte[][]{(byte[])input});
        }

        @Override
        public CodegenExpression widenCodegen(CodegenExpression expression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return TypeWidenerFactory.codegenWidenArrayAsListMayNull(expression, byte[].class, codegenMethodScope, TypeWidenerByteArrayToCollectionCoercer.class, codegenClassScope);
        }
    }
}

