/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberBigDecimalCoercer;
import com.espertech.esper.util.SimpleNumberBigIntegerCoercer;
import com.espertech.esper.util.SimpleNumberCoercer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SimpleNumberCoercerFactory {
    public static SimpleNumberBigDecimalCoercer getCoercerBigDecimal(Class fromType) {
        if (fromType == BigDecimal.class) {
            return SimpleNumberCoercerBigDecNull.INSTANCE;
        }
        if (JavaClassHelper.isFloatingPointClass(fromType)) {
            return SimpleNumberCoercerBigDecDouble.INSTANCE;
        }
        return SimpleNumberCoercerBigDecLong.INSTANCE;
    }

    public static SimpleNumberBigIntegerCoercer getCoercerBigInteger(Class fromType) {
        if (fromType == BigInteger.class) {
            return SimpleNumberCoercerBigIntNull.INSTANCE;
        }
        return SimpleNumberCoercerBigInt.INSTANCE;
    }

    public static SimpleNumberCoercer getCoercer(Class fromType, Class resultBoxedType) {
        if (fromType == resultBoxedType) {
            return SimpleNumberCoercerNull.INSTANCE;
        }
        if (resultBoxedType == Double.class) {
            return SimpleNumberCoercerDouble.INSTANCE;
        }
        if (resultBoxedType == Long.class) {
            return SimpleNumberCoercerLong.INSTANCE;
        }
        if (resultBoxedType == Float.class) {
            return SimpleNumberCoercerFloat.INSTANCE;
        }
        if (resultBoxedType == Integer.class) {
            return SimpleNumberCoercerInt.INSTANCE;
        }
        if (resultBoxedType == Short.class) {
            return SimpleNumberCoercerShort.INSTANCE;
        }
        if (resultBoxedType == Byte.class) {
            return SimpleNumberCoercerByte.INSTANCE;
        }
        if (resultBoxedType == BigInteger.class) {
            return SimpleNumberCoercerBigInt.INSTANCE;
        }
        if (resultBoxedType == BigDecimal.class) {
            if (JavaClassHelper.isFloatingPointClass(fromType)) {
                return SimpleNumberCoercerBigDecDouble.INSTANCE;
            }
            return SimpleNumberCoercerBigDecLong.INSTANCE;
        }
        if (resultBoxedType == Object.class || resultBoxedType == Number.class) {
            return SimpleNumberCoercerNull.INSTANCE;
        }
        throw new IllegalArgumentException("Cannot coerce to number subtype " + resultBoxedType.getName());
    }

    private static CodegenExpression codegenCoerceNonNull(Class primitive, Class boxed, String numberValueMethodName, CodegenExpression param, Class type) {
        if (type == primitive || type == boxed) {
            return param;
        }
        if (type.isPrimitive()) {
            return CodegenExpressionBuilder.cast(primitive, param);
        }
        return CodegenExpressionBuilder.exprDotMethod(param, numberValueMethodName, new CodegenExpression[0]);
    }

    private static CodegenExpression codegenCoerceMayNull(Class primitive, Class boxed, String numberValueMethodName, CodegenExpression param, Class type, CodegenMethodScope codegenMethodScope, Class generator, CodegenClassScope codegenClassScope) {
        if (type == primitive || type == boxed) {
            return param;
        }
        if (type == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        if (type.isPrimitive()) {
            return CodegenExpressionBuilder.cast(primitive, param);
        }
        CodegenMethodNode method = codegenMethodScope.makeChild(boxed, generator, codegenClassScope).addParam(type, "value").getBlock().ifRefNullReturnNull("value").methodReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("value"), numberValueMethodName, new CodegenExpression[0]));
        return CodegenExpressionBuilder.localMethod(method, param);
    }

    private static class SimpleNumberCoercerBigDecNull
    implements SimpleNumberCoercer,
    SimpleNumberBigDecimalCoercer {
        public static final SimpleNumberCoercerBigDecNull INSTANCE = new SimpleNumberCoercerBigDecNull();

        private SimpleNumberCoercerBigDecNull() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce;
        }

        @Override
        public BigDecimal coerceBoxedBigDec(Number numToCoerce) {
            return (BigDecimal)numToCoerce;
        }

        @Override
        public Class getReturnType() {
            return Number.class;
        }

        @Override
        public CodegenExpression coerceCodegen(CodegenExpression value, Class valueType) {
            return value;
        }

        @Override
        public CodegenExpression coerceBoxedBigDecCodegen(CodegenExpression expr, Class type) {
            return expr;
        }

        @Override
        public CodegenExpression coerceCodegenMayNullBoxed(CodegenExpression value, Class valueType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return value;
        }
    }

    private static class SimpleNumberCoercerBigIntNull
    implements SimpleNumberCoercer,
    SimpleNumberBigIntegerCoercer {
        public static final SimpleNumberCoercerBigIntNull INSTANCE = new SimpleNumberCoercerBigIntNull();

        private SimpleNumberCoercerBigIntNull() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce;
        }

        @Override
        public BigInteger coerceBoxedBigInt(Number numToCoerce) {
            return (BigInteger)numToCoerce;
        }

        @Override
        public Class getReturnType() {
            return Number.class;
        }

        @Override
        public CodegenExpression coerceCodegen(CodegenExpression value, Class valueType) {
            return value;
        }

        @Override
        public CodegenExpression coerceBoxedBigIntCodegen(CodegenExpression expr, Class type) {
            return expr;
        }

        @Override
        public CodegenExpression coerceCodegenMayNullBoxed(CodegenExpression value, Class valueType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return value;
        }
    }

    public static class SimpleNumberCoercerBigDecDouble
    implements SimpleNumberCoercer,
    SimpleNumberBigDecimalCoercer {
        public static final SimpleNumberCoercerBigDecDouble INSTANCE = new SimpleNumberCoercerBigDecDouble();

        private SimpleNumberCoercerBigDecDouble() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return new BigDecimal(numToCoerce.doubleValue());
        }

        @Override
        public BigDecimal coerceBoxedBigDec(Number numToCoerce) {
            return new BigDecimal(numToCoerce.doubleValue());
        }

        @Override
        public Class getReturnType() {
            return Double.class;
        }

        @Override
        public CodegenExpression coerceCodegen(CodegenExpression value, Class valueType) {
            return SimpleNumberCoercerBigDecDouble.codegenBigDec(value, valueType);
        }

        @Override
        public CodegenExpression coerceBoxedBigDecCodegen(CodegenExpression expr, Class type) {
            return this.coerceCodegen(expr, type);
        }

        @Override
        public CodegenExpression coerceCodegenMayNullBoxed(CodegenExpression value, Class valueType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (valueType == null) {
                return value;
            }
            if (valueType.isPrimitive()) {
                return SimpleNumberCoercerBigDecDouble.codegenBigDec(value, valueType);
            }
            if (valueType == BigDecimal.class) {
                return value;
            }
            CodegenMethodNode method = codegenMethodScope.makeChild(BigDecimal.class, SimpleNumberCoercerBigDecDouble.class, codegenClassScope).addParam(valueType, "value").getBlock().ifRefNullReturnNull("value").methodReturn(SimpleNumberCoercerBigDecDouble.codegenBigDec(CodegenExpressionBuilder.ref("value"), valueType));
            return CodegenExpressionBuilder.localMethod(method, value);
        }

        public static CodegenExpression codegenBigDec(CodegenExpression value, Class valueType) {
            if (valueType == BigDecimal.class) {
                return value;
            }
            if (valueType == Double.TYPE || valueType == Double.class) {
                return CodegenExpressionBuilder.newInstance(BigDecimal.class, value);
            }
            if (valueType.isPrimitive()) {
                return CodegenExpressionBuilder.newInstance(BigDecimal.class, CodegenExpressionBuilder.cast(Double.TYPE, value));
            }
            return CodegenExpressionBuilder.newInstance(BigDecimal.class, CodegenExpressionBuilder.exprDotMethod(value, "doubleValue", new CodegenExpression[0]));
        }
    }

    public static class SimpleNumberCoercerBigDecLong
    implements SimpleNumberCoercer,
    SimpleNumberBigDecimalCoercer {
        public static final SimpleNumberCoercerBigDecLong INSTANCE = new SimpleNumberCoercerBigDecLong();

        private SimpleNumberCoercerBigDecLong() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return new BigDecimal(numToCoerce.longValue());
        }

        @Override
        public BigDecimal coerceBoxedBigDec(Number numToCoerce) {
            return new BigDecimal(numToCoerce.longValue());
        }

        @Override
        public Class getReturnType() {
            return Long.class;
        }

        @Override
        public CodegenExpression coerceCodegen(CodegenExpression value, Class valueType) {
            return SimpleNumberCoercerBigDecLong.codegenBigDec(value, valueType);
        }

        @Override
        public CodegenExpression coerceBoxedBigDecCodegen(CodegenExpression expr, Class type) {
            return this.coerceCodegen(expr, type);
        }

        @Override
        public CodegenExpression coerceCodegenMayNullBoxed(CodegenExpression value, Class valueType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (valueType == null) {
                return value;
            }
            if (valueType.isPrimitive()) {
                return SimpleNumberCoercerBigDecLong.codegenBigDec(value, valueType);
            }
            if (valueType == BigDecimal.class) {
                return value;
            }
            CodegenMethodNode method = codegenMethodScope.makeChild(BigDecimal.class, SimpleNumberCoercerBigDecLong.class, codegenClassScope).addParam(valueType, "value").getBlock().ifRefNullReturnNull("value").methodReturn(SimpleNumberCoercerBigDecLong.codegenBigDec(CodegenExpressionBuilder.ref("value"), valueType));
            return CodegenExpressionBuilder.localMethod(method, value);
        }

        public static CodegenExpression codegenBigDec(CodegenExpression value, Class valueType) {
            if (valueType == BigDecimal.class) {
                return value;
            }
            if (valueType == Long.TYPE || valueType == Long.class) {
                return CodegenExpressionBuilder.newInstance(BigDecimal.class, value);
            }
            if (valueType.isPrimitive()) {
                return CodegenExpressionBuilder.newInstance(BigDecimal.class, CodegenExpressionBuilder.cast(Long.TYPE, value));
            }
            return CodegenExpressionBuilder.newInstance(BigDecimal.class, CodegenExpressionBuilder.exprDotMethod(value, "longValue", new CodegenExpression[0]));
        }
    }

    public static class SimpleNumberCoercerBigInt
    implements SimpleNumberCoercer,
    SimpleNumberBigIntegerCoercer {
        public static final SimpleNumberCoercerBigInt INSTANCE = new SimpleNumberCoercerBigInt();

        private SimpleNumberCoercerBigInt() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return BigInteger.valueOf(numToCoerce.longValue());
        }

        @Override
        public BigInteger coerceBoxedBigInt(Number numToCoerce) {
            return BigInteger.valueOf(numToCoerce.longValue());
        }

        @Override
        public Class getReturnType() {
            return Long.class;
        }

        @Override
        public CodegenExpression coerceCodegen(CodegenExpression value, Class valueType) {
            return SimpleNumberCoercerBigInt.codegenBigInt(value, valueType);
        }

        @Override
        public CodegenExpression coerceBoxedBigIntCodegen(CodegenExpression expr, Class type) {
            return this.coerceCodegen(expr, type);
        }

        @Override
        public CodegenExpression coerceCodegenMayNullBoxed(CodegenExpression value, Class valueType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (valueType == null) {
                return value;
            }
            if (valueType.isPrimitive()) {
                return SimpleNumberCoercerBigInt.codegenBigInt(value, valueType);
            }
            if (valueType == BigInteger.class) {
                return value;
            }
            CodegenMethodNode method = codegenMethodScope.makeChild(BigInteger.class, SimpleNumberCoercerBigInt.class, codegenClassScope).addParam(valueType, "value").getBlock().ifRefNullReturnNull("value").methodReturn(SimpleNumberCoercerBigInt.codegenBigInt(CodegenExpressionBuilder.ref("value"), valueType));
            return CodegenExpressionBuilder.localMethod(method, value);
        }

        public static CodegenExpression codegenBigInt(CodegenExpression value, Class valueType) {
            if (valueType == BigInteger.class) {
                return value;
            }
            if (valueType == Long.TYPE || valueType == Long.class) {
                return CodegenExpressionBuilder.staticMethod(BigInteger.class, "valueOf", value);
            }
            if (valueType.isPrimitive()) {
                return CodegenExpressionBuilder.staticMethod(BigInteger.class, "valueOf", CodegenExpressionBuilder.cast(Long.TYPE, value));
            }
            return CodegenExpressionBuilder.staticMethod(BigInteger.class, "valueOf", CodegenExpressionBuilder.exprDotMethod(value, "longValue", new CodegenExpression[0]));
        }
    }

    public static class SimpleNumberCoercerByte
    implements SimpleNumberCoercer {
        public static final SimpleNumberCoercerByte INSTANCE = new SimpleNumberCoercerByte();

        private SimpleNumberCoercerByte() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce.byteValue();
        }

        @Override
        public Class getReturnType() {
            return Byte.class;
        }

        @Override
        public CodegenExpression coerceCodegen(CodegenExpression value, Class valueType) {
            return SimpleNumberCoercerByte.codegenByte(value, valueType);
        }

        @Override
        public CodegenExpression coerceCodegenMayNullBoxed(CodegenExpression value, Class valueType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return SimpleNumberCoercerFactory.codegenCoerceMayNull(Byte.TYPE, Byte.class, "bteValue", value, valueType, codegenMethodScope, SimpleNumberCoercerByte.class, codegenClassScope);
        }

        public static CodegenExpression codegenByte(CodegenExpression input, Class inputType) {
            return SimpleNumberCoercerFactory.codegenCoerceNonNull(Byte.TYPE, Byte.class, "byteValue", input, inputType);
        }
    }

    public static class SimpleNumberCoercerShort
    implements SimpleNumberCoercer {
        public static final SimpleNumberCoercerShort INSTANCE = new SimpleNumberCoercerShort();

        private SimpleNumberCoercerShort() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce.shortValue();
        }

        @Override
        public Class getReturnType() {
            return Short.class;
        }

        @Override
        public CodegenExpression coerceCodegen(CodegenExpression value, Class valueType) {
            return SimpleNumberCoercerShort.codegenShort(value, valueType);
        }

        @Override
        public CodegenExpression coerceCodegenMayNullBoxed(CodegenExpression value, Class valueType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return SimpleNumberCoercerFactory.codegenCoerceMayNull(Short.TYPE, Short.class, "shortValue", value, valueType, codegenMethodScope, SimpleNumberCoercerShort.class, codegenClassScope);
        }

        public static CodegenExpression codegenShort(CodegenExpression input, Class inputType) {
            return SimpleNumberCoercerFactory.codegenCoerceNonNull(Short.TYPE, Short.class, "shortValue", input, inputType);
        }
    }

    public static class SimpleNumberCoercerFloat
    implements SimpleNumberCoercer {
        public static final SimpleNumberCoercerFloat INSTANCE = new SimpleNumberCoercerFloat();

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return Float.valueOf(numToCoerce.floatValue());
        }

        private SimpleNumberCoercerFloat() {
        }

        @Override
        public Class getReturnType() {
            return Float.class;
        }

        public static CodegenExpression codegenFloat(CodegenExpression ref, Class type) {
            return SimpleNumberCoercerFactory.codegenCoerceNonNull(Float.TYPE, Float.class, "floatValue", ref, type);
        }

        @Override
        public CodegenExpression coerceCodegen(CodegenExpression value, Class valueType) {
            return SimpleNumberCoercerFloat.codegenFloat(value, valueType);
        }

        @Override
        public CodegenExpression coerceCodegenMayNullBoxed(CodegenExpression value, Class valueType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return SimpleNumberCoercerFactory.codegenCoerceMayNull(Float.TYPE, Float.class, "floatValue", value, valueType, codegenMethodScope, SimpleNumberCoercerFloat.class, codegenClassScope);
        }
    }

    public static class SimpleNumberCoercerInt
    implements SimpleNumberCoercer {
        public static final SimpleNumberCoercerInt INSTANCE = new SimpleNumberCoercerInt();

        private SimpleNumberCoercerInt() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce.intValue();
        }

        @Override
        public Class getReturnType() {
            return Integer.class;
        }

        public static CodegenExpression codegenInt(CodegenExpression param, Class type) {
            return SimpleNumberCoercerFactory.codegenCoerceNonNull(Integer.TYPE, Integer.class, "intValue", param, type);
        }

        @Override
        public CodegenExpression coerceCodegen(CodegenExpression value, Class valueType) {
            return SimpleNumberCoercerInt.codegenInt(value, valueType);
        }

        @Override
        public CodegenExpression coerceCodegenMayNullBoxed(CodegenExpression param, Class type, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return SimpleNumberCoercerFactory.codegenCoerceMayNull(Integer.TYPE, Integer.class, "intValue", param, type, codegenMethodScope, SimpleNumberCoercerInt.class, codegenClassScope);
        }

        public static CodegenExpression coerceCodegenMayNull(CodegenExpression param, Class type, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return SimpleNumberCoercerFactory.codegenCoerceMayNull(Integer.TYPE, Integer.class, "intValue", param, type, codegenMethodScope, SimpleNumberCoercerInt.class, codegenClassScope);
        }
    }

    public static class SimpleNumberCoercerLong
    implements SimpleNumberCoercer {
        public static final SimpleNumberCoercerLong INSTANCE = new SimpleNumberCoercerLong();

        private SimpleNumberCoercerLong() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce.longValue();
        }

        @Override
        public Class getReturnType() {
            return Long.class;
        }

        public static CodegenExpression codegenLong(CodegenExpression param, Class type) {
            return SimpleNumberCoercerFactory.codegenCoerceNonNull(Long.TYPE, Long.class, "longValue", param, type);
        }

        public static CodegenExpression codegenLongMayNullBox(CodegenExpression param, Class type, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return SimpleNumberCoercerFactory.codegenCoerceMayNull(Long.TYPE, Long.class, "longValue", param, type, codegenMethodScope, SimpleNumberCoercerLong.class, codegenClassScope);
        }

        @Override
        public CodegenExpression coerceCodegen(CodegenExpression value, Class valueType) {
            return SimpleNumberCoercerLong.codegenLong(value, valueType);
        }

        @Override
        public CodegenExpression coerceCodegenMayNullBoxed(CodegenExpression param, Class type, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return SimpleNumberCoercerLong.codegenLongMayNullBox(param, type, codegenMethodScope, codegenClassScope);
        }
    }

    public static class SimpleNumberCoercerDouble
    implements SimpleNumberCoercer {
        public static final SimpleNumberCoercerDouble INSTANCE = new SimpleNumberCoercerDouble();

        private SimpleNumberCoercerDouble() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce.doubleValue();
        }

        @Override
        public Class getReturnType() {
            return Double.class;
        }

        public static CodegenExpression codegenDouble(CodegenExpression param, Class type) {
            return SimpleNumberCoercerFactory.codegenCoerceNonNull(Double.TYPE, Double.class, "doubleValue", param, type);
        }

        @Override
        public CodegenExpression coerceCodegen(CodegenExpression value, Class valueType) {
            return SimpleNumberCoercerDouble.codegenDouble(value, valueType);
        }

        @Override
        public CodegenExpression coerceCodegenMayNullBoxed(CodegenExpression param, Class type, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return SimpleNumberCoercerFactory.codegenCoerceMayNull(Double.TYPE, Double.class, "doubleValue", param, type, codegenMethodScope, SimpleNumberCoercerDouble.class, codegenClassScope);
        }

        public static CodegenExpression codegenDoubleMayNullBoxedIncludeBig(CodegenExpression value, Class valueType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (valueType == BigInteger.class || valueType == BigDecimal.class) {
                return CodegenExpressionBuilder.exprDotMethod(value, "doubleValue", new CodegenExpression[0]);
            }
            return SimpleNumberCoercerFactory.codegenCoerceMayNull(Double.TYPE, Double.class, "doubleValue", value, valueType, codegenMethodScope, SimpleNumberCoercerDouble.class, codegenClassScope);
        }
    }

    private static class SimpleNumberCoercerNull
    implements SimpleNumberCoercer {
        public static final SimpleNumberCoercerNull INSTANCE = new SimpleNumberCoercerNull();

        private SimpleNumberCoercerNull() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce;
        }

        @Override
        public Class getReturnType() {
            return Number.class;
        }

        @Override
        public CodegenExpression coerceCodegen(CodegenExpression value, Class valueType) {
            return value;
        }

        @Override
        public CodegenExpression coerceCodegenMayNullBoxed(CodegenExpression value, Class valueType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return value;
        }
    }
}

