/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class FileUtil {
    public static String findClasspathFile(String filename) {
        URL url = FileUtil.class.getClassLoader().getResource(filename);
        if (url != null) {
            return url.getFile();
        }
        return null;
    }

    public static void findDeleteClasspathFile(String filename) {
        URL url = FileUtil.class.getClassLoader().getResource(filename);
        if (url != null) {
            File file = new File(url.getFile());
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readClasspathTextFile(String filename) {
        String filenameCp = FileUtil.findClasspathFile(filename);
        if (filenameCp == null) {
            throw new RuntimeException("Failed to find file '" + filename + "' in classpath");
        }
        ArrayList<String> lines = new ArrayList<String>();
        try {
            FileInputStream fis = new FileInputStream(filenameCp);
            Scanner scanner = new Scanner(fis);
            try {
                while (scanner.hasNextLine()) {
                    lines.add(scanner.nextLine());
                }
            }
            finally {
                scanner.close();
                fis.close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to read file '" + filename + "': " + ex.getMessage(), ex);
        }
        return lines.toArray(new String[lines.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(File file) throws IOException {
        String newline = System.getProperty("line.separator");
        FileReader fr = new FileReader(file);
        try {
            String strLine;
            BufferedReader br = new BufferedReader(fr);
            StringWriter buffer = new StringWriter();
            while ((strLine = br.readLine()) != null) {
                buffer.append(strLine);
                buffer.append(newline);
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            try {
                fr.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFile(InputStream is) {
        InputStreamReader isr = new InputStreamReader(is);
        try {
            List<String> list = FileUtil.readFile(isr);
            return list;
        }
        finally {
            try {
                isr.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static List<String> readFile(Reader reader) {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(reader);
            FileUtil.readFile(bufferedReader, list);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File not found: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("IO Error reading file: " + e.getMessage(), e);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return list;
    }

    public static String linesToText(List<String> lines) {
        StringWriter writer = new StringWriter();
        for (String line : lines) {
            writer.append(line).append(System.getProperty("line.separator"));
        }
        return writer.toString();
    }

    private static void readFile(BufferedReader reader, List<String> list) throws IOException {
        String text;
        while ((text = reader.readLine()) != null) {
            list.add(text);
        }
    }
}

