/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.timer;

import com.espertech.esper.timer.TimerCallback;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EPLTimerTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(EPLTimerTask.class);
    private final TimerCallback callback;
    private ScheduledFuture<?> future;
    private boolean isCancelled;
    protected boolean enableStats;
    protected long lastDrift;
    protected long maxDrift;
    protected long totalDrift;
    protected long invocationCount;

    public EPLTimerTask(TimerCallback callback) {
        this.callback = callback;
        this.enableStats = false;
        this.lastDrift = 0L;
        this.maxDrift = 0L;
        this.totalDrift = 0L;
        this.invocationCount = 0L;
    }

    @Override
    public final void run() {
        if (!this.isCancelled) {
            if (this.enableStats) {
                if (this.future != null) {
                    this.lastDrift = Math.abs(this.future.getDelay(TimeUnit.MILLISECONDS));
                }
                this.totalDrift += this.lastDrift;
                ++this.invocationCount;
                if (this.lastDrift > this.maxDrift) {
                    this.maxDrift = this.lastDrift;
                }
            }
            try {
                this.callback.timerCallback();
            }
            catch (Throwable t) {
                log.error("Timer thread caught unhandled exception: " + t.getMessage(), t);
            }
        }
    }

    protected void resetStats() {
        this.invocationCount = 0L;
        this.lastDrift = 0L;
        this.totalDrift = 0L;
        this.maxDrift = 0L;
    }

    public void setCancelled(boolean cancelled) {
        this.isCancelled = cancelled;
    }

    public void setFuture(ScheduledFuture<?> future) {
        this.future = future;
    }
}

