/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.spatial.quadtree.mxcifrowindex;

import com.espertech.esper.spatial.quadtree.core.BoundingBox;
import com.espertech.esper.spatial.quadtree.mxcif.MXCIFQuadTree;
import com.espertech.esper.spatial.quadtree.mxcif.MXCIFQuadTreeNode;
import com.espertech.esper.spatial.quadtree.mxcif.MXCIFQuadTreeNodeBranch;
import com.espertech.esper.spatial.quadtree.mxcif.MXCIFQuadTreeNodeLeaf;
import com.espertech.esper.spatial.quadtree.mxcifrowindex.XYWHRectangleMultiType;
import java.util.ArrayDeque;
import java.util.Collection;

public class MXCIFQuadTreeRowIndexQuery {
    public static Collection<Object> queryRange(MXCIFQuadTree<Object> quadTree, double x, double y, double width, double height) {
        return MXCIFQuadTreeRowIndexQuery.queryNode(quadTree.getRoot(), x, y, width, height, null);
    }

    private static Collection<Object> queryNode(MXCIFQuadTreeNode<Object> node, double x, double y, double width, double height, Collection<Object> result) {
        if (node instanceof MXCIFQuadTreeNodeLeaf) {
            MXCIFQuadTreeNodeLeaf leaf = (MXCIFQuadTreeNodeLeaf)node;
            return MXCIFQuadTreeRowIndexQuery.visit(leaf, x, y, width, height, result);
        }
        MXCIFQuadTreeNodeBranch branch = (MXCIFQuadTreeNodeBranch)node;
        result = MXCIFQuadTreeRowIndexQuery.visit(branch, x, y, width, height, result);
        result = MXCIFQuadTreeRowIndexQuery.queryNode(branch.getNw(), x, y, width, height, result);
        result = MXCIFQuadTreeRowIndexQuery.queryNode(branch.getNe(), x, y, width, height, result);
        result = MXCIFQuadTreeRowIndexQuery.queryNode(branch.getSw(), x, y, width, height, result);
        result = MXCIFQuadTreeRowIndexQuery.queryNode(branch.getSe(), x, y, width, height, result);
        return result;
    }

    private static Collection<Object> visit(MXCIFQuadTreeNode<Object> node, double x, double y, double width, double height, Collection<Object> result) {
        Object data = node.getData();
        if (data == null) {
            return result;
        }
        if (data instanceof XYWHRectangleMultiType) {
            XYWHRectangleMultiType point = (XYWHRectangleMultiType)data;
            return MXCIFQuadTreeRowIndexQuery.visit(point, x, y, width, height, result);
        }
        Collection collection = (Collection)data;
        for (XYWHRectangleMultiType rectangle : collection) {
            result = MXCIFQuadTreeRowIndexQuery.visit(rectangle, x, y, width, height, result);
        }
        return result;
    }

    private static Collection<Object> visit(XYWHRectangleMultiType rectangle, double x, double y, double width, double height, Collection<Object> result) {
        if (!BoundingBox.intersectsBoxIncludingEnd(x, y, x + width, y + height, rectangle.getX(), rectangle.getY(), rectangle.getW(), rectangle.getH())) {
            return result;
        }
        if (result == null) {
            result = new ArrayDeque<Object>(4);
        }
        rectangle.collectInto(result);
        return result;
    }
}

