/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.spatial.quadtree.mxciffilterindex;

import com.espertech.esper.filter.FilterHandleSetNode;
import com.espertech.esper.filter.FilterParamIndexBase;
import com.espertech.esper.spatial.quadtree.mxcif.MXCIFQuadTree;
import com.espertech.esper.spatial.quadtree.mxcif.MXCIFQuadTreeNode;
import com.espertech.esper.spatial.quadtree.mxcif.MXCIFQuadTreeNodeBranch;
import com.espertech.esper.spatial.quadtree.mxcif.MXCIFQuadTreeNodeLeaf;
import com.espertech.esper.spatial.quadtree.mxciffilterindex.XYWHRectangleWValue;
import java.util.Collection;

public class MXCIFQuadTreeFilterIndexCount {
    public static int count(MXCIFQuadTree<Object> quadTree) {
        return MXCIFQuadTreeFilterIndexCount.count(quadTree.getRoot());
    }

    private static int count(MXCIFQuadTreeNode<Object> node) {
        if (node instanceof MXCIFQuadTreeNodeLeaf) {
            MXCIFQuadTreeNodeLeaf leaf = (MXCIFQuadTreeNodeLeaf)node;
            return MXCIFQuadTreeFilterIndexCount.countData(leaf.getData());
        }
        MXCIFQuadTreeNodeBranch branch = (MXCIFQuadTreeNodeBranch)node;
        return MXCIFQuadTreeFilterIndexCount.count(branch.getNw()) + MXCIFQuadTreeFilterIndexCount.count(branch.getNe()) + MXCIFQuadTreeFilterIndexCount.count(branch.getSw()) + MXCIFQuadTreeFilterIndexCount.count(branch.getSe()) + MXCIFQuadTreeFilterIndexCount.countData(branch.getData());
    }

    private static int countData(Object data) {
        if (data == null) {
            return 0;
        }
        if (data instanceof XYWHRectangleWValue) {
            return MXCIFQuadTreeFilterIndexCount.countCallbacks(data);
        }
        Collection coll = (Collection)data;
        int count = 0;
        for (XYWHRectangleWValue p : coll) {
            count += MXCIFQuadTreeFilterIndexCount.countCallbacks(p.getValue());
        }
        return count;
    }

    private static int countCallbacks(Object points) {
        if (points instanceof FilterHandleSetNode) {
            return ((FilterHandleSetNode)points).getFilterCallbackCount();
        }
        if (points instanceof FilterParamIndexBase) {
            return ((FilterParamIndexBase)points).sizeExpensive();
        }
        return 1;
    }
}

