/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern.observer;

import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.EngineLevelExtensionServicesContext;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.filterspec.MatchedEventMap;
import com.espertech.esper.pattern.observer.EventObserver;
import com.espertech.esper.pattern.observer.EventObserverVisitor;
import com.espertech.esper.pattern.observer.ObserverEventEvaluator;
import com.espertech.esper.schedule.ScheduleComputeHelper;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSpec;
import com.espertech.esper.schedule.SchedulingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerAtObserver
implements EventObserver,
ScheduleHandleCallback {
    private final ScheduleSpec scheduleSpec;
    private final long scheduleSlot;
    private final MatchedEventMap beginState;
    private final ObserverEventEvaluator observerEventEvaluator;
    private boolean isTimerActive = false;
    private EPStatementHandleCallback scheduleHandle;
    private static final Logger log = LoggerFactory.getLogger(TimerAtObserver.class);

    public TimerAtObserver(ScheduleSpec scheduleSpec, MatchedEventMap beginState, ObserverEventEvaluator observerEventEvaluator) {
        this.scheduleSpec = scheduleSpec;
        this.beginState = beginState;
        this.observerEventEvaluator = observerEventEvaluator;
        this.scheduleSlot = observerEventEvaluator.getContext().getPatternContext().getScheduleBucket().allocateSlot();
    }

    @Override
    public MatchedEventMap getBeginState() {
        return this.beginState;
    }

    @Override
    public final void scheduledTrigger(EngineLevelExtensionServicesContext engineLevelExtensionServicesContext) {
        this.observerEventEvaluator.observerEvaluateTrue(this.beginState, true);
        this.isTimerActive = false;
    }

    @Override
    public void startObserve() {
        if (this.isTimerActive) {
            throw new IllegalStateException("Timer already active");
        }
        this.scheduleHandle = new EPStatementHandleCallback(this.observerEventEvaluator.getContext().getAgentInstanceContext().getEpStatementAgentInstanceHandle(), this);
        SchedulingService schedulingService = this.observerEventEvaluator.getContext().getPatternContext().getSchedulingService();
        EngineImportService engineImportService = this.observerEventEvaluator.getContext().getStatementContext().getEngineImportService();
        long nextScheduledTime = ScheduleComputeHelper.computeDeltaNextOccurance(this.scheduleSpec, schedulingService.getTime(), engineImportService.getTimeZone(), engineImportService.getTimeAbacus());
        schedulingService.add(nextScheduledTime, this.scheduleHandle, this.scheduleSlot);
        this.isTimerActive = true;
    }

    @Override
    public void stopObserve() {
        if (this.isTimerActive) {
            this.observerEventEvaluator.getContext().getPatternContext().getSchedulingService().remove(this.scheduleHandle, this.scheduleSlot);
            this.isTimerActive = false;
            this.scheduleHandle = null;
        }
    }

    @Override
    public void accept(EventObserverVisitor visitor) {
        visitor.visitObserver(this.beginState, 2, this.scheduleSlot, this.scheduleSpec);
    }
}

