/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.filterspec.MatchedEventMap;
import com.espertech.esper.pattern.EvalFollowedByNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.PatternConsumptionUtil;
import java.util.HashMap;
import java.util.Set;

public class EvalFollowedByStateNode
extends EvalStateNode
implements Evaluator {
    protected final EvalFollowedByNode evalFollowedByNode;
    protected final HashMap<EvalStateNode, Integer> nodes;

    public EvalFollowedByStateNode(Evaluator parentNode, EvalFollowedByNode evalFollowedByNode) {
        super(parentNode);
        this.evalFollowedByNode = evalFollowedByNode;
        this.nodes = new HashMap();
    }

    @Override
    public void removeMatch(Set<EventBean> matchEvent) {
        PatternConsumptionUtil.childNodeRemoveMatches(matchEvent, this.nodes.keySet());
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalFollowedByNode;
    }

    @Override
    public final void start(MatchedEventMap beginState) {
        EvalNode child = this.evalFollowedByNode.getChildNodes()[0];
        EvalStateNode childState = child.newState(this, null, 0L);
        this.nodes.put(childState, 0);
        childState.start(beginState);
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted, EventBean optionalTriggeringEvent) {
        Integer index = this.nodes.get(fromNode);
        if (isQuitted) {
            this.nodes.remove(fromNode);
        }
        if (index == null) {
            return;
        }
        int numChildNodes = this.evalFollowedByNode.getChildNodes().length;
        boolean isFollowedByQuitted = false;
        if (index == numChildNodes - 1) {
            if (this.nodes.isEmpty()) {
                isFollowedByQuitted = true;
            }
            this.getParentEvaluator().evaluateTrue(matchEvent, this, isFollowedByQuitted, optionalTriggeringEvent);
        } else {
            EvalNode child = this.evalFollowedByNode.getChildNodes()[index + 1];
            EvalStateNode childState = child.newState(this, null, 0L);
            this.nodes.put(childState, index + 1);
            childState.start(matchEvent);
        }
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode, boolean restartable) {
        fromNode.quit();
        this.nodes.remove(fromNode);
        if (this.nodes.isEmpty()) {
            this.getParentEvaluator().evaluateFalse(this, true);
            this.quitInternal();
        }
    }

    @Override
    public final void quit() {
        if (this.nodes.isEmpty()) {
            return;
        }
        this.quitInternal();
    }

    @Override
    public final void accept(EvalStateNodeVisitor visitor) {
        visitor.visitFollowedBy(this.evalFollowedByNode.getFactoryNode(), this, this.nodes);
        for (EvalStateNode node : this.nodes.keySet()) {
            node.accept(visitor);
        }
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    @Override
    public boolean isObserverStateNodeNonRestarting() {
        return false;
    }

    public final String toString() {
        return "EvalFollowedByStateNode nodes=" + this.nodes.size();
    }

    private final void quitInternal() {
        for (EvalStateNode child : this.nodes.keySet()) {
            child.quit();
        }
        this.nodes.clear();
    }
}

