/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.epl.expression.core.ExprFilterSpecLookupable;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.FilterParamIndexLookupableBase;
import com.espertech.esper.filter.StringRangeComparator;
import com.espertech.esper.filterspec.FilterOperator;
import com.espertech.esper.filterspec.StringRange;
import java.util.IdentityHashMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FilterParamIndexStringRangeBase
extends FilterParamIndexLookupableBase {
    protected final TreeMap<StringRange, EventEvaluator> ranges = new TreeMap(new StringRangeComparator());
    private final IdentityHashMap<StringRange, EventEvaluator> rangesNullEndpoints = new IdentityHashMap();
    private final ReadWriteLock rangesRWLock;
    private static final Logger log = LoggerFactory.getLogger(FilterParamIndexStringRangeBase.class);

    protected FilterParamIndexStringRangeBase(ExprFilterSpecLookupable lookupable, ReadWriteLock readWriteLock, FilterOperator filterOperator) {
        super(filterOperator, lookupable);
        this.rangesRWLock = readWriteLock;
    }

    @Override
    public final EventEvaluator get(Object expressionValue) {
        if (!(expressionValue instanceof StringRange)) {
            throw new IllegalArgumentException("Supplied expressionValue must be of type StringRange");
        }
        StringRange range = (StringRange)expressionValue;
        if (range.getMax() == null || range.getMin() == null) {
            return this.rangesNullEndpoints.get(range);
        }
        return this.ranges.get(range);
    }

    @Override
    public final void put(Object expressionValue, EventEvaluator matcher) {
        if (!(expressionValue instanceof StringRange)) {
            throw new IllegalArgumentException("Supplied expressionValue must be of type DoubleRange");
        }
        StringRange range = (StringRange)expressionValue;
        if (range.getMax() == null || range.getMin() == null) {
            this.rangesNullEndpoints.put(range, matcher);
            return;
        }
        this.ranges.put(range, matcher);
    }

    @Override
    public final void remove(Object filterConstant) {
        StringRange range = (StringRange)filterConstant;
        if (range.getMax() == null || range.getMin() == null) {
            this.rangesNullEndpoints.remove(range);
            return;
        }
        this.ranges.remove(range);
    }

    @Override
    public final int sizeExpensive() {
        return this.ranges.size();
    }

    @Override
    public boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    @Override
    public final ReadWriteLock getReadWriteLock() {
        return this.rangesRWLock;
    }
}

