/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.filterspec.FilterSpecParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FilterParamExprMap {
    private Map<ExprNode, FilterSpecParam> exprNodes = new LinkedHashMap<ExprNode, FilterSpecParam>();
    private Map<FilterSpecParam, ExprNode> specParams = new LinkedHashMap<FilterSpecParam, ExprNode>();

    public void put(ExprNode exprNode, FilterSpecParam param) {
        this.exprNodes.put(exprNode, param);
        if (param != null) {
            this.specParams.put(param, exprNode);
        }
    }

    public List<ExprNode> getUnassignedExpressions() {
        ArrayList<ExprNode> unassigned = new ArrayList<ExprNode>();
        for (Map.Entry<ExprNode, FilterSpecParam> entry : this.exprNodes.entrySet()) {
            if (entry.getValue() != null) continue;
            unassigned.add(entry.getKey());
        }
        return unassigned;
    }

    public int countUnassignedExpressions() {
        int count = 0;
        for (Map.Entry<ExprNode, FilterSpecParam> entry : this.exprNodes.entrySet()) {
            if (entry.getValue() != null) continue;
            ++count;
        }
        return count;
    }

    public Collection<FilterSpecParam> getFilterParams() {
        return this.specParams.keySet();
    }

    public void removeNode(ExprNode node) {
        FilterSpecParam param = this.exprNodes.remove(node);
        if (param != null) {
            this.specParams.remove(param);
        }
    }

    public ExprNode removeEntry(FilterSpecParam param) {
        ExprNode exprNode = this.specParams.get(param);
        if (exprNode == null) {
            throw new IllegalStateException("Not found in collection param: " + param);
        }
        this.specParams.remove(param);
        this.exprNodes.remove(exprNode);
        return exprNode;
    }

    public void removeValue(FilterSpecParam param) {
        ExprNode exprNode = this.specParams.get(param);
        if (exprNode == null) {
            throw new IllegalStateException("Not found in collection param: " + param);
        }
        this.specParams.remove(param);
        this.exprNodes.put(exprNode, null);
    }

    public void clear() {
        this.exprNodes.clear();
        this.specParams.clear();
    }

    public void add(FilterParamExprMap other) {
        this.exprNodes.putAll(other.exprNodes);
        this.specParams.putAll(other.specParams);
    }
}

