/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventType;
import com.espertech.esper.filter.EventTypeIndex;
import com.espertech.esper.filter.EventTypeIndexBuilderIndexLookupablePair;
import com.espertech.esper.filter.EventTypeIndexBuilderValueIndexesPair;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterHandleSetNode;
import com.espertech.esper.filter.FilterServiceEntry;
import com.espertech.esper.filter.FilterServiceGranularLockFactory;
import com.espertech.esper.filter.FilterSet;
import com.espertech.esper.filter.FilterSetEntry;
import com.espertech.esper.filter.IndexTreeBuilder;
import com.espertech.esper.filterspec.FilterValueSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class EventTypeIndexBuilder {
    private final Map<FilterHandle, EventTypeIndexBuilderValueIndexesPair> isolatableCallbacks;
    private final Lock callbacksLock;
    private final EventTypeIndex eventTypeIndex;

    public EventTypeIndexBuilder(EventTypeIndex eventTypeIndex, boolean allowIsolation) {
        this.eventTypeIndex = eventTypeIndex;
        this.callbacksLock = new ReentrantLock();
        this.isolatableCallbacks = allowIsolation ? new HashMap<FilterHandle, EventTypeIndexBuilderValueIndexesPair>() : null;
    }

    public void destroy() {
        this.eventTypeIndex.destroy();
        if (this.isolatableCallbacks != null) {
            this.isolatableCallbacks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FilterServiceEntry add(FilterValueSet filterValueSet, FilterHandle filterCallback, FilterServiceGranularLockFactory lockFactory) {
        EventType eventType = filterValueSet.getEventType();
        FilterHandleSetNode rootNode = this.eventTypeIndex.get(eventType);
        if (rootNode == null) {
            this.callbacksLock.lock();
            try {
                rootNode = this.eventTypeIndex.get(eventType);
                if (rootNode == null) {
                    rootNode = new FilterHandleSetNode(lockFactory.obtainNew());
                    this.eventTypeIndex.add(eventType, rootNode);
                }
            }
            finally {
                this.callbacksLock.unlock();
            }
        }
        ArrayDeque<EventTypeIndexBuilderIndexLookupablePair>[] path = IndexTreeBuilder.add(filterValueSet, filterCallback, rootNode, lockFactory);
        EventTypeIndexBuilderIndexLookupablePair[][] pathArray = new EventTypeIndexBuilderIndexLookupablePair[path.length][];
        for (int i = 0; i < path.length; ++i) {
            pathArray[i] = path[i].toArray(new EventTypeIndexBuilderIndexLookupablePair[path[i].size()]);
        }
        EventTypeIndexBuilderValueIndexesPair pair = new EventTypeIndexBuilderValueIndexesPair(filterValueSet, pathArray);
        if (this.isolatableCallbacks == null) {
            return pair;
        }
        this.callbacksLock.lock();
        try {
            this.isolatableCallbacks.put(filterCallback, pair);
        }
        finally {
            this.callbacksLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(FilterHandle filterCallback, FilterServiceEntry filterServiceEntry) {
        EventType eventType;
        FilterHandleSetNode rootNode;
        EventTypeIndexBuilderValueIndexesPair pair;
        if (this.isolatableCallbacks != null) {
            this.callbacksLock.lock();
            try {
                pair = this.isolatableCallbacks.remove(filterCallback);
            }
            finally {
                this.callbacksLock.unlock();
            }
            if (pair == null) {
                return;
            }
        } else {
            pair = (EventTypeIndexBuilderValueIndexesPair)filterServiceEntry;
        }
        if ((rootNode = this.eventTypeIndex.get(eventType = pair.getFilterValueSet().getEventType())) != null) {
            for (int i = 0; i < pair.getIndexPairs().length; ++i) {
                IndexTreeBuilder.remove(eventType, filterCallback, pair.getIndexPairs()[i], rootNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FilterSet take(Set<Integer> statementIds) {
        if (this.isolatableCallbacks == null) {
            throw new EPException("Operation not supported, please enable isolation in the engine configuration");
        }
        ArrayList<FilterSetEntry> list = new ArrayList<FilterSetEntry>();
        this.callbacksLock.lock();
        try {
            for (Map.Entry<FilterHandle, EventTypeIndexBuilderValueIndexesPair> entry : this.isolatableCallbacks.entrySet()) {
                EventTypeIndexBuilderValueIndexesPair pair = entry.getValue();
                if (!statementIds.contains(entry.getKey().getStatementId())) continue;
                list.add(new FilterSetEntry(entry.getKey(), pair.getFilterValueSet()));
                EventType eventType = pair.getFilterValueSet().getEventType();
                FilterHandleSetNode rootNode = this.eventTypeIndex.get(eventType);
                for (int i = 0; i < pair.getIndexPairs().length; ++i) {
                    IndexTreeBuilder.remove(eventType, entry.getKey(), pair.getIndexPairs()[i], rootNode);
                }
            }
            for (FilterSetEntry removed : list) {
                this.isolatableCallbacks.remove(removed.getHandle());
            }
        }
        finally {
            this.callbacksLock.unlock();
        }
        return new FilterSet(list);
    }

    public void apply(FilterSet filterSet, FilterServiceGranularLockFactory lockFactory) {
        for (FilterSetEntry entry : filterSet.getFilters()) {
            this.add(entry.getFilterValueSet(), entry.getHandle(), lockFactory);
        }
    }

    public boolean isSupportsTakeApply() {
        return this.isolatableCallbacks != null;
    }
}

