/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventPropertyGetterSPI;
import com.espertech.esper.event.EventPropertyType;
import com.espertech.esper.event.WriteablePropertyDescriptor;
import com.espertech.esper.event.bean.BaseNativePropertyGetter;
import com.espertech.esper.event.bean.CGLibPropertyGetter;
import com.espertech.esper.event.bean.InternalEventPropDescriptor;
import com.espertech.esper.event.bean.ReflectionPropMethodGetter;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyHelper {
    private static final Logger log = LoggerFactory.getLogger(PropertyHelper.class);

    public static EventPropertyGetterSPI getGetter(Method method, FastClass fastClass, EventAdapterService eventAdapterService) {
        FastMethod fastMethod = null;
        try {
            if (fastClass != null) {
                fastMethod = fastClass.getMethod(method);
            }
        }
        catch (Throwable ex) {
            log.warn(".getAccessAccessorsForges Unable to obtain CGLib fast method implementation, msg=" + ex.getMessage());
        }
        BaseNativePropertyGetter getter = fastMethod != null ? new CGLibPropertyGetter(method, fastMethod, eventAdapterService) : new ReflectionPropMethodGetter(method, eventAdapterService);
        return getter;
    }

    public static List<InternalEventPropDescriptor> getProperties(Class clazz) {
        HashSet<Class> propertyOrigClasses = new HashSet<Class>();
        PropertyHelper.getImplementedInterfaceParents(clazz, propertyOrigClasses);
        propertyOrigClasses.add(clazz);
        return PropertyHelper.getPropertiesForClasses(propertyOrigClasses);
    }

    public static Set<WriteablePropertyDescriptor> getWritableProperties(Class clazz) {
        HashSet<Class> propertyOrigClasses = new HashSet<Class>();
        PropertyHelper.getImplementedInterfaceParents(clazz, propertyOrigClasses);
        propertyOrigClasses.add(clazz);
        return PropertyHelper.getWritablePropertiesForClasses(propertyOrigClasses);
    }

    private static void getImplementedInterfaceParents(Class clazz, Set<Class> classesResult) {
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces == null) {
            return;
        }
        for (int i = 0; i < interfaces.length; ++i) {
            classesResult.add(interfaces[i]);
            PropertyHelper.getImplementedInterfaceParents(interfaces[i], classesResult);
        }
    }

    private static Set<WriteablePropertyDescriptor> getWritablePropertiesForClasses(Set<Class> propertyClasses) {
        HashSet<WriteablePropertyDescriptor> result = new HashSet<WriteablePropertyDescriptor>();
        for (Class clazz : propertyClasses) {
            PropertyHelper.addIntrospectPropertiesWritable(clazz, result);
        }
        return result;
    }

    private static List<InternalEventPropDescriptor> getPropertiesForClasses(Set<Class> propertyClasses) {
        LinkedList<InternalEventPropDescriptor> result = new LinkedList<InternalEventPropDescriptor>();
        for (Class clazz : propertyClasses) {
            PropertyHelper.addIntrospectProperties(clazz, result);
            PropertyHelper.addMappedProperties(clazz, result);
        }
        PropertyHelper.removeDuplicateProperties(result);
        PropertyHelper.removeJavaProperties(result);
        return result;
    }

    protected static void removeJavaProperties(List<InternalEventPropDescriptor> properties) {
        LinkedList<InternalEventPropDescriptor> toRemove = new LinkedList<InternalEventPropDescriptor>();
        for (InternalEventPropDescriptor desc : properties) {
            if (!desc.getPropertyName().equals("class") && !desc.getPropertyName().equals("getClass") && !desc.getPropertyName().equals("toString") && !desc.getPropertyName().equals("hashCode")) continue;
            toRemove.add(desc);
        }
        for (InternalEventPropDescriptor desc : toRemove) {
            properties.remove(desc);
        }
    }

    protected static void removeDuplicateProperties(List<InternalEventPropDescriptor> properties) {
        LinkedHashMap<String, InternalEventPropDescriptor> set = new LinkedHashMap<String, InternalEventPropDescriptor>();
        LinkedList<InternalEventPropDescriptor> toRemove = new LinkedList<InternalEventPropDescriptor>();
        for (InternalEventPropDescriptor desc : properties) {
            if (set.containsKey(desc.getPropertyName())) {
                toRemove.add(desc);
                continue;
            }
            set.put(desc.getPropertyName(), desc);
        }
        for (InternalEventPropDescriptor desc : toRemove) {
            properties.remove(desc);
        }
    }

    protected static void addIntrospectProperties(Class clazz, List<InternalEventPropDescriptor> result) {
        PropertyDescriptor[] properties = PropertyHelper.introspect(clazz);
        for (int i = 0; i < properties.length; ++i) {
            PropertyDescriptor property = properties[i];
            String propertyName = property.getName();
            Method readMethod = property.getReadMethod();
            EventPropertyType type = EventPropertyType.SIMPLE;
            if (property instanceof IndexedPropertyDescriptor) {
                readMethod = ((IndexedPropertyDescriptor)property).getIndexedReadMethod();
                type = EventPropertyType.INDEXED;
            }
            if (readMethod == null) continue;
            result.add(new InternalEventPropDescriptor(propertyName, readMethod, type));
        }
    }

    private static void addIntrospectPropertiesWritable(Class clazz, Set<WriteablePropertyDescriptor> result) {
        PropertyDescriptor[] properties = PropertyHelper.introspect(clazz);
        for (int i = 0; i < properties.length; ++i) {
            PropertyDescriptor property = properties[i];
            String propertyName = property.getName();
            Method writeMethod = property.getWriteMethod();
            if (writeMethod == null) continue;
            result.add(new WriteablePropertyDescriptor(propertyName, writeMethod.getParameterTypes()[0], writeMethod));
        }
    }

    protected static void addMappedProperties(Class clazz, List<InternalEventPropDescriptor> result) {
        HashSet<String> uniquePropertyNames = new HashSet<String>();
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] parameterTypes;
            String inferredName;
            String methodName = methods[i].getName();
            if (!methodName.startsWith("get") || (inferredName = methodName.substring(3, methodName.length())).length() == 0 || (parameterTypes = methods[i].getParameterTypes()).length != 1 || parameterTypes[0] != String.class) continue;
            String newInferredName = null;
            if (inferredName.length() >= 2 && Character.isUpperCase(inferredName.charAt(0)) && Character.isUpperCase(inferredName.charAt(1))) {
                newInferredName = inferredName;
            }
            if (newInferredName == null) {
                newInferredName = Character.toString(Character.toLowerCase(inferredName.charAt(0)));
                if (inferredName.length() > 1) {
                    newInferredName = newInferredName + inferredName.substring(1, inferredName.length());
                }
            }
            if (uniquePropertyNames.contains(inferredName = newInferredName)) continue;
            result.add(new InternalEventPropDescriptor(inferredName, methods[i], EventPropertyType.MAPPED));
            uniquePropertyNames.add(inferredName);
        }
    }

    protected static PropertyDescriptor[] introspect(Class clazz) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            return new PropertyDescriptor[0];
        }
        return beanInfo.getPropertyDescriptors();
    }

    public static String getGetterMethodName(String propertyName) {
        return PropertyHelper.getGetterSetterMethodName(propertyName, "get");
    }

    public static String getSetterMethodName(String propertyName) {
        return PropertyHelper.getGetterSetterMethodName(propertyName, "set");
    }

    public static String getIsMethodName(String propertyName) {
        return PropertyHelper.getGetterSetterMethodName(propertyName, "is");
    }

    private static String getGetterSetterMethodName(String propertyName, String operation) {
        StringWriter writer = new StringWriter();
        writer.write(operation);
        writer.write(Character.toUpperCase(propertyName.charAt(0)));
        writer.write(propertyName.substring(1));
        return writer.toString();
    }
}

