/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanManufactureException;
import com.espertech.esper.event.EventBeanManufacturer;
import com.espertech.esper.event.WriteablePropertyDescriptor;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.event.bean.BeanInstantiator;
import com.espertech.esper.event.bean.BeanInstantiatorFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.cglib.reflect.FastMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBeanManufacturerBean
implements EventBeanManufacturer {
    private static final Logger log = LoggerFactory.getLogger(EventBeanManufacturerBean.class);
    private final BeanInstantiator beanInstantiator;
    private final BeanEventType beanEventType;
    private final EventAdapterService service;
    private final FastMethod[] writeMethodsFastClass;
    private final Method[] writeMethodsReflection;
    private final boolean hasPrimitiveTypes;
    private final boolean[] primitiveType;

    public EventBeanManufacturerBean(BeanEventType beanEventType, EventAdapterService service, WriteablePropertyDescriptor[] properties, EngineImportService engineImportService) throws EventBeanManufactureException {
        this.beanEventType = beanEventType;
        this.service = service;
        this.beanInstantiator = BeanInstantiatorFactory.makeInstantiator(beanEventType, engineImportService);
        this.writeMethodsReflection = new Method[properties.length];
        this.writeMethodsFastClass = beanEventType.getFastClass() != null ? new FastMethod[properties.length] : null;
        boolean primitiveTypeCheck = false;
        this.primitiveType = new boolean[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            this.writeMethodsReflection[i] = properties[i].getWriteMethod();
            if (beanEventType.getFastClass() != null) {
                this.writeMethodsFastClass[i] = beanEventType.getFastClass().getMethod(properties[i].getWriteMethod());
            }
            this.primitiveType[i] = properties[i].getType().isPrimitive();
            primitiveTypeCheck |= this.primitiveType[i];
        }
        this.hasPrimitiveTypes = primitiveTypeCheck;
    }

    @Override
    public EventBean make(Object[] propertyValues) {
        Object outObject = this.makeUnderlying(propertyValues);
        return this.service.adapterForTypedBean(outObject, this.beanEventType);
    }

    @Override
    public Object makeUnderlying(Object[] propertyValues) {
        Object outObject = this.beanInstantiator.instantiate();
        if (this.writeMethodsFastClass != null) {
            if (!this.hasPrimitiveTypes) {
                Object[] parameters = new Object[1];
                for (int i = 0; i < this.writeMethodsFastClass.length; ++i) {
                    parameters[0] = propertyValues[i];
                    try {
                        this.writeMethodsFastClass[i].invoke(outObject, parameters);
                        continue;
                    }
                    catch (InvocationTargetException e) {
                        this.handle(e, this.writeMethodsFastClass[i].getName());
                    }
                }
            } else {
                Object[] parameters = new Object[1];
                for (int i = 0; i < this.writeMethodsFastClass.length; ++i) {
                    if (this.primitiveType[i] && propertyValues[i] == null) continue;
                    parameters[0] = propertyValues[i];
                    try {
                        this.writeMethodsFastClass[i].invoke(outObject, parameters);
                        continue;
                    }
                    catch (InvocationTargetException e) {
                        this.handle(e, this.writeMethodsFastClass[i].getName());
                    }
                }
            }
        } else if (!this.hasPrimitiveTypes) {
            Object[] parameters = new Object[1];
            for (int i = 0; i < this.writeMethodsReflection.length; ++i) {
                parameters[0] = propertyValues[i];
                try {
                    this.writeMethodsReflection[i].invoke(outObject, parameters);
                    continue;
                }
                catch (InvocationTargetException e) {
                    String message = "Unexpected exception encountered invoking setter-method '" + this.writeMethodsReflection[i] + "' on class '" + this.beanEventType.getUnderlyingType().getName() + "' : " + e.getTargetException().getMessage();
                    log.error(message, (Throwable)e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    this.handle(e, this.writeMethodsReflection[i].getName());
                }
            }
        } else {
            Object[] parameters = new Object[1];
            for (int i = 0; i < this.writeMethodsReflection.length; ++i) {
                if (this.primitiveType[i] && propertyValues[i] == null) continue;
                parameters[0] = propertyValues[i];
                try {
                    this.writeMethodsReflection[i].invoke(outObject, parameters);
                    continue;
                }
                catch (InvocationTargetException e) {
                    this.handle(e, this.writeMethodsReflection[i].getName());
                    continue;
                }
                catch (IllegalAccessException e) {
                    this.handle(e, this.writeMethodsReflection[i].getName());
                }
            }
        }
        return outObject;
    }

    private void handle(InvocationTargetException ex, String methodName) {
        String message = "Unexpected exception encountered invoking setter-method '" + methodName + "' on class '" + this.beanEventType.getUnderlyingType().getName() + "' : " + ex.getTargetException().getMessage();
        log.error(message, (Throwable)ex);
    }

    private void handle(IllegalAccessException ex, String methodName) {
        String message = "Unexpected exception encountered invoking setter-method '" + methodName + "' on class '" + this.beanEventType.getUnderlyingType().getName() + "' : " + ex.getMessage();
        log.error(message, (Throwable)ex);
    }
}

