/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.arr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.event.BaseNestableEventUtil;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.arr.ObjectArrayEventPropertyGetter;
import com.espertech.esper.event.bean.BeanEventType;

public class ObjectArrayEntryPropertyGetter
implements ObjectArrayEventPropertyGetter {
    private final int propertyIndex;
    private final EventAdapterService eventAdapterService;
    private final BeanEventType eventType;

    public ObjectArrayEntryPropertyGetter(int propertyIndex, BeanEventType eventType, EventAdapterService eventAdapterService) {
        this.propertyIndex = propertyIndex;
        this.eventAdapterService = eventAdapterService;
        this.eventType = eventType;
    }

    @Override
    public Object getObjectArray(Object[] array) throws PropertyAccessException {
        return array[this.propertyIndex];
    }

    @Override
    public boolean isObjectArrayExistsProperty(Object[] array) {
        return true;
    }

    @Override
    public Object get(EventBean obj) {
        Object[] arr = BaseNestableEventUtil.checkedCastUnderlyingObjectArray(obj);
        return this.getObjectArray(arr);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean eventBean) {
        if (this.eventType == null) {
            return null;
        }
        Object result = this.get(eventBean);
        return BaseNestableEventUtil.getBNFragmentPojo(result, this.eventType, this.eventAdapterService);
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.castUnderlying(Object[].class, beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression eventBeanFragmentCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        if (this.eventType == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        return this.underlyingFragmentCodegen(CodegenExpressionBuilder.castUnderlying(Object[].class, beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.arrayAtIndex(underlyingExpression, CodegenExpressionBuilder.constant(this.propertyIndex));
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression underlyingFragmentCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        if (this.eventType == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        CodegenMember mSvc = codegenClassScope.makeAddMember(EventAdapterService.class, this.eventAdapterService);
        CodegenMember mType = codegenClassScope.makeAddMember(BeanEventType.class, this.eventType);
        return CodegenExpressionBuilder.staticMethod(BaseNestableEventUtil.class, "getBNFragmentPojo", this.underlyingGetCodegen(underlyingExpression, codegenMethodScope, codegenClassScope), CodegenExpressionBuilder.member(mType.getMemberId()), CodegenExpressionBuilder.member(mSvc.getMemberId()));
    }
}

