/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.virtualdw;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.hook.VirtualDataWindowKeyRange;
import com.espertech.esper.client.hook.VirtualDataWindowLookup;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyed;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRange;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRangeIn;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRangeRelOp;
import com.espertech.esper.epl.join.plan.TableLookupKeyDesc;
import com.espertech.esper.epl.join.rep.Cursor;
import com.espertech.esper.epl.lookup.LookupStrategyDesc;
import com.espertech.esper.epl.lookup.LookupStrategyType;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinExecTableLookupStrategyVirtualDW
implements JoinExecTableLookupStrategy {
    private static final Logger log = LoggerFactory.getLogger(JoinExecTableLookupStrategyVirtualDW.class);
    private final String namedWindowName;
    private final VirtualDataWindowLookup externalIndex;
    private final ExternalEvaluator[] evaluators;
    private final EventBean[] eventsPerStream;
    private final int lookupStream;

    public JoinExecTableLookupStrategyVirtualDW(String namedWindowName, VirtualDataWindowLookup externalIndex, TableLookupKeyDesc keyDescriptor, int lookupStream) {
        this.namedWindowName = namedWindowName;
        this.externalIndex = externalIndex;
        this.evaluators = new ExternalEvaluator[keyDescriptor.getHashes().size() + keyDescriptor.getRanges().size()];
        this.eventsPerStream = new EventBean[lookupStream + 1];
        this.lookupStream = lookupStream;
        int count = 0;
        for (QueryGraphValueEntryHashKeyed hashKey : keyDescriptor.getHashes()) {
            ExprEvaluator evaluator = hashKey.getKeyExpr().getForge().getExprEvaluator();
            this.evaluators[count] = new ExternalEvaluatorHashRelOp(evaluator);
            ++count;
        }
        for (QueryGraphValueEntryRange rangeKey : keyDescriptor.getRanges()) {
            if (rangeKey.getType().isRange()) {
                QueryGraphValueEntryRangeIn range = (QueryGraphValueEntryRangeIn)rangeKey;
                ExprEvaluator evaluatorStart = range.getExprStart().getForge().getExprEvaluator();
                ExprEvaluator evaluatorEnd = range.getExprEnd().getForge().getExprEvaluator();
                this.evaluators[count] = new ExternalEvaluatorBtreeRange(evaluatorStart, evaluatorEnd);
            } else {
                QueryGraphValueEntryRangeRelOp relOp = (QueryGraphValueEntryRangeRelOp)rangeKey;
                ExprEvaluator evaluator = relOp.getExpression().getForge().getExprEvaluator();
                this.evaluators[count] = new ExternalEvaluatorHashRelOp(evaluator);
            }
            ++count;
        }
    }

    @Override
    public Set<EventBean> lookup(EventBean theEvent, Cursor cursor, ExprEvaluatorContext context) {
        this.eventsPerStream[this.lookupStream] = theEvent;
        Object[] keys = new Object[this.evaluators.length];
        for (int i = 0; i < this.evaluators.length; ++i) {
            keys[i] = this.evaluators[i].evaluate(this.eventsPerStream, context);
        }
        Set<EventBean> events = null;
        try {
            events = this.externalIndex.lookup(keys, this.eventsPerStream);
        }
        catch (RuntimeException ex) {
            log.warn("Exception encountered invoking virtual data window external index for window '" + this.namedWindowName + "': " + ex.getMessage(), (Throwable)ex);
        }
        return events;
    }

    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " external index " + this.externalIndex;
    }

    @Override
    public LookupStrategyDesc getStrategyDesc() {
        return new LookupStrategyDesc(LookupStrategyType.VDW, null);
    }

    private static class ExternalEvaluatorBtreeRange
    implements ExternalEvaluator {
        private final ExprEvaluator startEval;
        private final ExprEvaluator endEval;

        private ExternalEvaluatorBtreeRange(ExprEvaluator startEval, ExprEvaluator endEval) {
            this.startEval = startEval;
            this.endEval = endEval;
        }

        @Override
        public Object evaluate(EventBean[] events, ExprEvaluatorContext context) {
            Object start = this.startEval.evaluate(events, true, context);
            Object end = this.endEval.evaluate(events, true, context);
            return new VirtualDataWindowKeyRange(start, end);
        }
    }

    private static class ExternalEvaluatorHashRelOp
    implements ExternalEvaluator {
        private final ExprEvaluator hashKeysEval;

        private ExternalEvaluatorHashRelOp(ExprEvaluator hashKeysEval) {
            this.hashKeysEval = hashKeysEval;
        }

        @Override
        public Object evaluate(EventBean[] events, ExprEvaluatorContext context) {
            return this.hashKeysEval.evaluate(events, true, context);
        }
    }

    private static interface ExternalEvaluator {
        public Object evaluate(EventBean[] var1, ExprEvaluatorContext var2);
    }
}

