/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.service.UpdateDispatchView;
import com.espertech.esper.epl.core.resultset.core.ResultSetProcessor;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.view.OutputCondition;
import com.espertech.esper.epl.view.OutputProcessViewAfterState;
import com.espertech.esper.epl.view.OutputProcessViewBase;
import com.espertech.esper.epl.view.OutputProcessViewConditionDeltaSet;
import com.espertech.esper.epl.view.OutputProcessViewDirectFactory;
import com.espertech.esper.epl.view.OutputStrategyUtil;
import com.espertech.esper.util.AuditPath;
import java.util.Iterator;
import java.util.Set;

public class OutputProcessViewDirect
extends OutputProcessViewBase {
    private final OutputProcessViewDirectFactory parent;

    public OutputProcessViewDirect(ResultSetProcessor resultSetProcessor, OutputProcessViewDirectFactory parent) {
        super(resultSetProcessor);
        this.parent = parent;
    }

    @Override
    public int getNumChangesetRows() {
        return 0;
    }

    @Override
    public OutputCondition getOptionalOutputCondition() {
        return null;
    }

    @Override
    public OutputProcessViewConditionDeltaSet getOptionalDeltaSet() {
        return null;
    }

    @Override
    public OutputProcessViewAfterState getOptionalAfterConditionState() {
        return null;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        boolean isGenerateSynthetic = this.parent.getStatementResultService().isMakeSynthetic();
        boolean isGenerateNatural = this.parent.getStatementResultService().isMakeNatural();
        UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.processViewResult(newData, oldData, isGenerateSynthetic);
        if (!isGenerateSynthetic && !isGenerateNatural) {
            if (AuditPath.isAuditEnabled) {
                OutputStrategyUtil.indicateEarlyReturn(this.parent.getStatementContext(), newOldEvents);
            }
            return;
        }
        boolean forceOutput = false;
        if (newData == null && oldData == null && (newOldEvents == null || newOldEvents.getFirst() == null && newOldEvents.getSecond() == null)) {
            forceOutput = true;
        }
        if (this.childView != null) {
            this.postProcess(forceOutput, newOldEvents, this.childView);
        }
    }

    @Override
    public void process(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, ExprEvaluatorContext exprEvaluatorContext) {
        boolean isGenerateSynthetic = this.parent.getStatementResultService().isMakeSynthetic();
        boolean isGenerateNatural = this.parent.getStatementResultService().isMakeNatural();
        UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.processJoinResult(newEvents, oldEvents, isGenerateSynthetic);
        if (!isGenerateSynthetic && !isGenerateNatural) {
            if (AuditPath.isAuditEnabled) {
                OutputStrategyUtil.indicateEarlyReturn(this.parent.getStatementContext(), newOldEvents);
            }
            return;
        }
        if (newOldEvents == null) {
            return;
        }
        if (this.childView != null) {
            this.postProcess(false, newOldEvents, this.childView);
        }
    }

    protected void postProcess(boolean force, UniformPair<EventBean[]> newOldEvents, UpdateDispatchView childView) {
        OutputStrategyUtil.output(force, newOldEvents, childView);
    }

    @Override
    public Iterator<EventBean> iterator() {
        return OutputStrategyUtil.getIterator(this.joinExecutionStrategy, this.resultSetProcessor, this.parentView, false);
    }

    @Override
    public void terminated() {
    }

    @Override
    public void stop() {
    }
}

