/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.table.mgmt;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.access.AggregationServicePassThru;
import com.espertech.esper.epl.agg.service.common.AggregationRowPair;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.join.plan.QueryPlanIndexItem;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.lookup.EventTableIndexRepository;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.event.ObjectArrayBackedEventBean;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class TableStateInstance {
    protected final TableMetadata tableMetadata;
    protected final AgentInstanceContext agentInstanceContext;
    private final ReentrantReadWriteLock tableLevelRWLock = new ReentrantReadWriteLock();
    protected final EventTableIndexRepository indexRepository;

    public abstract Iterable<EventBean> getIterableTableScan();

    public abstract void addEvent(EventBean var1);

    public abstract void deleteEvent(EventBean var1);

    public abstract void clearInstance();

    public abstract void destroyInstance();

    public abstract void addExplicitIndex(String var1, QueryPlanIndexItem var2, boolean var3, boolean var4) throws ExprValidationException;

    public abstract String[] getSecondaryIndexes();

    public abstract EventTable getIndex(String var1);

    public abstract ObjectArrayBackedEventBean getCreateRowIntoTable(Object var1, ExprEvaluatorContext var2);

    public abstract Collection<EventBean> getEventCollection();

    public abstract int getRowCount();

    public abstract AggregationServicePassThru getAggregationServicePassThru();

    public void handleRowUpdated(ObjectArrayBackedEventBean row) {
    }

    public void addEventUnadorned(EventBean event) {
        ObjectArrayBackedEventBean oa = (ObjectArrayBackedEventBean)event;
        AggregationRowPair aggs = this.tableMetadata.getRowFactory().makeAggs(this.agentInstanceContext.getAgentInstanceId(), null, null, this.getAggregationServicePassThru());
        oa.getProperties()[0] = aggs;
        this.addEvent(oa);
    }

    protected TableStateInstance(TableMetadata tableMetadata, AgentInstanceContext agentInstanceContext) {
        this.tableMetadata = tableMetadata;
        this.agentInstanceContext = agentInstanceContext;
        this.indexRepository = new EventTableIndexRepository(tableMetadata.getEventTableIndexMetadataRepo());
    }

    public TableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public AgentInstanceContext getAgentInstanceContext() {
        return this.agentInstanceContext;
    }

    public ReentrantReadWriteLock getTableLevelRWLock() {
        return this.tableLevelRWLock;
    }

    public EventTableIndexRepository getIndexRepository() {
        return this.indexRepository;
    }

    public void handleRowUpdateKeyBeforeUpdate(ObjectArrayBackedEventBean updatedEvent) {
    }

    public void handleRowUpdateKeyAfterUpdate(ObjectArrayBackedEventBean updatedEvent) {
    }

    public void removeExplicitIndex(String indexName) {
        this.indexRepository.removeExplicitIndex(indexName);
    }
}

