/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.table.mgmt;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.resource.StatementResourceHolder;
import com.espertech.esper.core.service.resource.StatementResourceService;
import com.espertech.esper.epl.agg.service.common.AggregationServiceTable;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.join.plan.QueryPlanIndexItem;
import com.espertech.esper.epl.lookup.EventTableIndexMetadata;
import com.espertech.esper.epl.lookup.IndexMultiKey;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumn;
import com.espertech.esper.epl.table.mgmt.TableMetadataContext;
import com.espertech.esper.epl.table.mgmt.TableMetadataInternalEventToPublic;
import com.espertech.esper.epl.table.mgmt.TableRowKeyFactory;
import com.espertech.esper.epl.table.mgmt.TableServiceUtil;
import com.espertech.esper.epl.table.mgmt.TableStateFactory;
import com.espertech.esper.epl.table.mgmt.TableStateInstance;
import com.espertech.esper.epl.table.mgmt.TableStateRowFactory;
import com.espertech.esper.epl.table.mgmt.TableUpdateStrategyReceiverDesc;
import com.espertech.esper.epl.table.upd.TableUpdateStrategy;
import com.espertech.esper.epl.table.upd.TableUpdateStrategyFactory;
import com.espertech.esper.epl.table.upd.TableUpdateStrategyReceiver;
import com.espertech.esper.epl.updatehelper.EventBeanUpdateHelper;
import com.espertech.esper.event.arr.ObjectArrayEventType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TableMetadata {
    private final String tableName;
    private final String eplExpression;
    private final String statementName;
    private final Class[] keyTypes;
    private final Map<String, TableMetadataColumn> tableColumns;
    private final TableStateRowFactory rowFactory;
    private final int numberMethodAggregations;
    private final StatementContext statementContextCreateTable;
    private final ObjectArrayEventType internalEventType;
    private final ObjectArrayEventType publicEventType;
    private final TableMetadataInternalEventToPublic eventToPublic;
    private final boolean queryPlanLogging;
    private final Map<String, List<TableUpdateStrategyReceiverDesc>> stmtNameToUpdateStrategyReceivers = new HashMap<String, List<TableUpdateStrategyReceiverDesc>>();
    private final EventTableIndexMetadata eventTableIndexMetadataRepo = new EventTableIndexMetadata();
    private TableStateFactory tableStateFactory;
    private TableMetadataContext tableMetadataContext;
    private TableRowKeyFactory tableRowKeyFactory;

    public TableMetadata(String tableName, String eplExpression, String statementName, Class[] keyTypes, Map<String, TableMetadataColumn> tableColumns, TableStateRowFactory rowFactory, int numberMethodAggregations, StatementContext createTableStatementContext, ObjectArrayEventType internalEventType, ObjectArrayEventType publicEventType, TableMetadataInternalEventToPublic eventToPublic, boolean queryPlanLogging) throws ExprValidationException {
        this.tableName = tableName;
        this.eplExpression = eplExpression;
        this.statementName = statementName;
        this.keyTypes = keyTypes;
        this.tableColumns = tableColumns;
        this.rowFactory = rowFactory;
        this.numberMethodAggregations = numberMethodAggregations;
        this.statementContextCreateTable = createTableStatementContext;
        this.internalEventType = internalEventType;
        this.publicEventType = publicEventType;
        this.eventToPublic = eventToPublic;
        this.queryPlanLogging = queryPlanLogging;
        if (keyTypes.length > 0) {
            Pair<int[], IndexMultiKey> pair = TableServiceUtil.getIndexMultikeyForKeys(tableColumns, internalEventType);
            QueryPlanIndexItem queryPlanIndexItem = QueryPlanIndexItem.fromIndexMultikeyTablePrimaryKey(pair.getSecond());
            this.eventTableIndexMetadataRepo.addIndexExplicit(true, pair.getSecond(), tableName, queryPlanIndexItem, createTableStatementContext.getStatementName());
            this.tableRowKeyFactory = new TableRowKeyFactory(pair.getFirst());
        }
    }

    public Class[] getKeyTypes() {
        return this.keyTypes;
    }

    public TableStateFactory getTableStateFactory() {
        return this.tableStateFactory;
    }

    public Map<String, TableMetadataColumn> getTableColumns() {
        return this.tableColumns;
    }

    public TableStateRowFactory getRowFactory() {
        return this.rowFactory;
    }

    public int getNumberMethodAggregations() {
        return this.numberMethodAggregations;
    }

    public String getContextName() {
        return this.statementContextCreateTable.getContextName();
    }

    public ObjectArrayEventType getInternalEventType() {
        return this.internalEventType;
    }

    public boolean isQueryPlanLogging() {
        return this.queryPlanLogging;
    }

    public Set<String> getUniqueKeyProps() {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (Map.Entry<String, TableMetadataColumn> entry : this.tableColumns.entrySet()) {
            if (!entry.getValue().isKey()) continue;
            keys.add(entry.getKey());
        }
        return keys;
    }

    public void setTableStateFactory(TableStateFactory tableStateFactory) {
        this.tableStateFactory = tableStateFactory;
    }

    public String getTableName() {
        return this.tableName;
    }

    public EventTableIndexMetadata getEventTableIndexMetadataRepo() {
        return this.eventTableIndexMetadataRepo;
    }

    public EventBean getPublicEventBean(EventBean event, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.eventToPublic.convert(event, eventsPerStream, isNewData, context);
    }

    public EventType getPublicEventType() {
        return this.publicEventType;
    }

    public TableMetadataInternalEventToPublic getEventToPublic() {
        return this.eventToPublic;
    }

    public void validateAddIndexAssignUpdateStrategies(String createIndexStatementName, IndexMultiKey imk, String explicitIndexName, QueryPlanIndexItem explicitIndexDesc) throws ExprValidationException {
        this.eventTableIndexMetadataRepo.addIndexExplicit(false, imk, explicitIndexName, explicitIndexDesc, createIndexStatementName);
        for (Map.Entry<String, List<TableUpdateStrategyReceiverDesc>> stmtEntry : this.stmtNameToUpdateStrategyReceivers.entrySet()) {
            for (TableUpdateStrategyReceiverDesc strategyReceiver : stmtEntry.getValue()) {
                try {
                    TableUpdateStrategyFactory.validateGetTableUpdateStrategy(this, strategyReceiver.getUpdateHelper(), strategyReceiver.isOnMerge());
                }
                catch (ExprValidationException ex) {
                    this.eventTableIndexMetadataRepo.removeIndex(imk);
                    throw new ExprValidationException("Failed to validate statement '" + stmtEntry.getKey() + "' as a recipient of the proposed index: " + ex.getMessage());
                }
            }
        }
        for (Map.Entry<String, List<TableUpdateStrategyReceiverDesc>> stmtEntry : this.stmtNameToUpdateStrategyReceivers.entrySet()) {
            for (TableUpdateStrategyReceiverDesc strategyReceiver : stmtEntry.getValue()) {
                TableUpdateStrategy strategy = TableUpdateStrategyFactory.validateGetTableUpdateStrategy(this, strategyReceiver.getUpdateHelper(), strategyReceiver.isOnMerge());
                strategyReceiver.getReceiver().update(strategy);
            }
        }
    }

    public void addTableUpdateStrategyReceiver(String statementName, TableUpdateStrategyReceiver receiver, EventBeanUpdateHelper updateHelper, boolean onMerge) {
        List<TableUpdateStrategyReceiverDesc> receivers = this.stmtNameToUpdateStrategyReceivers.get(statementName);
        if (receivers == null) {
            receivers = new ArrayList<TableUpdateStrategyReceiverDesc>(2);
            this.stmtNameToUpdateStrategyReceivers.put(statementName, receivers);
        }
        receivers.add(new TableUpdateStrategyReceiverDesc(receiver, updateHelper, onMerge));
    }

    public void removeTableUpdateStrategyReceivers(String statementName) {
        this.stmtNameToUpdateStrategyReceivers.remove(statementName);
    }

    public void addIndexReference(String indexName, String statementName) {
        this.eventTableIndexMetadataRepo.addIndexReference(indexName, statementName);
    }

    public void removeIndexReferencesStatement(String statementName) {
        Collection<String> indexesDereferenced = this.eventTableIndexMetadataRepo.getRemoveRefIndexesDereferenced(statementName);
        for (String indexDereferenced : indexesDereferenced) {
            for (int agentInstanceId : this.getAgentInstanceIds()) {
                IndexMultiKey mk;
                TableStateInstance state = this.getState(agentInstanceId);
                if (state == null || (mk = state.getIndexRepository().getIndexByName(indexDereferenced)) == null) continue;
                state.getIndexRepository().removeIndex(mk);
            }
        }
    }

    public TableStateInstance getState(int agentInstanceId) {
        StatementResourceService createTableResources = this.statementContextCreateTable.getStatementExtensionServicesContext().getStmtResources();
        StatementResourceHolder holder = null;
        if (this.statementContextCreateTable.getContextName() == null) {
            holder = createTableResources.getResourcesUnpartitioned();
        } else if (createTableResources.getResourcesPartitioned() != null) {
            holder = createTableResources.getResourcesPartitioned().get(agentInstanceId);
        }
        if (holder == null) {
            return null;
        }
        AggregationServiceTable aggsvc = (AggregationServiceTable)holder.getAggregationService();
        return aggsvc.getTableState();
    }

    public Collection<Integer> getAgentInstanceIds() {
        StatementResourceService createTableResources = this.statementContextCreateTable.getStatementExtensionServicesContext().getStmtResources();
        if (this.statementContextCreateTable.getContextName() == null) {
            return Collections.singleton(-1);
        }
        if (createTableResources.getResourcesPartitioned() != null) {
            return createTableResources.getResourcesPartitioned().keySet();
        }
        return Collections.singleton(-1);
    }

    public String[][] getUniqueIndexes() {
        return this.eventTableIndexMetadataRepo.getUniqueIndexProps();
    }

    public void setTableMetadataContext(TableMetadataContext tableMetadataContext) {
        this.tableMetadataContext = tableMetadataContext;
    }

    public TableMetadataContext getTableMetadataContext() {
        return this.tableMetadataContext;
    }

    public TableRowKeyFactory getTableRowKeyFactory() {
        return this.tableRowKeyFactory;
    }

    public void clearTableInstances() {
        for (int agentInstanceId : this.getAgentInstanceIds()) {
            TableStateInstance state = this.getState(agentInstanceId);
            if (state == null) continue;
            state.destroyInstance();
        }
    }

    public String getEplExpression() {
        return this.eplExpression;
    }

    public String getStatementName() {
        return this.statementName;
    }

    public StatementContext getStatementContextCreateTable() {
        return this.statementContextCreateTable;
    }
}

