/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.generated.EsperEPL2GrammarParser;
import com.espertech.esper.epl.parse.ASTAnnotationHelper;
import com.espertech.esper.epl.parse.ASTCreateSchemaHelper;
import com.espertech.esper.epl.parse.ASTUtil;
import com.espertech.esper.epl.spec.AnnotationDesc;
import com.espertech.esper.epl.spec.CreateDataFlowDesc;
import com.espertech.esper.epl.spec.CreateSchemaDesc;
import com.espertech.esper.epl.spec.GraphOperatorDetail;
import com.espertech.esper.epl.spec.GraphOperatorInput;
import com.espertech.esper.epl.spec.GraphOperatorInputNamesAlias;
import com.espertech.esper.epl.spec.GraphOperatorOutput;
import com.espertech.esper.epl.spec.GraphOperatorOutputItem;
import com.espertech.esper.epl.spec.GraphOperatorOutputItemType;
import com.espertech.esper.epl.spec.GraphOperatorSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.tree.Tree;

public class ASTGraphHelper {
    public static CreateDataFlowDesc walkCreateDataFlow(EsperEPL2GrammarParser.CreateDataflowContext ctx, Map<Tree, Object> astGraphNodeMap, EngineImportService engineImportService) {
        String graphName = ctx.name.getText();
        ArrayList<GraphOperatorSpec> ops = new ArrayList<GraphOperatorSpec>();
        ArrayList<CreateSchemaDesc> schemas = new ArrayList<CreateSchemaDesc>();
        List<EsperEPL2GrammarParser.GopContext> gopctxs = ctx.gopList().gop();
        for (EsperEPL2GrammarParser.GopContext gopctx : gopctxs) {
            if (gopctx.createSchemaExpr() != null) {
                schemas.add(ASTCreateSchemaHelper.walkCreateSchema(gopctx.createSchemaExpr()));
                continue;
            }
            ops.add(ASTGraphHelper.parseOp(gopctx, astGraphNodeMap, engineImportService));
        }
        return new CreateDataFlowDesc(graphName, ops, schemas);
    }

    private static GraphOperatorSpec parseOp(EsperEPL2GrammarParser.GopContext ctx, Map<Tree, Object> astGraphNodeMap, EngineImportService engineImportService) {
        List<AnnotationDesc> annotations;
        String operatorName = ctx.opName != null ? ctx.opName.getText() : ctx.s.getText();
        GraphOperatorInput input = new GraphOperatorInput();
        if (ctx.gopParams() != null) {
            ASTGraphHelper.parseParams(ctx.gopParams(), input);
        }
        GraphOperatorOutput output = new GraphOperatorOutput();
        if (ctx.gopOut() != null) {
            ASTGraphHelper.parseOutput(ctx.gopOut(), output);
        }
        GraphOperatorDetail detail = null;
        if (ctx.gopDetail() != null) {
            LinkedHashMap<String, Object> configs = new LinkedHashMap<String, Object>();
            List<EsperEPL2GrammarParser.GopConfigContext> cfgctxs = ctx.gopDetail().gopConfig();
            for (EsperEPL2GrammarParser.GopConfigContext cfgctx : cfgctxs) {
                Object value = astGraphNodeMap.remove((Object)cfgctx);
                String name = cfgctx.n != null ? cfgctx.n.getText() : "select";
                configs.put(name, value);
            }
            detail = new GraphOperatorDetail(configs);
        }
        if (ctx.annotationEnum() != null) {
            List<EsperEPL2GrammarParser.AnnotationEnumContext> annoctxs = ctx.annotationEnum();
            annotations = new ArrayList();
            for (EsperEPL2GrammarParser.AnnotationEnumContext annoctx : annoctxs) {
                annotations.add(ASTAnnotationHelper.walk(annoctx, engineImportService));
            }
        } else {
            annotations = Collections.emptyList();
        }
        return new GraphOperatorSpec(operatorName, input, output, detail, annotations);
    }

    private static void parseParams(EsperEPL2GrammarParser.GopParamsContext ctx, GraphOperatorInput input) {
        if (ctx.gopParamsItemList() == null) {
            return;
        }
        List<EsperEPL2GrammarParser.GopParamsItemContext> items = ctx.gopParamsItemList().gopParamsItem();
        for (EsperEPL2GrammarParser.GopParamsItemContext item : items) {
            String[] streamNames = ASTGraphHelper.parseParamsStreamNames(item);
            String aliasName = item.gopParamsItemAs() != null ? item.gopParamsItemAs().a.getText() : null;
            input.getStreamNamesAndAliases().add(new GraphOperatorInputNamesAlias(streamNames, aliasName));
        }
    }

    private static String[] parseParamsStreamNames(EsperEPL2GrammarParser.GopParamsItemContext item) {
        ArrayList<String> paramNames = new ArrayList<String>(1);
        if (item.gopParamsItemMany() != null) {
            for (EsperEPL2GrammarParser.ClassIdentifierContext ctx : item.gopParamsItemMany().classIdentifier()) {
                paramNames.add(ctx.getText());
            }
        } else {
            paramNames.add(ASTUtil.unescapeClassIdent(item.classIdentifier()));
        }
        return paramNames.toArray(new String[paramNames.size()]);
    }

    private static void parseOutput(EsperEPL2GrammarParser.GopOutContext ctx, GraphOperatorOutput output) {
        if (ctx == null) {
            return;
        }
        List<EsperEPL2GrammarParser.GopOutItemContext> items = ctx.gopOutItem();
        for (EsperEPL2GrammarParser.GopOutItemContext item : items) {
            String streamName = item.n.getText();
            ArrayList<GraphOperatorOutputItemType> types = new ArrayList<GraphOperatorOutputItemType>();
            if (item.gopOutTypeList() != null) {
                for (EsperEPL2GrammarParser.GopOutTypeParamContext pctx : item.gopOutTypeList().gopOutTypeParam()) {
                    GraphOperatorOutputItemType type = ASTGraphHelper.parseType(pctx);
                    types.add(type);
                }
            }
            output.getItems().add(new GraphOperatorOutputItem(streamName, types));
        }
    }

    private static GraphOperatorOutputItemType parseType(EsperEPL2GrammarParser.GopOutTypeParamContext ctx) {
        if (ctx.q != null) {
            return new GraphOperatorOutputItemType(true, null, null);
        }
        String className = ASTUtil.unescapeClassIdent(ctx.gopOutTypeItem().classIdentifier());
        ArrayList<GraphOperatorOutputItemType> typeParams = new ArrayList<GraphOperatorOutputItemType>();
        if (ctx.gopOutTypeItem().gopOutTypeList() != null) {
            List<EsperEPL2GrammarParser.GopOutTypeParamContext> pctxs = ctx.gopOutTypeItem().gopOutTypeList().gopOutTypeParam();
            for (EsperEPL2GrammarParser.GopOutTypeParamContext pctx : pctxs) {
                GraphOperatorOutputItemType type = ASTGraphHelper.parseType(pctx);
                typeParams.add(type);
            }
        }
        return new GraphOperatorOutputItemType(false, className, typeParams);
    }
}

