/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.OneEventCollection;
import com.espertech.esper.core.service.EPStatementHandle;
import com.espertech.esper.core.service.InternalEventRouteDest;
import com.espertech.esper.core.service.InternalEventRouter;
import com.espertech.esper.epl.core.select.SelectExprProcessor;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.named.NamedWindowOnMergeAction;
import com.espertech.esper.epl.table.mgmt.TableService;
import com.espertech.esper.epl.table.mgmt.TableStateInstance;
import com.espertech.esper.util.AuditPath;

public class NamedWindowOnMergeActionIns
extends NamedWindowOnMergeAction {
    private final SelectExprProcessor insertHelper;
    private final InternalEventRouter internalEventRouter;
    private final String insertIntoTableName;
    private final TableService tableService;
    private final EPStatementHandle statementHandle;
    private final InternalEventRouteDest internalEventRouteDest;
    private final boolean audit;

    public NamedWindowOnMergeActionIns(ExprEvaluator optionalFilter, SelectExprProcessor insertHelper, InternalEventRouter internalEventRouter, String insertIntoTableName, TableService tableService, EPStatementHandle statementHandle, InternalEventRouteDest internalEventRouteDest, boolean audit) {
        super(optionalFilter);
        this.insertHelper = insertHelper;
        this.internalEventRouter = internalEventRouter;
        this.insertIntoTableName = insertIntoTableName;
        this.tableService = tableService;
        this.statementHandle = statementHandle;
        this.internalEventRouteDest = internalEventRouteDest;
        this.audit = audit;
    }

    @Override
    public void apply(EventBean matchingEvent, EventBean[] eventsPerStream, OneEventCollection newData, OneEventCollection oldData, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean theEvent = this.insertHelper.process(eventsPerStream, true, true, exprEvaluatorContext);
        if (this.insertIntoTableName != null) {
            TableStateInstance tableStateInstance = this.tableService.getState(this.insertIntoTableName, exprEvaluatorContext.getAgentInstanceId());
            if (this.audit) {
                AuditPath.auditInsertInto(tableStateInstance.getAgentInstanceContext().getEngineURI(), this.statementHandle.getStatementName(), theEvent);
            }
            tableStateInstance.addEventUnadorned(theEvent);
            return;
        }
        if (this.internalEventRouter == null) {
            newData.add(theEvent);
            return;
        }
        if (this.audit) {
            AuditPath.auditInsertInto(this.internalEventRouteDest.getEngineURI(), this.statementHandle.getStatementName(), theEvent);
        }
        this.internalEventRouter.route(theEvent, this.statementHandle, this.internalEventRouteDest, exprEvaluatorContext, false);
    }

    @Override
    public String getName() {
        return this.internalEventRouter != null ? "insert-into" : "select";
    }
}

