/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.join.base.HistoricalIndexLookupStrategy;
import com.espertech.esper.epl.join.plan.InKeywordTableLookupUtil;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingle;
import java.util.Iterator;
import java.util.Set;

public class HistoricalIndexLookupStrategyInKeywordSingle
implements HistoricalIndexLookupStrategy {
    private final EventBean[] eventsPerStream;
    private final ExprEvaluator[] evaluators;
    private final int lookupStream;

    public HistoricalIndexLookupStrategyInKeywordSingle(int lookupStream, ExprNode[] expressions) {
        this.eventsPerStream = new EventBean[lookupStream + 1];
        this.evaluators = ExprNodeUtilityCore.getEvaluatorsNoCompile(expressions);
        this.lookupStream = lookupStream;
    }

    @Override
    public Iterator<EventBean> lookup(EventBean lookupEvent, EventTable[] indexTable, ExprEvaluatorContext exprEvaluatorContext) {
        PropertyIndexedEventTableSingle table = (PropertyIndexedEventTableSingle)indexTable[0];
        this.eventsPerStream[this.lookupStream] = lookupEvent;
        Set<EventBean> result = InKeywordTableLookupUtil.singleIndexLookup(this.evaluators, this.eventsPerStream, exprEvaluatorContext, table);
        if (result == null) {
            return null;
        }
        return result.iterator();
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName();
    }
}

