/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.index.quadtree;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.index.quadtree.AdvancedIndexConfigStatementPointRegionQuadtree;
import com.espertech.esper.epl.index.quadtree.EventTableQuadTree;
import com.espertech.esper.epl.index.service.AdvancedIndexEvaluationHelper;
import com.espertech.esper.epl.join.table.EventTableOrganization;
import com.espertech.esper.spatial.quadtree.core.BoundingBox;
import com.espertech.esper.spatial.quadtree.pointregion.PointRegionQuadTree;
import com.espertech.esper.spatial.quadtree.prqdrowindex.PointRegionQuadTreeRowIndexAdd;
import com.espertech.esper.spatial.quadtree.prqdrowindex.PointRegionQuadTreeRowIndexQuery;
import com.espertech.esper.spatial.quadtree.prqdrowindex.PointRegionQuadTreeRowIndexRemove;
import java.util.Collection;
import java.util.Iterator;

public class EventTableQuadTreePointRegionImpl
implements EventTableQuadTree {
    private final EventTableOrganization organization;
    private final EventBean[] eventsPerStream = new EventBean[1];
    private final AdvancedIndexConfigStatementPointRegionQuadtree config;
    private final PointRegionQuadTree<Object> quadTree;

    public EventTableQuadTreePointRegionImpl(EventTableOrganization organization, AdvancedIndexConfigStatementPointRegionQuadtree config, PointRegionQuadTree<Object> quadTree) {
        this.organization = organization;
        this.config = config;
        this.quadTree = quadTree;
    }

    @Override
    public Collection<EventBean> queryRange(double x, double y, double width, double height) {
        return PointRegionQuadTreeRowIndexQuery.queryRange(this.quadTree, x, y, width, height);
    }

    @Override
    public void addRemove(EventBean[] newData, EventBean[] oldData, ExprEvaluatorContext exprEvaluatorContext) {
        this.remove(oldData, exprEvaluatorContext);
        this.add(newData, exprEvaluatorContext);
    }

    @Override
    public void add(EventBean[] events, ExprEvaluatorContext exprEvaluatorContext) {
        for (EventBean added : events) {
            this.add(added, exprEvaluatorContext);
        }
    }

    @Override
    public void remove(EventBean[] events, ExprEvaluatorContext exprEvaluatorContext) {
        for (EventBean removed : events) {
            this.remove(removed, exprEvaluatorContext);
        }
    }

    @Override
    public void add(EventBean event, ExprEvaluatorContext exprEvaluatorContext) {
        double y;
        this.eventsPerStream[0] = event;
        double x = AdvancedIndexEvaluationHelper.evalDoubleColumn(this.config.getxEval(), this.organization.getIndexName(), "x", this.eventsPerStream, true, exprEvaluatorContext);
        boolean added = PointRegionQuadTreeRowIndexAdd.add(x, y = AdvancedIndexEvaluationHelper.evalDoubleColumn(this.config.getyEval(), this.organization.getIndexName(), "y", this.eventsPerStream, true, exprEvaluatorContext), event, this.quadTree, this.organization.isUnique(), this.organization.getIndexName());
        if (!added) {
            throw AdvancedIndexEvaluationHelper.invalidColumnValue(this.organization.getIndexName(), "(x,y)", "(" + x + "," + y + ")", "a value within index bounding box (range-end-non-inclusive) " + this.quadTree.getRoot().getBb());
        }
    }

    @Override
    public void remove(EventBean event, ExprEvaluatorContext exprEvaluatorContext) {
        this.eventsPerStream[0] = event;
        double x = AdvancedIndexEvaluationHelper.evalDoubleColumn(this.config.getxEval(), this.organization.getIndexName(), "x", this.eventsPerStream, false, exprEvaluatorContext);
        double y = AdvancedIndexEvaluationHelper.evalDoubleColumn(this.config.getyEval(), this.organization.getIndexName(), "y", this.eventsPerStream, false, exprEvaluatorContext);
        PointRegionQuadTreeRowIndexRemove.remove(x, y, event, this.quadTree);
    }

    @Override
    public Iterator<EventBean> iterator() {
        BoundingBox bb = this.quadTree.getRoot().getBb();
        Collection<EventBean> events = this.queryRange(bb.getMinX(), bb.getMinY(), bb.getMaxX() - bb.getMinX(), bb.getMaxY() - bb.getMinY());
        return events.iterator();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public void clear() {
        this.quadTree.clear();
    }

    @Override
    public void destroy() {
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().toString();
    }

    @Override
    public Class getProviderClass() {
        return this.getClass();
    }

    @Override
    public Integer getNumberOfEvents() {
        return null;
    }

    @Override
    public int getNumKeys() {
        return -1;
    }

    @Override
    public Object getIndex() {
        return this.quadTree;
    }

    @Override
    public EventTableOrganization getOrganization() {
        return this.organization;
    }
}

