/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.time;

import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.time.ExprTimePeriodAdder;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConst;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConstFactory;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaResult;
import com.espertech.esper.epl.expression.time.ExprTimePeriodUtil;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import java.util.Calendar;
import java.util.TimeZone;

public class ExprTimePeriodEvalDeltaConstGivenCalAdd
implements ExprTimePeriodEvalDeltaConst,
ExprTimePeriodEvalDeltaConstFactory {
    private final Calendar cal;
    private final ExprTimePeriodAdder.TimePeriodAdder[] adders;
    private final int[] added;
    private final TimeAbacus timeAbacus;
    private final int indexMicroseconds;
    private final TimeZone timeZone;

    public ExprTimePeriodEvalDeltaConstGivenCalAdd(ExprTimePeriodAdder.TimePeriodAdder[] adders, int[] added, TimeZone timeZone, TimeAbacus timeAbacus) {
        this.adders = adders;
        this.added = added;
        this.cal = Calendar.getInstance(timeZone);
        this.timeAbacus = timeAbacus;
        this.indexMicroseconds = ExprTimePeriodUtil.findIndexMicroseconds(adders);
        this.timeZone = timeZone;
    }

    @Override
    public ExprTimePeriodEvalDeltaConst make(String validateMsgName, String validateMsgValue, ExprEvaluatorContext exprEvaluatorContext, TimeAbacus timeAbacus) {
        return this;
    }

    @Override
    public boolean equalsTimePeriod(ExprTimePeriodEvalDeltaConst otherComputation) {
        if (otherComputation instanceof ExprTimePeriodEvalDeltaConstGivenCalAdd) {
            ExprTimePeriodEvalDeltaConstGivenCalAdd other = (ExprTimePeriodEvalDeltaConstGivenCalAdd)otherComputation;
            if (other.adders.length != this.adders.length) {
                return false;
            }
            for (int i = 0; i < this.adders.length; ++i) {
                if (this.added[i] == other.added[i] && this.adders[i].getClass() == other.adders[i].getClass()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized long deltaAdd(long fromTime) {
        long target = this.addSubtract(fromTime, 1);
        return target - fromTime;
    }

    @Override
    public CodegenExpression deltaAddCodegen(CodegenExpression reference, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        CodegenMethodNode method = codegenMethodScope.makeChild(Long.TYPE, ExprTimePeriodEvalDeltaConstGivenCalAdd.class, codegenClassScope).addParam(Long.TYPE, "fromTime").getBlock().declareVar(Long.TYPE, "target", this.addSubtractCodegen(CodegenExpressionBuilder.ref("fromTime"), CodegenExpressionBuilder.constant(1), codegenMethodScope, codegenClassScope)).methodReturn(CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("target"), "-", CodegenExpressionBuilder.ref("fromTime")));
        return CodegenExpressionBuilder.localMethodBuild(method).pass(reference).call();
    }

    @Override
    public synchronized long deltaSubtract(long fromTime) {
        long target = this.addSubtract(fromTime, -1);
        return fromTime - target;
    }

    @Override
    public ExprTimePeriodEvalDeltaResult deltaAddWReference(long fromTime, long reference) {
        long last;
        if (reference > fromTime) {
            while (reference > fromTime) {
                reference -= this.deltaSubtract(reference);
            }
        }
        long next = reference;
        while ((next += this.deltaAdd(last = next)) <= fromTime) {
        }
        return new ExprTimePeriodEvalDeltaResult(next - fromTime, last);
    }

    private long addSubtract(long fromTime, int factor) {
        long remainder = this.timeAbacus.calendarSet(fromTime, this.cal);
        for (int i = 0; i < this.adders.length; ++i) {
            this.adders[i].add(this.cal, factor * this.added[i]);
        }
        long result = this.timeAbacus.calendarGet(this.cal, remainder);
        if (this.indexMicroseconds != -1) {
            result += (long)(factor * this.added[this.indexMicroseconds]);
        }
        return result;
    }

    private CodegenExpression addSubtractCodegen(CodegenExpressionRef fromTime, CodegenExpression factor, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        CodegenMember tz = codegenClassScope.makeAddMember(TimeZone.class, this.timeZone);
        CodegenBlock block = codegenMethodScope.makeChild(Long.TYPE, ExprTimePeriodEvalDeltaConstGivenCalAdd.class, codegenClassScope).addParam(Long.TYPE, "fromTime").addParam(Integer.TYPE, "factor").getBlock().declareVar(Calendar.class, "cal", CodegenExpressionBuilder.staticMethod(Calendar.class, "getInstance", CodegenExpressionBuilder.member(tz.getMemberId()))).declareVar(Long.TYPE, "remainder", this.timeAbacus.calendarSetCodegen(CodegenExpressionBuilder.ref("fromTime"), CodegenExpressionBuilder.ref("cal"), codegenMethodScope, codegenClassScope));
        for (int i = 0; i < this.adders.length; ++i) {
            block.expression(this.adders[i].addCodegen(CodegenExpressionBuilder.ref("cal"), CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("factor"), "*", CodegenExpressionBuilder.constant(this.added[i]))));
        }
        block.declareVar(Long.TYPE, "result", this.timeAbacus.calendarGetCodegen(CodegenExpressionBuilder.ref("cal"), CodegenExpressionBuilder.ref("remainder"), codegenClassScope));
        if (this.indexMicroseconds != -1) {
            block.assignRef("result", CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("result"), "+", CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("factor"), "*", CodegenExpressionBuilder.constant(this.added[this.indexMicroseconds]))));
        }
        CodegenMethodNode method = block.methodReturn(CodegenExpressionBuilder.ref("result"));
        return CodegenExpressionBuilder.localMethodBuild(method).pass(fromTime).pass(factor).call();
    }
}

