/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprForgeComplexityEnum;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.ops.ExprInNodeForgeEvalNoColl;
import com.espertech.esper.epl.expression.ops.ExprInNodeForgeEvalWColl;
import com.espertech.esper.epl.expression.ops.ExprInNodeImpl;
import com.espertech.esper.util.SimpleNumberCoercer;

public class ExprInNodeForge
implements ExprForge {
    private final ExprInNodeImpl parent;
    private final boolean mustCoerce;
    private final SimpleNumberCoercer coercer;
    private final Class coercionType;
    private final boolean hasCollectionOrArray;

    public ExprInNodeForge(ExprInNodeImpl parent, boolean mustCoerce, SimpleNumberCoercer coercer, Class coercionType, boolean hasCollectionOrArray) {
        this.parent = parent;
        this.mustCoerce = mustCoerce;
        this.coercer = coercer;
        this.coercionType = coercionType;
        this.hasCollectionOrArray = hasCollectionOrArray;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        ExprEvaluator[] evaluators = ExprNodeUtilityCore.getEvaluatorsNoCompile(this.parent.getChildNodes());
        if (this.hasCollectionOrArray) {
            return new ExprInNodeForgeEvalWColl(this, evaluators);
        }
        return new ExprInNodeForgeEvalNoColl(this, evaluators);
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return ExprInNodeForgeEvalWColl.codegen(this, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public ExprForgeComplexityEnum getComplexity() {
        return ExprForgeComplexityEnum.INTER;
    }

    @Override
    public Class getEvaluationType() {
        return Boolean.class;
    }

    @Override
    public ExprInNodeImpl getForgeRenderable() {
        return this.parent;
    }

    public boolean isMustCoerce() {
        return this.mustCoerce;
    }

    public SimpleNumberCoercer getCoercer() {
        return this.coercer;
    }

    public Class getCoercionType() {
        return this.coercionType;
    }

    public boolean isHasCollectionOrArray() {
        return this.hasCollectionOrArray;
    }
}

