/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.client.ConfigurationEngineDefaults;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.ops.ExprConcatNodeForge;
import java.io.StringWriter;

public class ExprConcatNode
extends ExprNodeBase {
    private static final long serialVersionUID = 5811427566733004327L;
    private transient ExprConcatNodeForge forge;

    public ExprEvaluator getExprEvaluator() {
        ExprConcatNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprConcatNode.checkValidated(this.forge);
        return this.forge;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length < 2) {
            throw new ExprValidationException("Concat node must have at least 2 parameters");
        }
        for (int i = 0; i < this.getChildNodes().length; ++i) {
            String childTypeName;
            Class childType = this.getChildNodes()[i].getForge().getEvaluationType();
            String string = childTypeName = childType == null ? "null" : childType.getSimpleName();
            if (childType == String.class) continue;
            throw new ExprValidationException("Implicit conversion from datatype '" + childTypeName + "' to string is not allowed");
        }
        ConfigurationEngineDefaults.ThreadingProfile threadingProfile = validationContext.getEngineImportService().getThreadingProfile();
        this.forge = new ExprConcatNodeForge(this, threadingProfile);
        return null;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        String delimiter = "";
        for (ExprNode child : this.getChildNodes()) {
            writer.append(delimiter);
            child.toEPL(writer, this.getPrecedence());
            delimiter = "||";
        }
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.CONCAT;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        return node instanceof ExprConcatNode;
    }
}

