/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.ops.ExprBetweenNodeForge;

public class ExprBetweenNodeForgeEval
implements ExprEvaluator {
    private final ExprBetweenNodeForge forge;
    private final ExprEvaluator valueEval;
    private final ExprEvaluator lowerEval;
    private final ExprEvaluator higherEval;

    public ExprBetweenNodeForgeEval(ExprBetweenNodeForge forge, ExprEvaluator valueEval, ExprEvaluator lowerEval, ExprEvaluator higherEval) {
        this.forge = forge;
        this.valueEval = valueEval;
        this.lowerEval = lowerEval;
        this.higherEval = higherEval;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object value = this.valueEval.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (value == null) {
            return false;
        }
        Object lower = this.lowerEval.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        Object higher = this.higherEval.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        boolean result = this.forge.getComputer().isBetween(value, lower, higher);
        return result ^= this.forge.getForgeRenderable().isNotBetween();
    }

    public static CodegenExpression codegen(ExprBetweenNodeForge forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        ExprNode[] nodes = forge.getForgeRenderable().getChildNodes();
        ExprForge value = nodes[0].getForge();
        ExprForge lower = nodes[1].getForge();
        ExprForge higher = nodes[2].getForge();
        boolean isNot = forge.getForgeRenderable().isNotBetween();
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.class, ExprBetweenNodeForgeEval.class, codegenClassScope);
        CodegenBlock block = methodNode.getBlock();
        Class valueType = value.getEvaluationType();
        block.declareVar(valueType, "value", value.evaluateCodegen(valueType, methodNode, exprSymbol, codegenClassScope));
        if (!valueType.isPrimitive()) {
            block.ifRefNullReturnFalse("value");
        }
        Class lowerType = lower.getEvaluationType();
        block.declareVar(lowerType, "lower", lower.evaluateCodegen(lowerType, methodNode, exprSymbol, codegenClassScope));
        if (!lowerType.isPrimitive()) {
            block.ifRefNull("lower").blockReturn(CodegenExpressionBuilder.constant(isNot));
        }
        Class higherType = higher.getEvaluationType();
        block.declareVar(higherType, "higher", higher.evaluateCodegen(higherType, methodNode, exprSymbol, codegenClassScope));
        if (!higher.getEvaluationType().isPrimitive()) {
            block.ifRefNull("higher").blockReturn(CodegenExpressionBuilder.constant(isNot));
        }
        block.declareVar(Boolean.TYPE, "result", forge.getComputer().codegenNoNullCheck(CodegenExpressionBuilder.ref("value"), value.getEvaluationType(), CodegenExpressionBuilder.ref("lower"), lower.getEvaluationType(), CodegenExpressionBuilder.ref("higher"), higher.getEvaluationType(), methodNode, codegenClassScope));
        block.methodReturn(CodegenExpressionBuilder.notOptional(forge.getForgeRenderable().isNotBetween(), CodegenExpressionBuilder.ref("result")));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }
}

