/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.methodagg;

import com.espertech.esper.epl.agg.service.common.AggregationMethodFactory;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.core.ExprWildcard;

public class ExprCountNode
extends ExprAggregateNodeBase {
    private static final long serialVersionUID = 1859320277242087598L;
    private boolean hasFilter;

    public ExprCountNode(boolean distinct) {
        super(distinct);
    }

    @Override
    public AggregationMethodFactory validateAggregationChild(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.positionalParams.length > 2 || this.positionalParams.length == 0) {
            throw this.makeExceptionExpectedParamNum(1, 2);
        }
        Class childType = null;
        boolean ignoreNulls = false;
        if (this.positionalParams.length == 1 && this.positionalParams[0] instanceof ExprWildcard) {
            this.validateNotDistinct();
        } else if (this.positionalParams.length == 1) {
            childType = this.positionalParams[0].getForge().getEvaluationType();
            ignoreNulls = true;
        } else if (this.positionalParams.length == 2) {
            this.hasFilter = true;
            if (!(this.positionalParams[0] instanceof ExprWildcard)) {
                childType = this.positionalParams[0].getForge().getEvaluationType();
                ignoreNulls = true;
            } else {
                this.validateNotDistinct();
            }
            super.validateFilter(this.positionalParams[1].getForge());
        }
        return validationContext.getEngineImportService().getAggregationFactoryFactory().makeCount(validationContext.getStatementExtensionSvcContext(), this, ignoreNulls, childType);
    }

    @Override
    public String getAggregationFunctionName() {
        return "count";
    }

    public boolean isHasFilter() {
        return this.hasFilter;
    }

    @Override
    public final boolean equalsNodeAggregateMethodOnly(ExprAggregateNode node) {
        return node instanceof ExprCountNode;
    }

    @Override
    protected boolean isFilterExpressionAsLastParameter() {
        return true;
    }

    private void validateNotDistinct() throws ExprValidationException {
        if (super.isDistinct()) {
            throw new ExprValidationException("Invalid use of the 'distinct' keyword with count and wildcard");
        }
    }
}

