/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.funcs;

import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.funcs.ExprCoalesceNodeForge;
import com.espertech.esper.util.CoercionException;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprCoalesceNode
extends ExprNodeBase {
    private static final long serialVersionUID = -8276568753875819730L;
    private transient ExprCoalesceNodeForge forge;

    public ExprEvaluator getExprEvaluator() {
        ExprCoalesceNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprCoalesceNode.checkValidated(this.forge);
        return this.forge;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        Class resultType;
        if (this.getChildNodes().length < 2) {
            throw new ExprValidationException("Coalesce node must have at least 2 parameters");
        }
        Class[] childTypes = new Class[this.getChildNodes().length];
        for (int i = 0; i < this.getChildNodes().length; ++i) {
            childTypes[i] = this.getChildNodes()[i].getForge().getEvaluationType();
        }
        try {
            resultType = JavaClassHelper.getCommonCoercionType(childTypes);
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion not allowed: " + ex.getMessage());
        }
        boolean[] isNumericCoercion = new boolean[this.getChildNodes().length];
        for (int i = 0; i < this.getChildNodes().length; ++i) {
            ExprNode node = this.getChildNodes()[i];
            if (JavaClassHelper.getBoxedType(node.getForge().getEvaluationType()) == resultType || node.getForge().getEvaluationType() == null || resultType == null) continue;
            if (!JavaClassHelper.isNumeric(resultType)) {
                throw new ExprValidationException("Implicit conversion from datatype '" + resultType.getSimpleName() + "' to " + node.getForge().getEvaluationType() + " is not allowed");
            }
            isNumericCoercion[i] = true;
        }
        this.forge = new ExprCoalesceNodeForge(this, resultType, isNumericCoercion);
        return null;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        ExprNodeUtilityCore.toExpressionStringWFunctionName("coalesce", this.getChildNodes(), writer);
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        return node instanceof ExprCoalesceNode;
    }
}

