/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.funcs;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.funcs.ExprCaseNodeForge;
import com.espertech.esper.util.JavaClassHelper;
import java.util.List;
import java.util.Map;

public class ExprCaseNodeForgeEvalSyntax1
implements ExprEvaluator {
    private final ExprCaseNodeForge forge;
    private final List<UniformPair<ExprEvaluator>> whenThenNodeList;
    private final ExprEvaluator optionalElseExprNode;

    public ExprCaseNodeForgeEvalSyntax1(ExprCaseNodeForge forge, List<UniformPair<ExprEvaluator>> whenThenNodeList, ExprEvaluator optionalElseExprNode) {
        this.forge = forge;
        this.whenThenNodeList = whenThenNodeList;
        this.optionalElseExprNode = optionalElseExprNode;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object caseResult = null;
        boolean matched = false;
        for (UniformPair<ExprEvaluator> p : this.whenThenNodeList) {
            Boolean whenResult = (Boolean)p.getFirst().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (whenResult == null || !whenResult.booleanValue()) continue;
            caseResult = p.getSecond().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            matched = true;
            break;
        }
        if (!matched && this.optionalElseExprNode != null) {
            caseResult = this.optionalElseExprNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        if (caseResult == null) {
            return null;
        }
        if (caseResult.getClass() != this.forge.getEvaluationType() && this.forge.isNumericResult()) {
            caseResult = JavaClassHelper.coerceBoxed((Number)caseResult, this.forge.getEvaluationType());
        }
        return caseResult;
    }

    public static CodegenExpression codegen(ExprCaseNodeForge forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        Class evaluationType = forge.getEvaluationType() == null ? Map.class : forge.getEvaluationType();
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(evaluationType, ExprCaseNodeForgeEvalSyntax1.class, codegenClassScope);
        CodegenBlock block = methodNode.getBlock().declareVar(Boolean.class, "when", CodegenExpressionBuilder.constantFalse());
        for (UniformPair<ExprNode> pair : forge.getWhenThenNodeList()) {
            block.assignRef("when", pair.getFirst().getForge().evaluateCodegen(Boolean.class, methodNode, exprSymbol, codegenClassScope));
            block.ifCondition(CodegenExpressionBuilder.and(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref("when")), CodegenExpressionBuilder.ref("when"), new CodegenExpression[0])).blockReturn(ExprCaseNodeForgeEvalSyntax1.codegenToType(forge, pair.getSecond(), methodNode, exprSymbol, codegenClassScope));
        }
        if (forge.getOptionalElseExprNode() != null) {
            block.methodReturn(ExprCaseNodeForgeEvalSyntax1.codegenToType(forge, forge.getOptionalElseExprNode(), methodNode, exprSymbol, codegenClassScope));
        } else {
            block.methodReturn(CodegenExpressionBuilder.constantNull());
        }
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    protected static CodegenExpression codegenToType(ExprCaseNodeForge forge, ExprNode node, CodegenMethodNode methodNode, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        Class nodeEvaluationType = node.getForge().getEvaluationType();
        if (nodeEvaluationType == forge.getEvaluationType() || !forge.isNumericResult()) {
            return node.getForge().evaluateCodegen(nodeEvaluationType, methodNode, exprSymbol, codegenClassScope);
        }
        if (nodeEvaluationType == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        return JavaClassHelper.coerceNumberToBoxedCodegen(node.getForge().evaluateCodegen(nodeEvaluationType, methodNode, exprSymbol, codegenClassScope), nodeEvaluationType, forge.getEvaluationType());
    }
}

