/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import com.espertech.esper.epl.core.streamtype.DuplicatePropertyException;
import com.espertech.esper.epl.core.streamtype.PropertyNotFoundException;
import com.espertech.esper.epl.expression.codegen.CodegenLegoCast;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprForgeComplexityEnum;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.core.ExprVariableNode;
import com.espertech.esper.epl.variable.VariableMetaData;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.event.EventPropertyGetterSPI;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.Map;

public class ExprVariableNodeImpl
extends ExprNodeBase
implements ExprForge,
ExprEvaluator,
ExprVariableNode {
    private static final long serialVersionUID = 0L;
    private final String variableName;
    private final String optSubPropName;
    private final boolean isConstant;
    private final Object valueIfConstant;
    private Class variableType;
    private boolean isPrimitive;
    private transient EventPropertyGetterSPI eventTypeGetter;
    private transient Map<Integer, VariableReader> readersPerCp;
    private transient VariableReader readerNonCP;

    public ExprVariableNodeImpl(VariableMetaData variableMetaData, String optSubPropName) {
        if (variableMetaData == null) {
            throw new IllegalArgumentException("Variables metadata is null");
        }
        this.variableName = variableMetaData.getVariableName();
        this.optSubPropName = optSubPropName;
        this.isConstant = variableMetaData.isConstant();
        this.valueIfConstant = this.isConstant ? variableMetaData.getVariableStateFactory().getInitialState() : null;
    }

    @Override
    public boolean isConstantValue() {
        return this.isConstant;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public String getVariableName() {
        return this.variableName;
    }

    @Override
    public Object getConstantValue(ExprEvaluatorContext context) {
        if (this.isConstant) {
            return this.valueIfConstant;
        }
        return null;
    }

    @Override
    public boolean isConstantResult() {
        return this.isConstant;
    }

    @Override
    public Class getEvaluationType() {
        return this.variableType;
    }

    @Override
    public ExprForge getForge() {
        return this;
    }

    @Override
    public ExprNodeRenderable getForgeRenderable() {
        return this;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        VariableMetaData variableMetadata;
        boolean hasPropertyAgnosticType = false;
        EventType[] types = validationContext.getStreamTypeService().getEventTypes();
        for (int i = 0; i < validationContext.getStreamTypeService().getEventTypes().length; ++i) {
            if (!(types[i] instanceof EventTypeSPI)) continue;
            hasPropertyAgnosticType |= ((EventTypeSPI)types[i]).getMetadata().isPropertyAgnostic();
        }
        if (!hasPropertyAgnosticType) {
            try {
                validationContext.getStreamTypeService().resolveByPropertyName(this.variableName, false);
                throw new ExprValidationException("The variable by name '" + this.variableName + "' is ambigous to a property of the same name");
            }
            catch (DuplicatePropertyException e) {
                throw new ExprValidationException("The variable by name '" + this.variableName + "' is ambigous to a property of the same name");
            }
            catch (PropertyNotFoundException e) {
                // empty catch block
            }
        }
        if ((variableMetadata = validationContext.getVariableService().getVariableMetaData(this.variableName)) == null) {
            throw new ExprValidationException("Failed to find variable by name '" + this.variableName + "'");
        }
        this.isPrimitive = variableMetadata.getEventType() == null;
        this.variableType = variableMetadata.getType();
        if (this.optSubPropName != null) {
            if (variableMetadata.getEventType() == null) {
                throw new ExprValidationException("Property '" + this.optSubPropName + "' is not valid for variable '" + this.variableName + "'");
            }
            this.eventTypeGetter = ((EventTypeSPI)variableMetadata.getEventType()).getGetterSPI(this.optSubPropName);
            if (this.eventTypeGetter == null) {
                throw new ExprValidationException("Property '" + this.optSubPropName + "' is not valid for variable '" + this.variableName + "'");
            }
            this.variableType = variableMetadata.getEventType().getPropertyType(this.optSubPropName);
        }
        this.readersPerCp = validationContext.getVariableService().getReadersPerCP(this.variableName);
        if (variableMetadata.getContextPartitionName() == null) {
            this.readerNonCP = this.readersPerCp.get(-1);
        }
        this.variableType = JavaClassHelper.getBoxedType(this.variableType);
        return null;
    }

    @Override
    public Class getConstantType() {
        return this.variableType;
    }

    public String toString() {
        return "variableName=" + this.variableName;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        VariableReader reader = this.readerNonCP != null ? this.readerNonCP : this.readersPerCp.get(exprEvaluatorContext.getAgentInstanceId());
        Object value = reader.getValue();
        if (this.isPrimitive || value == null) {
            return value;
        }
        EventBean theEvent = (EventBean)value;
        if (this.optSubPropName == null) {
            return theEvent.getUnderlying();
        }
        Object result = this.eventTypeGetter.get(theEvent);
        return result;
    }

    @Override
    public CodegenExpression evaluateCodegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpression readerExpression;
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(this.variableType, ExprVariableNodeImpl.class, codegenClassScope);
        CodegenExpressionRef refExprEvalCtx = exprSymbol.getAddExprEvalCtx(methodNode);
        if (this.readerNonCP != null) {
            CodegenMember memberVariableReader = codegenClassScope.makeAddMember(VariableReader.class, this.readerNonCP);
            readerExpression = CodegenExpressionBuilder.member(memberVariableReader.getMemberId());
        } else {
            CodegenMember memberReadersPerCp = codegenClassScope.makeAddMember(Map.class, this.readersPerCp);
            readerExpression = CodegenExpressionBuilder.cast(VariableReader.class, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.member(memberReadersPerCp.getMemberId()), "get", CodegenExpressionBuilder.exprDotMethod(refExprEvalCtx, "getAgentInstanceId", new CodegenExpression[0])));
        }
        CodegenBlock block = methodNode.getBlock().declareVar(VariableReader.class, "reader", readerExpression);
        if (this.isPrimitive) {
            block.declareVar(this.variableType, "value", CodegenExpressionBuilder.cast(this.variableType, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("reader"), "getValue", new CodegenExpression[0]))).methodReturn(CodegenExpressionBuilder.ref("value"));
        } else {
            block.declareVar(Object.class, "value", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("reader"), "getValue", new CodegenExpression[0])).ifRefNullReturnNull("value").declareVar(EventBean.class, "theEvent", CodegenExpressionBuilder.cast(EventBean.class, (CodegenExpression)CodegenExpressionBuilder.ref("value")));
            if (this.optSubPropName == null) {
                block.methodReturn(CodegenExpressionBuilder.cast(this.variableType, CodegenExpressionBuilder.exprDotUnderlying(CodegenExpressionBuilder.ref("theEvent"))));
            } else {
                block.methodReturn(CodegenLegoCast.castSafeFromObjectType(this.variableType, this.eventTypeGetter.eventBeanGetCodegen(CodegenExpressionBuilder.ref("theEvent"), methodNode, codegenClassScope)));
            }
        }
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    @Override
    public ExprForgeComplexityEnum getComplexity() {
        return ExprForgeComplexityEnum.SINGLE;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append(this.variableName);
        if (this.optSubPropName != null) {
            writer.append(".");
            writer.append(this.optSubPropName);
        }
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprVariableNodeImpl)) {
            return false;
        }
        ExprVariableNodeImpl that = (ExprVariableNodeImpl)node;
        if (this.optSubPropName != null ? !this.optSubPropName.equals(that.optSubPropName) : that.optSubPropName != null) {
            return false;
        }
        return that.variableName.equals(this.variableName);
    }

    @Override
    public String getVariableNameWithSubProp() {
        if (this.optSubPropName == null) {
            return this.variableName;
        }
        return this.variableName + "." + this.optSubPropName;
    }
}

