/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.core;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.expression.core.ExprConstantNode;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprIdentNodeImpl;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.visitor.ExprNodeVisitor;
import com.espertech.esper.epl.expression.visitor.ExprNodeVisitorWithParent;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.util.HashableMultiKeyCastingComparator;
import com.espertech.esper.util.HashableMultiKeyCollatingComparator;
import com.espertech.esper.util.HashableMultiKeyComparator;
import com.espertech.esper.util.ObjectCollatingComparator;
import com.espertech.esper.util.ObjectComparator;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprNodeUtilityCore {
    private static final Logger log = LoggerFactory.getLogger(ExprNodeUtilityCore.class);
    public static final ExprNode[] EMPTY_EXPR_ARRAY = new ExprNode[0];
    public static final ExprForge[] EMPTY_FORGE_ARRAY = new ExprForge[0];

    public static Comparator<Object> getComparatorHashableMultiKeys(ExprNode[] sortCriteria, boolean isSortUsingCollator, boolean[] isDescendingValues) {
        boolean hasStringTypes = false;
        boolean[] stringTypes = new boolean[sortCriteria.length];
        int count = 0;
        for (int i = 0; i < sortCriteria.length; ++i) {
            if (sortCriteria[i].getForge().getEvaluationType() == String.class) {
                hasStringTypes = true;
                stringTypes[count] = true;
            }
            ++count;
        }
        if (sortCriteria.length > 1) {
            if (!hasStringTypes || !isSortUsingCollator) {
                HashableMultiKeyComparator comparatorMK = new HashableMultiKeyComparator(isDescendingValues);
                return new HashableMultiKeyCastingComparator(comparatorMK);
            }
            HashableMultiKeyCollatingComparator comparatorMk = new HashableMultiKeyCollatingComparator(isDescendingValues, stringTypes);
            return new HashableMultiKeyCastingComparator(comparatorMk);
        }
        if (!hasStringTypes || !isSortUsingCollator) {
            return new ObjectComparator(isDescendingValues[0]);
        }
        return new ObjectCollatingComparator(isDescendingValues[0]);
    }

    public static Object evaluateValidationTimeNoStreams(ExprEvaluator evaluator, ExprEvaluatorContext context, String expressionName) throws ExprValidationException {
        try {
            return evaluator.evaluate(null, true, context);
        }
        catch (EPException ex) {
            throw new ExprValidationException("Invalid " + expressionName + " expression: " + ex.getMessage(), ex);
        }
        catch (RuntimeException ex) {
            log.warn("Invalid " + expressionName + " expression evaluation: {}", (Object)ex.getMessage(), (Object)ex);
            throw new ExprValidationException("Invalid " + expressionName + " expression");
        }
    }

    public static boolean deepEqualsIsSubset(ExprNode[] subset, ExprNode[] superset) {
        for (ExprNode subsetNode : subset) {
            boolean found = false;
            for (ExprNode supersetNode : superset) {
                if (!ExprNodeUtilityCore.deepEquals(subsetNode, supersetNode, false)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static boolean deepEqualsIgnoreDupAndOrder(ExprNode[] setOne, ExprNode[] setTwo) {
        if (setOne.length == 0 && setTwo.length != 0 || setOne.length != 0 && setTwo.length == 0) {
            return false;
        }
        boolean[] foundTwo = new boolean[setTwo.length];
        for (ExprNode one : setOne) {
            boolean found = false;
            for (int i = 0; i < setTwo.length; ++i) {
                if (!ExprNodeUtilityCore.deepEquals(one, setTwo[i], false)) continue;
                found = true;
                foundTwo[i] = true;
            }
            if (found) continue;
            return false;
        }
        for (int i = 0; i < foundTwo.length; ++i) {
            if (foundTwo[i]) continue;
            for (ExprNode one : setOne) {
                if (ExprNodeUtilityCore.deepEquals(one, setTwo[i], false)) break;
            }
            return false;
        }
        return true;
    }

    public static String toExpressionStringMinPrecedenceSafe(ExprNode node) {
        try {
            StringWriter writer = new StringWriter();
            node.toEPL(writer, ExprPrecedenceEnum.MINIMUM);
            return writer.toString();
        }
        catch (RuntimeException ex) {
            log.debug("Failed to render expression text: " + ex.getMessage(), (Throwable)ex);
            return "";
        }
    }

    public static String[] toExpressionStringMinPrecedenceAsArray(ExprNode[] nodes) {
        String[] expressions = new String[nodes.length];
        for (int i = 0; i < expressions.length; ++i) {
            StringWriter writer = new StringWriter();
            nodes[i].toEPL(writer, ExprPrecedenceEnum.MINIMUM);
            expressions[i] = writer.toString();
        }
        return expressions;
    }

    public static String toExpressionStringMinPrecedenceAsList(ExprNode[] nodes) {
        StringWriter writer = new StringWriter();
        ExprNodeUtilityCore.toExpressionStringMinPrecedenceAsList(nodes, writer);
        return writer.toString();
    }

    public static void toExpressionStringMinPrecedenceAsList(ExprNode[] nodes, StringWriter writer) {
        String delimiter = "";
        for (ExprNode node : nodes) {
            writer.append(delimiter);
            node.toEPL(writer, ExprPrecedenceEnum.MINIMUM);
            delimiter = ",";
        }
    }

    public static void applyFilterExpressionsIterable(Iterable<EventBean> iterable, List<ExprNode> filterExpressions, ExprEvaluatorContext exprEvaluatorContext, Collection<EventBean> eventsInWindow) {
        ExprEvaluator[] evaluators = ExprNodeUtilityCore.getEvaluatorsNoCompile(filterExpressions);
        EventBean[] events = new EventBean[1];
        Iterator<EventBean> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            EventBean theEvent;
            events[0] = theEvent = iterator.next();
            boolean add = true;
            for (ExprEvaluator filter : evaluators) {
                Object result = filter.evaluate(events, true, exprEvaluatorContext);
                if (result != null && ((Boolean)result).booleanValue()) continue;
                add = false;
                break;
            }
            if (!add) continue;
            eventsInWindow.add(events[0]);
        }
    }

    public static void applyFilterExpressionIterable(Iterator<EventBean> iterator, ExprEvaluator filterExpression, ExprEvaluatorContext exprEvaluatorContext, Collection<EventBean> eventsInWindow) {
        EventBean[] events = new EventBean[1];
        while (iterator.hasNext()) {
            events[0] = iterator.next();
            Object result = filterExpression.evaluate(events, true, exprEvaluatorContext);
            if (result == null || !((Boolean)result).booleanValue()) continue;
            eventsInWindow.add(events[0]);
        }
    }

    public static boolean isConstantValueExpr(ExprNode exprNode) {
        if (!(exprNode instanceof ExprConstantNode)) {
            return false;
        }
        ExprConstantNode constantNode = (ExprConstantNode)exprNode;
        return constantNode.isConstantValue();
    }

    public static Set<String> getPropertyNamesIfAllProps(ExprNode[] expressions) {
        for (ExprNode expression : expressions) {
            if (expression instanceof ExprIdentNode) continue;
            return null;
        }
        HashSet<String> uniquePropertyNames = new HashSet<String>();
        for (ExprNode expression : expressions) {
            ExprIdentNode identNode = (ExprIdentNode)expression;
            uniquePropertyNames.add(identNode.getUnresolvedPropertyName());
        }
        return uniquePropertyNames;
    }

    public static String[] toExpressionStringsMinPrecedence(ExprNode[] expressions) {
        String[] texts = new String[expressions.length];
        for (int i = 0; i < expressions.length; ++i) {
            texts[i] = ExprNodeUtilityCore.toExpressionStringMinPrecedenceSafe(expressions[i]);
        }
        return texts;
    }

    public static List<Pair<ExprNode, ExprNode>> findExpression(ExprNode selectExpression, ExprNode searchExpression) {
        ArrayList<Pair<ExprNode, ExprNode>> pairs = new ArrayList<Pair<ExprNode, ExprNode>>();
        if (ExprNodeUtilityCore.deepEquals(selectExpression, searchExpression, false)) {
            pairs.add(new Pair<Object, ExprNode>(null, selectExpression));
            return pairs;
        }
        ExprNodeUtilityCore.findExpressionChildRecursive(selectExpression, searchExpression, pairs);
        return pairs;
    }

    private static void findExpressionChildRecursive(ExprNode parent, ExprNode searchExpression, List<Pair<ExprNode, ExprNode>> pairs) {
        for (ExprNode child : parent.getChildNodes()) {
            if (ExprNodeUtilityCore.deepEquals(child, searchExpression, false)) {
                pairs.add(new Pair<ExprNode, ExprNode>(parent, child));
                continue;
            }
            ExprNodeUtilityCore.findExpressionChildRecursive(child, searchExpression, pairs);
        }
    }

    public static void toExpressionStringParameterList(ExprNode[] childNodes, StringWriter buffer) {
        String delimiter = "";
        for (ExprNode childNode : childNodes) {
            buffer.append(delimiter);
            buffer.append(ExprNodeUtilityCore.toExpressionStringMinPrecedenceSafe(childNode));
            delimiter = ",";
        }
    }

    public static void toExpressionStringWFunctionName(String functionName, ExprNode[] childNodes, StringWriter writer) {
        writer.append(functionName);
        writer.append("(");
        ExprNodeUtilityCore.toExpressionStringParameterList(childNodes, writer);
        writer.append(')');
    }

    public static String[] getIdentResolvedPropertyNames(ExprNode[] nodes) {
        String[] propertyNames = new String[nodes.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            if (!(nodes[i] instanceof ExprIdentNode)) {
                throw new IllegalArgumentException("Expressions are not ident nodes");
            }
            propertyNames[i] = ((ExprIdentNode)nodes[i]).getResolvedPropertyName();
        }
        return propertyNames;
    }

    public static Class[] getExprResultTypes(ExprNode[] nodes) {
        Class[] types = new Class[nodes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = nodes[i].getForge().getEvaluationType();
        }
        return types;
    }

    public static Class[] getExprResultTypes(ExprForge[] nodes) {
        Class[] types = new Class[nodes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = nodes[i].getEvaluationType();
        }
        return types;
    }

    public static ExprNode[] addExpression(ExprNode[] expressions, ExprNode expression) {
        ExprNode[] target = new ExprNode[expressions.length + 1];
        System.arraycopy(expressions, 0, target, 0, expressions.length);
        target[expressions.length] = expression;
        return target;
    }

    public static EventBean[] applyFilterExpression(ExprEvaluator filter, EventBean streamZeroEvent, EventBean[] streamOneEvents, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean[] eventsPerStream = new EventBean[2];
        eventsPerStream[0] = streamZeroEvent;
        EventBean[] filtered = new EventBean[streamOneEvents.length];
        int countPass = 0;
        EventBean[] eventBeanArray = streamOneEvents;
        int n = eventBeanArray.length;
        for (int i = 0; i < n; ++i) {
            EventBean eventBean;
            eventsPerStream[1] = eventBean = eventBeanArray[i];
            Boolean result = (Boolean)filter.evaluate(eventsPerStream, true, exprEvaluatorContext);
            if (result == null || !result.booleanValue()) continue;
            filtered[countPass] = eventBean;
            ++countPass;
        }
        if (countPass == streamOneEvents.length) {
            return streamOneEvents;
        }
        return EventBeanUtility.resizeArray(filtered, countPass);
    }

    public static boolean applyFilterExpression(ExprEvaluator filter, EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        Boolean result = (Boolean)filter.evaluate(eventsPerStream, true, exprEvaluatorContext);
        return result != null && result != false;
    }

    public static boolean deepEquals(ExprNode nodeOne, ExprNode nodeTwo, boolean ignoreStreamPrefix) {
        if (nodeOne.getChildNodes().length != nodeTwo.getChildNodes().length) {
            return false;
        }
        if (!nodeOne.equalsNode(nodeTwo, ignoreStreamPrefix)) {
            return false;
        }
        for (int i = 0; i < nodeOne.getChildNodes().length; ++i) {
            ExprNode childNodeTwo;
            ExprNode childNodeOne = nodeOne.getChildNodes()[i];
            if (ExprNodeUtilityCore.deepEquals(childNodeOne, childNodeTwo = nodeTwo.getChildNodes()[i], ignoreStreamPrefix)) continue;
            return false;
        }
        return true;
    }

    public static boolean deepEqualsNullChecked(ExprNode nodeOne, ExprNode nodeTwo, boolean ignoreStreamPrefix) {
        if (nodeOne == null) {
            return nodeTwo == null;
        }
        return nodeTwo != null && ExprNodeUtilityCore.deepEquals(nodeOne, nodeTwo, ignoreStreamPrefix);
    }

    public static boolean deepEquals(ExprNode[] one, ExprNode[] two, boolean ignoreStreamPrefix) {
        if (one.length != two.length) {
            return false;
        }
        for (int i = 0; i < one.length; ++i) {
            if (ExprNodeUtilityCore.deepEquals(one[i], two[i], ignoreStreamPrefix)) continue;
            return false;
        }
        return true;
    }

    public static boolean deepEquals(List<ExprNode> one, List<ExprNode> two) {
        if (one.size() != two.size()) {
            return false;
        }
        for (int i = 0; i < one.size(); ++i) {
            if (ExprNodeUtilityCore.deepEquals(one.get(i), two.get(i), false)) continue;
            return false;
        }
        return true;
    }

    public static Object[] evaluateExpressions(ExprEvaluator[] parameters, ExprEvaluatorContext exprEvaluatorContext) {
        Object[] results = new Object[parameters.length];
        int count = 0;
        for (ExprEvaluator expr : parameters) {
            try {
                results[count] = expr.evaluate(null, true, exprEvaluatorContext);
                ++count;
            }
            catch (RuntimeException ex) {
                String message = "Failed expression evaluation in crontab timer-at for parameter " + count + ": " + ex.getMessage();
                log.error(message, (Throwable)ex);
                throw new IllegalArgumentException(message);
            }
        }
        return results;
    }

    public static ExprNode[] toArray(Collection<ExprNode> expressions) {
        if (expressions.isEmpty()) {
            return EMPTY_EXPR_ARRAY;
        }
        return expressions.toArray(new ExprNode[expressions.size()]);
    }

    public static ExprEvaluator[] getEvaluatorsNoCompile(ExprNode[] exprNodes) {
        if (exprNodes == null) {
            return null;
        }
        ExprEvaluator[] eval = new ExprEvaluator[exprNodes.length];
        for (int i = 0; i < exprNodes.length; ++i) {
            ExprNode node = exprNodes[i];
            if (node == null) continue;
            eval[i] = node.getForge().getExprEvaluator();
        }
        return eval;
    }

    public static ExprForge[] getForges(ExprNode[] exprNodes) {
        if (exprNodes == null) {
            return null;
        }
        ExprForge[] forge = new ExprForge[exprNodes.length];
        for (int i = 0; i < exprNodes.length; ++i) {
            ExprNode node = exprNodes[i];
            if (node == null) continue;
            forge[i] = node.getForge();
        }
        return forge;
    }

    public static ExprEvaluator[] getEvaluatorsNoCompile(ExprForge[] forges) {
        if (forges == null) {
            return null;
        }
        ExprEvaluator[] eval = new ExprEvaluator[forges.length];
        for (int i = 0; i < forges.length; ++i) {
            ExprForge forge = forges[i];
            if (forge == null) continue;
            eval[i] = forge.getExprEvaluator();
        }
        return eval;
    }

    public static ExprEvaluator[] getEvaluatorsNoCompile(List<ExprNode> childNodes) {
        ExprEvaluator[] eval = new ExprEvaluator[childNodes.size()];
        for (int i = 0; i < childNodes.size(); ++i) {
            eval[i] = childNodes.get(i).getForge().getExprEvaluator();
        }
        return eval;
    }

    public static void toExpressionStringParams(StringWriter writer, ExprNode[] params) {
        writer.append('(');
        String delimiter = "";
        for (ExprNode childNode : params) {
            writer.append(delimiter);
            delimiter = ",";
            writer.append(ExprNodeUtilityCore.toExpressionStringMinPrecedenceSafe(childNode));
        }
        writer.append(')');
    }

    public static Class[] getExprResultTypes(List<ExprNode> expressions) {
        Class[] returnTypes = new Class[expressions.size()];
        for (int i = 0; i < expressions.size(); ++i) {
            returnTypes[i] = expressions.get(i).getForge().getEvaluationType();
        }
        return returnTypes;
    }

    public static void replaceChildNode(ExprNode parentNode, ExprNode nodeToReplace, ExprNode newNode) {
        int index = ExprNodeUtilityCore.findChildNode(parentNode, nodeToReplace);
        if (index == -1) {
            parentNode.replaceUnlistedChildNode(nodeToReplace, newNode);
        } else {
            parentNode.setChildNode(index, newNode);
        }
    }

    public static void toExpressionStringParameterList(List<ExprNode> parameters, StringWriter buffer) {
        String delimiter = "";
        for (ExprNode param : parameters) {
            buffer.append(delimiter);
            delimiter = ",";
            buffer.append(ExprNodeUtilityCore.toExpressionStringMinPrecedenceSafe(param));
        }
    }

    public static void toExpressionString(ExprNode node, StringWriter buffer) {
        node.toEPL(buffer, ExprPrecedenceEnum.MINIMUM);
    }

    public static void toExpressionStringIncludeParen(List<ExprNode> parameters, StringWriter buffer) {
        buffer.append("(");
        ExprNodeUtilityCore.toExpressionStringParameterList(parameters, buffer);
        buffer.append(")");
    }

    public static String printEvaluators(ExprEvaluator[] evaluators) {
        StringWriter writer = new StringWriter();
        String delimiter = "";
        for (ExprEvaluator evaluator : evaluators) {
            writer.append(delimiter);
            writer.append(evaluator.getClass().getSimpleName());
            delimiter = ", ";
        }
        return writer.toString();
    }

    public static void acceptParams(ExprNodeVisitor visitor, List<ExprNode> params) {
        for (ExprNode param : params) {
            param.accept(visitor);
        }
    }

    public static void acceptParams(ExprNodeVisitorWithParent visitor, List<ExprNode> params) {
        for (ExprNode param : params) {
            param.accept(visitor);
        }
    }

    public static void acceptParams(ExprNodeVisitorWithParent visitor, List<ExprNode> params, ExprNode parent) {
        for (ExprNode param : params) {
            param.acceptChildnodes(visitor, parent);
        }
    }

    public static ExprIdentNode getExprIdentNode(EventType[] typesPerStream, int streamId, String property) {
        return new ExprIdentNodeImpl(typesPerStream[streamId], property, streamId);
    }

    private static int findChildNode(ExprNode parentNode, ExprNode childNode) {
        for (int i = 0; i < parentNode.getChildNodes().length; ++i) {
            if (parentNode.getChildNodes()[i] != childNode) continue;
            return i;
        }
        return -1;
    }
}

