/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprIdentNodeEvaluatorImpl;
import com.espertech.esper.event.EventPropertyGetterSPI;
import com.espertech.esper.util.AuditPath;

public class ExprIdentNodeEvaluatorLogging
extends ExprIdentNodeEvaluatorImpl {
    private final String engineURI;
    private final String propertyName;
    private final String statementName;

    public ExprIdentNodeEvaluatorLogging(int streamNum, EventPropertyGetterSPI propertyGetter, Class returnType, ExprIdentNode identNode, EventType eventType, boolean optionalEvent, String engineURI, String propertyName, String statementName) {
        super(streamNum, propertyGetter, returnType, identNode, eventType, optionalEvent);
        this.engineURI = engineURI;
        this.propertyName = propertyName;
        this.statementName = statementName;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object result = super.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (AuditPath.isInfoEnabled()) {
            AuditPath.auditLog(this.engineURI, this.statementName, AuditEnum.PROPERTY, this.propertyName + " value " + result);
        }
        return result;
    }

    @Override
    public CodegenExpression codegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        if (this.returnType == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        Class castTargetType = this.getCodegenReturnType(requiredType);
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(castTargetType, this.getClass(), codegenClassScope);
        methodNode.getBlock().declareVar(castTargetType, "result", super.codegen(requiredType, methodNode, exprSymbol, codegenClassScope)).ifCondition(CodegenExpressionBuilder.staticMethod(AuditPath.class, "isInfoEnabled", new CodegenExpression[0])).staticMethod(AuditPath.class, "auditLog", CodegenExpressionBuilder.constant(this.engineURI), CodegenExpressionBuilder.constant(this.statementName), CodegenExpressionBuilder.enumValue(AuditEnum.class, "PROPERTY"), CodegenExpressionBuilder.op(CodegenExpressionBuilder.constant(this.propertyName + " value "), "+", CodegenExpressionBuilder.ref("result"))).blockEnd().methodReturn(CodegenExpressionBuilder.ref("result"));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }
}

