/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import com.espertech.esper.epl.expression.codegen.CodegenLegoCast;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprIdentNodeEvaluator;
import com.espertech.esper.event.EventPropertyGetterSPI;
import com.espertech.esper.event.WrapperEventType;
import com.espertech.esper.event.vaevent.RevisionEventType;
import com.espertech.esper.event.vaevent.VariantEventType;

public class ExprIdentNodeEvaluatorImpl
implements ExprIdentNodeEvaluator {
    private final int streamNum;
    private final EventPropertyGetterSPI propertyGetter;
    protected final Class returnType;
    private final ExprIdentNode identNode;
    private final EventType eventType;
    private final boolean optionalEvent;

    public ExprIdentNodeEvaluatorImpl(int streamNum, EventPropertyGetterSPI propertyGetter, Class returnType, ExprIdentNode identNode, EventType eventType, boolean optionalEvent) {
        this.streamNum = streamNum;
        this.propertyGetter = propertyGetter;
        this.returnType = returnType;
        this.identNode = identNode;
        this.eventType = eventType;
        this.optionalEvent = optionalEvent;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean event = eventsPerStream[this.streamNum];
        if (event == null) {
            return null;
        }
        return this.propertyGetter.get(event);
    }

    public Class getCodegenReturnType(Class requiredType) {
        return requiredType == Object.class ? Object.class : this.returnType;
    }

    @Override
    public CodegenExpression codegen(Class requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        boolean useUnderlying;
        if (this.returnType == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        Class castTargetType = this.getCodegenReturnType(requiredType);
        boolean bl = useUnderlying = exprSymbol.isAllowUnderlyingReferences() && !this.identNode.getResolvedPropertyName().contains("?") && !(this.eventType instanceof WrapperEventType) && !(this.eventType instanceof VariantEventType) && !(this.eventType instanceof RevisionEventType);
        if (useUnderlying && !this.optionalEvent) {
            CodegenExpressionRef underlying = exprSymbol.getAddRequiredUnderlying(codegenMethodScope, this.streamNum, this.eventType, false);
            return CodegenLegoCast.castSafeFromObjectType(castTargetType, this.propertyGetter.underlyingGetCodegen(underlying, codegenMethodScope, codegenClassScope));
        }
        CodegenMethodNode method = codegenMethodScope.makeChild(castTargetType, this.getClass(), codegenClassScope);
        CodegenBlock block = method.getBlock();
        if (useUnderlying) {
            CodegenExpressionRef underlying = exprSymbol.getAddRequiredUnderlying(method, this.streamNum, this.eventType, true);
            block.ifRefNullReturnNull(underlying).methodReturn(CodegenLegoCast.castSafeFromObjectType(castTargetType, this.propertyGetter.underlyingGetCodegen(underlying, method, codegenClassScope)));
        } else {
            CodegenExpressionRef refEPS = exprSymbol.getAddEPS(method);
            method.getBlock().declareVar(EventBean.class, "event", CodegenExpressionBuilder.arrayAtIndex(refEPS, CodegenExpressionBuilder.constant(this.streamNum)));
            if (this.optionalEvent) {
                block.ifRefNullReturnNull("event");
            }
            block.methodReturn(CodegenLegoCast.castSafeFromObjectType(castTargetType, this.propertyGetter.eventBeanGetCodegen(CodegenExpressionBuilder.ref("event"), method, codegenClassScope)));
        }
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    @Override
    public Class getEvaluationType() {
        return this.returnType;
    }

    @Override
    public EventPropertyGetterSPI getGetter() {
        return this.propertyGetter;
    }

    @Override
    public boolean evaluatePropertyExists(EventBean[] eventsPerStream, boolean isNewData) {
        EventBean theEvent = eventsPerStream[this.streamNum];
        if (theEvent == null) {
            return false;
        }
        return this.propertyGetter.isExistsProperty(theEvent);
    }

    @Override
    public int getStreamNum() {
        return this.streamNum;
    }

    @Override
    public boolean isContextEvaluated() {
        return false;
    }
}

