/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.core;

import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorProxy;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.util.AuditPath;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ExprForgeProxy
implements InvocationHandler {
    private static final Method TARGET_GETEXPREVALUATOR = JavaClassHelper.getMethodByName(ExprForge.class, "getExprEvaluator");
    private static final Method TARGET_EVALUATECODEGEN = JavaClassHelper.getMethodByName(ExprForge.class, "evaluateCodegen");
    private final String engineURI;
    private final String statementName;
    private final String expressionToString;
    private final ExprForge forge;

    public static Object newInstance(String engineURI, String statementName, String expressionToString, ExprForge forge) {
        return Proxy.newProxyInstance(forge.getClass().getClassLoader(), JavaClassHelper.getSuperInterfaces(forge.getClass()), (InvocationHandler)new ExprForgeProxy(engineURI, statementName, expressionToString, forge));
    }

    public ExprForgeProxy(String engineURI, String statementName, String expressionToString, ExprForge forge) {
        this.engineURI = engineURI;
        this.statementName = statementName;
        this.expressionToString = expressionToString;
        this.forge = forge;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        try {
            if (m.equals(TARGET_GETEXPREVALUATOR)) {
                ExprEvaluator evaluator = (ExprEvaluator)m.invoke((Object)this.forge, args);
                return ExprEvaluatorProxy.newInstance(this.engineURI, this.statementName, this.expressionToString, evaluator);
            }
            if (m.equals(TARGET_EVALUATECODEGEN)) {
                Class evaluationType = this.forge.getEvaluationType();
                Class requiredType = (Class)args[args.length - 4];
                CodegenMethodNode parentMethod = (CodegenMethodNode)args[args.length - 3];
                ExprForgeCodegenSymbol exprSymbol = (ExprForgeCodegenSymbol)args[args.length - 2];
                CodegenClassScope codegenClassScope = (CodegenClassScope)args[args.length - 1];
                if (evaluationType == null) {
                    return this.forge.evaluateCodegen(requiredType, parentMethod, exprSymbol, codegenClassScope);
                }
                CodegenMethodNode methodNode = parentMethod.makeChild(evaluationType, ExprForgeProxy.class, codegenClassScope);
                CodegenBlock block = methodNode.getBlock();
                if (evaluationType == Void.TYPE) {
                    block.expression(this.forge.evaluateCodegen(requiredType, methodNode, exprSymbol, codegenClassScope)).ifCondition(CodegenExpressionBuilder.staticMethod(AuditPath.class, "isInfoEnabled", new CodegenExpression[0])).staticMethod(AuditPath.class, "auditLog", CodegenExpressionBuilder.constant(this.engineURI), CodegenExpressionBuilder.constant(this.statementName), CodegenExpressionBuilder.enumValue(AuditEnum.class, "EXPRESSION"), CodegenExpressionBuilder.constant(this.expressionToString)).blockEnd().methodEnd();
                } else {
                    block.declareVar(evaluationType, "result", this.forge.evaluateCodegen(evaluationType, methodNode, exprSymbol, codegenClassScope)).ifCondition(CodegenExpressionBuilder.staticMethod(AuditPath.class, "isInfoEnabled", new CodegenExpression[0])).staticMethod(AuditPath.class, "auditLog", CodegenExpressionBuilder.constant(this.engineURI), CodegenExpressionBuilder.constant(this.statementName), CodegenExpressionBuilder.enumValue(AuditEnum.class, "EXPRESSION"), CodegenExpressionBuilder.op(CodegenExpressionBuilder.constant(this.expressionToString + " result "), "+", CodegenExpressionBuilder.ref("result"))).blockEnd().methodReturn(CodegenExpressionBuilder.ref("result"));
                }
                return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
            }
            return m.invoke((Object)this.forge, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    static {
        if (TARGET_EVALUATECODEGEN == null || TARGET_GETEXPREVALUATOR == null) {
            throw new RuntimeException("Failed to find required methods");
        }
    }
}

