/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.codegen;

import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionLocalMethod;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenNames;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprForge;

public class CodegenLegoMethodExpression {
    private static final String PASS_NAME = "pass";

    public static CodegenExpression codegenBooleanExpressionReturnTrueFalse(ExprForge forge, CodegenClassScope classScope, CodegenMethodNode parent, CodegenExpression eps, CodegenExpression isNewData, CodegenExpression exprEvalCtx) {
        CodegenLegoMethodExpression.checkEvaluationType(forge);
        CodegenMethodNode expressionMethod = CodegenLegoMethodExpression.codegenBooleanExpressionBoxedToPrimitive(forge, parent, classScope);
        return CodegenExpressionBuilder.localMethod(expressionMethod, eps, isNewData, exprEvalCtx);
    }

    public static void codegenBooleanExpressionReturnNullIfNullOrNotPass(ExprForge forge, CodegenClassScope classScope, CodegenMethodNode parent, CodegenExpression eps, CodegenExpression isNewData, CodegenExpression exprEvalCtx) {
        CodegenLegoMethodExpression.checkEvaluationType(forge);
        CodegenMethodNode expressionMethod = CodegenLegoMethodExpression.codegenBooleanExpressionBoxedToPrimitive(forge, parent, classScope);
        CodegenExpressionLocalMethod evaluation = CodegenExpressionBuilder.localMethod(expressionMethod, eps, isNewData, exprEvalCtx);
        parent.getBlock().ifCondition(CodegenExpressionBuilder.not(evaluation)).blockReturn(CodegenExpressionBuilder.constantNull());
    }

    public static void codegenBooleanExpressionReturnIfNullOrNotPass(ExprForge forge, CodegenClassScope classScope, CodegenMethodNode parent, CodegenExpression eps, CodegenExpression isNewData, CodegenExpression exprEvalCtx) {
        CodegenLegoMethodExpression.checkEvaluationType(forge);
        CodegenMethodNode expressionMethod = CodegenLegoMethodExpression.codegenBooleanExpressionBoxedToPrimitive(forge, parent, classScope);
        CodegenExpressionLocalMethod evaluation = CodegenExpressionBuilder.localMethod(expressionMethod, eps, isNewData, exprEvalCtx);
        parent.getBlock().ifCondition(CodegenExpressionBuilder.not(evaluation)).blockReturnNoValue();
    }

    public static CodegenMethodNode codegenExpression(ExprForge forge, CodegenMethodNode parent, CodegenClassScope classScope) {
        Class evaluationType = forge.getEvaluationType();
        ExprForgeCodegenSymbol exprSymbol = new ExprForgeCodegenSymbol(true, null);
        CodegenMethodNode exprMethod = parent.makeChildWithScope(evaluationType, CodegenLegoMethodExpression.class, exprSymbol, classScope).addParam(ExprForgeCodegenNames.PARAMS);
        CodegenExpression expression = forge.evaluateCodegen(evaluationType, exprMethod, exprSymbol, classScope);
        exprSymbol.derivedSymbolsCodegen(parent, exprMethod.getBlock(), classScope);
        exprMethod.getBlock().methodReturn(expression);
        return exprMethod;
    }

    private static CodegenMethodNode codegenBooleanExpressionBoxedToPrimitive(ExprForge forge, CodegenMethodNode parent, CodegenClassScope classScope) {
        Class evaluationType = forge.getEvaluationType();
        ExprForgeCodegenSymbol exprSymbol = new ExprForgeCodegenSymbol(true, null);
        CodegenMethodNode exprMethod = parent.makeChildWithScope(Boolean.TYPE, CodegenLegoMethodExpression.class, exprSymbol, classScope).addParam(ExprForgeCodegenNames.PARAMS);
        CodegenExpression expression = forge.evaluateCodegen(evaluationType, exprMethod, exprSymbol, classScope);
        exprSymbol.derivedSymbolsCodegen(parent, exprMethod.getBlock(), classScope);
        if (evaluationType.isPrimitive()) {
            exprMethod.getBlock().methodReturn(expression);
        } else {
            exprMethod.getBlock().declareVar(evaluationType, PASS_NAME, expression).ifRefNull(PASS_NAME).blockReturn(CodegenExpressionBuilder.constantFalse()).methodReturn(CodegenExpressionBuilder.ref(PASS_NAME));
        }
        return exprMethod;
    }

    private static void checkEvaluationType(ExprForge forge) {
        Class evaluationType = forge.getEvaluationType();
        if (evaluationType != Boolean.TYPE && evaluationType != Boolean.class) {
            throw new IllegalStateException("Invalid non-boolean expression");
        }
    }
}

