/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.codegen;

import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;

public class CodegenLegoBooleanExpression {
    private static final String PASS_NAME = "pass";

    public static void codegenReturnBoolIfNullOrBool(CodegenBlock block, Class evaluationType, CodegenExpression expression, boolean earlyExitIfNull, Boolean resultEarlyExit, boolean checkFor, boolean resultIfCheckPasses) {
        if (evaluationType != Boolean.TYPE && evaluationType != Boolean.class) {
            throw new IllegalStateException("Invalid non-boolean expression");
        }
        block.declareVar(evaluationType, PASS_NAME, expression);
        CodegenExpression passCheck = CodegenExpressionBuilder.notOptional(!checkFor, CodegenExpressionBuilder.ref(PASS_NAME));
        if (evaluationType.isPrimitive()) {
            block.ifCondition(passCheck).blockReturn(CodegenExpressionBuilder.constant(resultIfCheckPasses));
            return;
        }
        if (earlyExitIfNull) {
            if (resultEarlyExit == null) {
                throw new IllegalStateException("Invalid null for result-early-exit");
            }
            block.ifRefNull(PASS_NAME).blockReturn(CodegenExpressionBuilder.constant(resultEarlyExit));
            block.ifCondition(passCheck).blockReturn(CodegenExpressionBuilder.constant(resultIfCheckPasses));
            return;
        }
        block.ifCondition(CodegenExpressionBuilder.and(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref(PASS_NAME)), passCheck, new CodegenExpression[0])).blockReturn(CodegenExpressionBuilder.constant(resultIfCheckPasses));
    }

    public static void codegenReturnValueIfNullOrNotPass(CodegenBlock block, Class evaluationType, CodegenExpression expression, CodegenExpression value) {
        CodegenLegoBooleanExpression.codegenDoIfNullOrNotPass(block, evaluationType, expression, false, false, true, value);
    }

    public static void codegenBreakIfNullOrNotPass(CodegenBlock block, Class evaluationType, CodegenExpression expression) {
        CodegenLegoBooleanExpression.codegenDoIfNullOrNotPass(block, evaluationType, expression, false, true, false, CodegenExpressionBuilder.constantNull());
    }

    public static void codegenContinueIfNullOrNotPass(CodegenBlock block, Class evaluationType, CodegenExpression expression) {
        CodegenLegoBooleanExpression.codegenDoIfNullOrNotPass(block, evaluationType, expression, true, false, false, CodegenExpressionBuilder.constantNull());
    }

    private static void codegenDoIfNullOrNotPass(CodegenBlock block, Class evaluationType, CodegenExpression expression, boolean doContinue, boolean doBreakLoop, boolean doReturn, CodegenExpression returnValue) {
        if (evaluationType != Boolean.TYPE && evaluationType != Boolean.class) {
            throw new IllegalStateException("Invalid non-boolean expression");
        }
        block.declareVar(evaluationType, PASS_NAME, expression);
        CodegenExpression passCheck = CodegenExpressionBuilder.not(CodegenExpressionBuilder.ref(PASS_NAME));
        CodegenExpression condition = evaluationType.isPrimitive() ? passCheck : CodegenExpressionBuilder.and(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref(PASS_NAME)), passCheck, new CodegenExpression[0]);
        if (doContinue) {
            block.ifCondition(condition).blockContinue();
        } else if (doBreakLoop) {
            block.ifCondition(condition).breakLoop();
        } else {
            block.ifCondition(condition).blockReturn(returnValue);
        }
    }
}

