/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.accessagg;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.core.service.StatementType;
import com.espertech.esper.epl.agg.access.AggregationAccessorFirstLastIndexNoEvalForge;
import com.espertech.esper.epl.agg.access.AggregationAccessorFirstLastIndexWEvalForge;
import com.espertech.esper.epl.agg.access.AggregationAccessorFirstNoEval;
import com.espertech.esper.epl.agg.access.AggregationAccessorFirstWEvalForge;
import com.espertech.esper.epl.agg.access.AggregationAccessorForge;
import com.espertech.esper.epl.agg.access.AggregationAccessorLastNoEval;
import com.espertech.esper.epl.agg.access.AggregationAccessorLastWEvalForge;
import com.espertech.esper.epl.agg.access.AggregationAccessorWindowNoEval;
import com.espertech.esper.epl.agg.access.AggregationAccessorWindowWEvalForge;
import com.espertech.esper.epl.agg.access.AggregationAgentDefault;
import com.espertech.esper.epl.agg.access.AggregationAgentForge;
import com.espertech.esper.epl.agg.access.AggregationStateType;
import com.espertech.esper.epl.agg.service.common.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.common.AggregationStateFactoryForge;
import com.espertech.esper.epl.agg.service.common.AggregationStateKeyWStream;
import com.espertech.esper.epl.agg.service.common.AggregationStateTypeWStream;
import com.espertech.esper.epl.core.streamtype.StreamTypeService;
import com.espertech.esper.epl.core.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.accessagg.ExprAggAggregationAgentFactory;
import com.espertech.esper.epl.expression.accessagg.ExprAggMultiFunctionLinearAccessNodeFactoryAccess;
import com.espertech.esper.epl.expression.accessagg.ExprAggMultiFunctionUtil;
import com.espertech.esper.epl.expression.accessagg.ExprAggregateAccessMultiValueNode;
import com.espertech.esper.epl.expression.accessagg.LinearAggregationFactoryDesc;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.codegen.CodegenLegoEvaluateSelf;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEnumerationEval;
import com.espertech.esper.epl.expression.core.ExprEnumerationForge;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.core.ExprStreamUnderlyingNode;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.core.ExprWildcard;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumnAggregation;
import com.espertech.esper.epl.table.mgmt.TableServiceUtil;
import com.espertech.esper.epl.util.ExprNodeUtilityRich;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;

public class ExprAggMultiFunctionLinearAccessNode
extends ExprAggregateNodeBase
implements ExprEnumerationForge,
ExprEnumerationEval,
ExprAggregateAccessMultiValueNode {
    private static final long serialVersionUID = -6088874732989061687L;
    private final AggregationStateType stateType;
    private transient EventType containedType;
    private transient Class scalarCollectionComponentType;

    public ExprAggMultiFunctionLinearAccessNode(AggregationStateType stateType) {
        super(false);
        this.stateType = stateType;
    }

    @Override
    public AggregationMethodFactory validateAggregationChild(ExprValidationContext validationContext) throws ExprValidationException {
        return this.validateAggregationInternal(validationContext, null);
    }

    @Override
    public AggregationMethodFactory validateAggregationParamsWBinding(ExprValidationContext validationContext, TableMetadataColumnAggregation tableAccessColumn) throws ExprValidationException {
        return this.validateAggregationInternal(validationContext, tableAccessColumn);
    }

    @Override
    public ExprEnumerationEval getExprEvaluatorEnumeration() {
        return this;
    }

    @Override
    public CodegenExpression evaluateGetROCollectionScalarCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CodegenLegoEvaluateSelf.evaluateSelfGetROCollectionScalar(this, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public CodegenExpression evaluateGetEventBeanCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CodegenLegoEvaluateSelf.evaluateSelfGetEventBean(this, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    private AggregationMethodFactory validateAggregationInternal(ExprValidationContext validationContext, TableMetadataColumnAggregation optionalBinding) throws ExprValidationException {
        LinearAggregationFactoryDesc desc = optionalBinding != null ? this.handleTableAccess(this.positionalParams, this.stateType, validationContext, optionalBinding) : (validationContext.getExprEvaluatorContext().getStatementType() == StatementType.CREATE_TABLE ? this.handleCreateTable(this.positionalParams, this.stateType, validationContext) : (validationContext.getIntoTableName() != null ? this.handleIntoTable(this.positionalParams, this.stateType, validationContext) : this.handleNonIntoTable(this.positionalParams, this.stateType, validationContext)));
        this.containedType = desc.getEnumerationEventType();
        this.scalarCollectionComponentType = desc.getScalarCollectionType();
        return desc.getFactory();
    }

    private LinearAggregationFactoryDesc handleNonIntoTable(ExprNode[] childNodes, AggregationStateType stateType, ExprValidationContext validationContext) throws ExprValidationException {
        AggregationAccessorForge accessor;
        boolean istreamOnly;
        ExprForge forge;
        Class resultType;
        EventType containedType;
        int streamNum;
        boolean isWildcard;
        StreamTypeService streamTypeService = validationContext.getStreamTypeService();
        ExprNode evaluatorIndex = null;
        Class scalarCollectionComponentType = null;
        boolean bl = isWildcard = childNodes.length == 0 || childNodes.length > 0 && childNodes[0] instanceof ExprWildcard;
        if (isWildcard) {
            ExprAggMultiFunctionUtil.validateWildcardStreamNumbers(validationContext.getStreamTypeService(), stateType.toString().toLowerCase(Locale.ENGLISH));
            streamNum = 0;
            containedType = streamTypeService.getEventTypes()[0];
            resultType = containedType.getUnderlyingType();
            TableMetadata tableMetadata = validationContext.getTableService().getTableMetadataFromEventType(containedType);
            forge = ExprNodeUtilityRich.makeUnderlyingForge(0, resultType, tableMetadata);
            istreamOnly = ExprAggMultiFunctionLinearAccessNode.getIstreamOnly(streamTypeService, 0);
            if (stateType == AggregationStateType.WINDOW && istreamOnly && !streamTypeService.isOnDemandStreams()) {
                throw ExprAggMultiFunctionLinearAccessNode.makeUnboundValidationEx(stateType);
            }
        } else if (childNodes.length > 0 && childNodes[0] instanceof ExprStreamUnderlyingNode) {
            EventType type;
            streamNum = ExprAggMultiFunctionUtil.validateStreamWildcardGetStreamNum(childNodes[0]);
            istreamOnly = ExprAggMultiFunctionLinearAccessNode.getIstreamOnly(streamTypeService, streamNum);
            if (stateType == AggregationStateType.WINDOW && istreamOnly && !streamTypeService.isOnDemandStreams()) {
                throw ExprAggMultiFunctionLinearAccessNode.makeUnboundValidationEx(stateType);
            }
            containedType = type = streamTypeService.getEventTypes()[streamNum];
            resultType = type.getUnderlyingType();
            TableMetadata tableMetadata = validationContext.getTableService().getTableMetadataFromEventType(type);
            forge = ExprNodeUtilityRich.makeUnderlyingForge(streamNum, resultType, tableMetadata);
        } else {
            ExprNode child = childNodes[0];
            Set<Integer> streams = ExprNodeUtilityRich.getIdentStreamNumbers(child);
            if (streams.isEmpty() || streams.size() > 1) {
                throw new ExprValidationException(ExprAggMultiFunctionLinearAccessNode.getErrorPrefix(stateType) + " requires that any child expressions evaluate properties of the same stream; Use 'firstever' or 'lastever' or 'nth' instead");
            }
            streamNum = streams.iterator().next();
            istreamOnly = ExprAggMultiFunctionLinearAccessNode.getIstreamOnly(streamTypeService, streamNum);
            if (stateType == AggregationStateType.WINDOW && istreamOnly && !streamTypeService.isOnDemandStreams()) {
                throw ExprAggMultiFunctionLinearAccessNode.makeUnboundValidationEx(stateType);
            }
            resultType = childNodes[0].getForge().getEvaluationType();
            forge = childNodes[0].getForge();
            containedType = streamNum >= streamTypeService.getEventTypes().length ? streamTypeService.getEventTypes()[0] : streamTypeService.getEventTypes()[streamNum];
            scalarCollectionComponentType = resultType;
        }
        if (childNodes.length > 1) {
            if (stateType == AggregationStateType.WINDOW) {
                throw new ExprValidationException(ExprAggMultiFunctionLinearAccessNode.getErrorPrefix(stateType) + " does not accept an index expression; Use 'first' or 'last' instead");
            }
            evaluatorIndex = childNodes[1];
            Class indexResultType = evaluatorIndex.getForge().getEvaluationType();
            if (indexResultType != Integer.class && indexResultType != Integer.TYPE) {
                throw new ExprValidationException(ExprAggMultiFunctionLinearAccessNode.getErrorPrefix(stateType) + " requires an index expression that returns an integer value");
            }
        }
        if (evaluatorIndex != null) {
            ExprForge forgeIndex;
            boolean isFirst = stateType == AggregationStateType.FIRST;
            int constant = -1;
            if (evaluatorIndex.isConstantResult()) {
                constant = (Integer)evaluatorIndex.getForge().getExprEvaluator().evaluate(null, true, null);
                forgeIndex = null;
            } else {
                forgeIndex = evaluatorIndex.getForge();
            }
            accessor = new AggregationAccessorFirstLastIndexWEvalForge(streamNum, forge, forgeIndex, constant, isFirst);
        } else if (stateType == AggregationStateType.FIRST) {
            accessor = new AggregationAccessorFirstWEvalForge(streamNum, forge);
        } else if (stateType == AggregationStateType.LAST) {
            accessor = new AggregationAccessorLastWEvalForge(streamNum, forge);
        } else if (stateType == AggregationStateType.WINDOW) {
            accessor = new AggregationAccessorWindowWEvalForge(streamNum, forge, resultType);
        } else {
            throw new IllegalStateException("Access type is undefined or not known as code '" + (Object)((Object)stateType) + "'");
        }
        Class accessorResultType = resultType;
        if (stateType == AggregationStateType.WINDOW) {
            accessorResultType = JavaClassHelper.getArrayType(resultType);
        }
        boolean isFafWindow = streamTypeService.isOnDemandStreams() && stateType == AggregationStateType.WINDOW;
        TableMetadata tableMetadata = validationContext.getTableService().getTableMetadataFromEventType(containedType);
        if (tableMetadata == null && !isFafWindow && (istreamOnly || streamTypeService.isOnDemandStreams())) {
            if (this.optionalFilter != null) {
                this.positionalParams = ExprNodeUtilityCore.addExpression(this.positionalParams, this.optionalFilter);
            }
            AggregationMethodFactory factory = validationContext.getEngineImportService().getAggregationFactoryFactory().makeLinearUnbounded(validationContext.getStatementExtensionSvcContext(), this, containedType, accessorResultType, streamNum, this.optionalFilter != null);
            return new LinearAggregationFactoryDesc(factory, containedType, scalarCollectionComponentType);
        }
        AggregationStateKeyWStream stateKey = new AggregationStateKeyWStream(streamNum, containedType, AggregationStateTypeWStream.DATAWINDOWACCESS_LINEAR, ExprNodeUtilityCore.EMPTY_EXPR_ARRAY, this.optionalFilter);
        ExprForge optionalFilterForge = this.optionalFilter == null ? null : this.optionalFilter.getForge();
        boolean join = validationContext.getStreamTypeService().getEventTypes().length > 1;
        AggregationStateFactoryForge stateFactory = validationContext.getEngineImportService().getAggregationFactoryFactory().makeLinear(validationContext.getStatementExtensionSvcContext(), this, streamNum, optionalFilterForge, join);
        ExprAggMultiFunctionLinearAccessNodeFactoryAccess factory = new ExprAggMultiFunctionLinearAccessNodeFactoryAccess(this, accessor, accessorResultType, containedType, stateKey, stateFactory, AggregationAgentDefault.INSTANCE);
        EventType enumerationType = scalarCollectionComponentType == null ? containedType : null;
        return new LinearAggregationFactoryDesc(factory, enumerationType, scalarCollectionComponentType);
    }

    private LinearAggregationFactoryDesc handleCreateTable(ExprNode[] childNodes, AggregationStateType stateType, ExprValidationContext validationContext) throws ExprValidationException {
        String message = "For tables columns, the " + stateType.name().toLowerCase(Locale.ENGLISH) + " aggregation function requires the 'window(*)' declaration";
        if (stateType != AggregationStateType.WINDOW) {
            throw new ExprValidationException(message);
        }
        if (childNodes.length == 0 || childNodes.length > 1 || !(childNodes[0] instanceof ExprWildcard)) {
            throw new ExprValidationException(message);
        }
        if (validationContext.getStreamTypeService().getStreamNames().length == 0) {
            throw new ExprValidationException(ExprAggMultiFunctionLinearAccessNode.getErrorPrefix(stateType) + " requires that the event type is provided");
        }
        EventType containedType = validationContext.getStreamTypeService().getEventTypes()[0];
        Class componentType = containedType.getUnderlyingType();
        AggregationAccessorWindowNoEval accessor = new AggregationAccessorWindowNoEval(componentType);
        boolean join = validationContext.getStreamTypeService().getEventTypes().length > 1;
        AggregationStateFactoryForge stateFactory = validationContext.getEngineImportService().getAggregationFactoryFactory().makeLinear(validationContext.getStatementExtensionSvcContext(), this, 0, null, join);
        ExprAggMultiFunctionLinearAccessNodeFactoryAccess factory = new ExprAggMultiFunctionLinearAccessNodeFactoryAccess(this, accessor, JavaClassHelper.getArrayType(componentType), containedType, null, stateFactory, null);
        return new LinearAggregationFactoryDesc(factory, factory.getContainedEventType(), null);
    }

    private LinearAggregationFactoryDesc handleIntoTable(ExprNode[] childNodes, AggregationStateType stateType, ExprValidationContext validationContext) throws ExprValidationException {
        int streamNum;
        String message = "For into-table use 'window(*)' or 'window(stream.*)' instead";
        if (stateType != AggregationStateType.WINDOW) {
            throw new ExprValidationException(message);
        }
        if (childNodes.length == 0 || childNodes.length > 1) {
            throw new ExprValidationException(message);
        }
        if (validationContext.getStreamTypeService().getStreamNames().length == 0) {
            throw new ExprValidationException(ExprAggMultiFunctionLinearAccessNode.getErrorPrefix(stateType) + " requires that at least one stream is provided");
        }
        if (childNodes[0] instanceof ExprWildcard) {
            if (validationContext.getStreamTypeService().getStreamNames().length != 1) {
                throw new ExprValidationException(ExprAggMultiFunctionLinearAccessNode.getErrorPrefix(stateType) + " with wildcard requires a single stream");
            }
            streamNum = 0;
        } else if (childNodes[0] instanceof ExprStreamUnderlyingNode) {
            ExprStreamUnderlyingNode und = (ExprStreamUnderlyingNode)childNodes[0];
            streamNum = und.getStreamId();
        } else {
            throw new ExprValidationException(message);
        }
        EventType containedType = validationContext.getStreamTypeService().getEventTypes()[streamNum];
        Class componentType = containedType.getUnderlyingType();
        AggregationAccessorWindowNoEval accessor = new AggregationAccessorWindowNoEval(componentType);
        AggregationAgentForge agent = ExprAggAggregationAgentFactory.make(streamNum, this.optionalFilter, validationContext.getEngineImportService(), validationContext.getStreamTypeService().isOnDemandStreams(), validationContext.getStatementName());
        ExprAggMultiFunctionLinearAccessNodeFactoryAccess factory = new ExprAggMultiFunctionLinearAccessNodeFactoryAccess(this, accessor, JavaClassHelper.getArrayType(componentType), containedType, null, null, agent);
        return new LinearAggregationFactoryDesc(factory, factory.getContainedEventType(), null);
    }

    private LinearAggregationFactoryDesc handleTableAccess(ExprNode[] childNodes, AggregationStateType stateType, ExprValidationContext validationContext, TableMetadataColumnAggregation tableAccess) throws ExprValidationException {
        if (stateType == AggregationStateType.FIRST || stateType == AggregationStateType.LAST) {
            return this.handleTableAccessFirstLast(childNodes, stateType, validationContext, tableAccess);
        }
        if (stateType == AggregationStateType.WINDOW) {
            return this.handleTableAccessWindow(childNodes, stateType, validationContext, tableAccess);
        }
        throw new IllegalStateException("Unrecognized type " + (Object)((Object)stateType));
    }

    private LinearAggregationFactoryDesc handleTableAccessFirstLast(ExprNode[] childNodes, AggregationStateType stateType, ExprValidationContext validationContext, TableMetadataColumnAggregation tableAccess) throws ExprValidationException {
        AggregationAccessorForge defaultAccessor;
        ExprAggMultiFunctionLinearAccessNodeFactoryAccess original = (ExprAggMultiFunctionLinearAccessNodeFactoryAccess)tableAccess.getFactory();
        Class resultType = original.getContainedEventType().getUnderlyingType();
        AggregationAccessorForge aggregationAccessorForge = defaultAccessor = stateType == AggregationStateType.FIRST ? AggregationAccessorFirstNoEval.INSTANCE : AggregationAccessorLastNoEval.INSTANCE;
        if (childNodes.length == 0) {
            ExprAggMultiFunctionLinearAccessNodeFactoryAccess factoryAccess = new ExprAggMultiFunctionLinearAccessNodeFactoryAccess(this, defaultAccessor, resultType, original.getContainedEventType(), null, null, null);
            return new LinearAggregationFactoryDesc(factoryAccess, factoryAccess.getContainedEventType(), null);
        }
        if (childNodes.length == 1) {
            if (childNodes[0] instanceof ExprWildcard) {
                ExprAggMultiFunctionLinearAccessNodeFactoryAccess factoryAccess = new ExprAggMultiFunctionLinearAccessNodeFactoryAccess(this, defaultAccessor, resultType, original.getContainedEventType(), null, null, null);
                return new LinearAggregationFactoryDesc(factoryAccess, factoryAccess.getContainedEventType(), null);
            }
            if (childNodes[0] instanceof ExprStreamUnderlyingNode) {
                throw new ExprValidationException("Stream-wildcard is not allowed for table column access");
            }
            ExprNode paramNode = childNodes[0];
            StreamTypeServiceImpl streams = TableServiceUtil.streamTypeFromTableColumn(tableAccess, validationContext.getStreamTypeService().getEngineURIQualifier());
            ExprValidationContext localValidationContext = new ExprValidationContext(streams, validationContext);
            paramNode = ExprNodeUtilityRich.getValidatedSubtree(ExprNodeOrigin.AGGPARAM, paramNode, localValidationContext);
            ExprForge paramNodeForge = paramNode.getForge();
            AggregationAccessorForge accessor = stateType == AggregationStateType.FIRST ? new AggregationAccessorFirstWEvalForge(0, paramNodeForge) : new AggregationAccessorLastWEvalForge(0, paramNodeForge);
            ExprAggMultiFunctionLinearAccessNodeFactoryAccess factory = new ExprAggMultiFunctionLinearAccessNodeFactoryAccess(this, accessor, paramNode.getForge().getEvaluationType(), original.getContainedEventType(), null, null, null);
            return new LinearAggregationFactoryDesc(factory, factory.getContainedEventType(), null);
        }
        if (childNodes.length == 2) {
            ExprForge forgeIndex;
            boolean isFirst = stateType == AggregationStateType.FIRST;
            int constant = -1;
            ExprNode indexEvalNode = childNodes[1];
            Class indexEvalType = indexEvalNode.getForge().getEvaluationType();
            if (indexEvalType != Integer.class && indexEvalType != Integer.TYPE) {
                throw new ExprValidationException(ExprAggMultiFunctionLinearAccessNode.getErrorPrefix(stateType) + " requires a constant index expression that returns an integer value");
            }
            if (indexEvalNode.isConstantResult()) {
                constant = (Integer)indexEvalNode.getForge().getExprEvaluator().evaluate(null, true, null);
                forgeIndex = null;
            } else {
                forgeIndex = indexEvalNode.getForge();
            }
            AggregationAccessorFirstLastIndexNoEvalForge accessor = new AggregationAccessorFirstLastIndexNoEvalForge(forgeIndex, constant, isFirst);
            ExprAggMultiFunctionLinearAccessNodeFactoryAccess factory = new ExprAggMultiFunctionLinearAccessNodeFactoryAccess(this, accessor, resultType, original.getContainedEventType(), null, null, null);
            return new LinearAggregationFactoryDesc(factory, factory.getContainedEventType(), null);
        }
        throw new ExprValidationException("Invalid number of parameters");
    }

    private LinearAggregationFactoryDesc handleTableAccessWindow(ExprNode[] childNodes, AggregationStateType stateType, ExprValidationContext validationContext, TableMetadataColumnAggregation tableAccess) throws ExprValidationException {
        ExprAggMultiFunctionLinearAccessNodeFactoryAccess original = (ExprAggMultiFunctionLinearAccessNodeFactoryAccess)tableAccess.getFactory();
        if (childNodes.length == 0 || childNodes.length == 1 && childNodes[0] instanceof ExprWildcard) {
            Class componentType = original.getContainedEventType().getUnderlyingType();
            AggregationAccessorWindowNoEval accessor = new AggregationAccessorWindowNoEval(componentType);
            ExprAggMultiFunctionLinearAccessNodeFactoryAccess factory = new ExprAggMultiFunctionLinearAccessNodeFactoryAccess(this, accessor, JavaClassHelper.getArrayType(componentType), original.getContainedEventType(), null, null, null);
            return new LinearAggregationFactoryDesc(factory, factory.getContainedEventType(), null);
        }
        if (childNodes.length == 1) {
            ExprNode paramNode = childNodes[0];
            StreamTypeServiceImpl streams = TableServiceUtil.streamTypeFromTableColumn(tableAccess, validationContext.getStreamTypeService().getEngineURIQualifier());
            ExprValidationContext localValidationContext = new ExprValidationContext(streams, validationContext);
            paramNode = ExprNodeUtilityRich.getValidatedSubtree(ExprNodeOrigin.AGGPARAM, paramNode, localValidationContext);
            Class paramNodeType = paramNode.getForge().getEvaluationType();
            ExprForge paramNodeEval = paramNode.getForge();
            ExprAggMultiFunctionLinearAccessNodeFactoryAccess factory = new ExprAggMultiFunctionLinearAccessNodeFactoryAccess(this, new AggregationAccessorWindowWEvalForge(0, paramNodeEval, paramNodeType), JavaClassHelper.getArrayType(paramNodeType), original.getContainedEventType(), null, null, null);
            return new LinearAggregationFactoryDesc(factory, null, paramNodeType);
        }
        throw new ExprValidationException("Invalid number of parameters");
    }

    protected static boolean getIstreamOnly(StreamTypeService streamTypeService, int streamNum) {
        if (streamNum < streamTypeService.getEventTypes().length) {
            return streamTypeService.getIStreamOnly()[streamNum];
        }
        return streamTypeService.getIStreamOnly()[0];
    }

    @Override
    public String getAggregationFunctionName() {
        return this.stateType.toString().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append(this.stateType.toString().toLowerCase(Locale.ENGLISH));
        ExprNodeUtilityCore.toExpressionStringParams(writer, this.getChildNodes());
    }

    public AggregationStateType getStateType() {
        return this.stateType;
    }

    @Override
    public Collection<EventBean> evaluateGetROCollectionEvents(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.aggregationResultFuture.getCollectionOfEvents(this.column, eventsPerStream, isNewData, context);
    }

    @Override
    public CodegenExpression evaluateGetROCollectionEventsCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CodegenLegoEvaluateSelf.evaluateSelfGetROCollectionEvents(this, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public Collection evaluateGetROCollectionScalar(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.aggregationResultFuture.getCollectionScalar(this.column, eventsPerStream, isNewData, context);
    }

    @Override
    public EventType getEventTypeCollection(EventAdapterService eventAdapterService, int statementId) {
        if (this.stateType == AggregationStateType.FIRST || this.stateType == AggregationStateType.LAST) {
            return null;
        }
        return this.containedType;
    }

    @Override
    public Class getComponentTypeCollection() throws ExprValidationException {
        return this.scalarCollectionComponentType;
    }

    @Override
    public EventType getEventTypeSingle(EventAdapterService eventAdapterService, int statementId) throws ExprValidationException {
        if (this.stateType == AggregationStateType.FIRST || this.stateType == AggregationStateType.LAST) {
            return this.containedType;
        }
        return null;
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.aggregationResultFuture.getEventBean(this.column, eventsPerStream, isNewData, context);
    }

    @Override
    protected boolean equalsNodeAggregateMethodOnly(ExprAggregateNode node) {
        if (!(node instanceof ExprAggMultiFunctionLinearAccessNode)) {
            return false;
        }
        ExprAggMultiFunctionLinearAccessNode other = (ExprAggMultiFunctionLinearAccessNode)node;
        return this.stateType == other.stateType && this.containedType == other.containedType && this.scalarCollectionComponentType == other.scalarCollectionComponentType;
    }

    private static ExprValidationException makeUnboundValidationEx(AggregationStateType stateType) {
        return new ExprValidationException(ExprAggMultiFunctionLinearAccessNode.getErrorPrefix(stateType) + " requires that the aggregated events provide a remove stream; Please define a data window onto the stream or use 'firstever', 'lastever' or 'nth' instead");
    }

    private static String getErrorPrefix(AggregationStateType stateType) {
        return ExprAggMultiFunctionUtil.getErrorPrefix(stateType.toString().toLowerCase(Locale.ENGLISH));
    }

    @Override
    protected boolean isFilterExpressionAsLastParameter() {
        return false;
    }
}

