/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.enummethod.eval;

import com.espertech.esper.client.EventType;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.core.streamtype.StreamTypeService;
import com.espertech.esper.epl.enummethod.dot.ExprDotEvalParam;
import com.espertech.esper.epl.enummethod.dot.ExprDotEvalParamLambda;
import com.espertech.esper.epl.enummethod.dot.ExprDotForgeEnumMethodBase;
import com.espertech.esper.epl.enummethod.eval.EnumForge;
import com.espertech.esper.epl.enummethod.eval.EnumSumEventsForge;
import com.espertech.esper.epl.enummethod.eval.EnumSumScalarForge;
import com.espertech.esper.epl.enummethod.eval.EnumSumScalarLambdaForge;
import com.espertech.esper.epl.enummethod.eval.ExprDotEvalSumMethod;
import com.espertech.esper.epl.enummethod.eval.ExprDotEvalSumMethodFactory;
import com.espertech.esper.epl.expression.dot.ExprDotNodeUtility;
import com.espertech.esper.epl.rettype.EPTypeHelper;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.arr.ObjectArrayEventType;
import com.espertech.esper.util.JavaClassHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

public class ExprDotForgeSumOf
extends ExprDotForgeEnumMethodBase {
    @Override
    public EventType[] getAddStreamTypes(String enumMethodUsedName, List<String> goesToNames, EventType inputEventType, Class collectionComponentType, List<ExprDotEvalParam> bodiesAndParameters, EventAdapterService eventAdapterService) {
        return ExprDotNodeUtility.getSingleLambdaParamEventType(enumMethodUsedName, goesToNames, inputEventType, collectionComponentType, eventAdapterService);
    }

    @Override
    public EnumForge getEnumForge(EngineImportService engineImportService, EventAdapterService eventAdapterService, StreamTypeService streamTypeService, int statementId, String enumMethodUsedName, List<ExprDotEvalParam> bodiesAndParameters, EventType inputEventType, Class collectionComponentType, int numStreamsIncoming, boolean disablePropertyExpressionEventCollCache) {
        if (bodiesAndParameters.isEmpty()) {
            ExprDotEvalSumMethodFactory aggMethodFactory = ExprDotForgeSumOf.getAggregatorFactory(collectionComponentType);
            super.setTypeInfo(EPTypeHelper.singleValue(JavaClassHelper.getBoxedType(aggMethodFactory.getValueType())));
            return new EnumSumScalarForge(numStreamsIncoming, aggMethodFactory);
        }
        ExprDotEvalParamLambda first = (ExprDotEvalParamLambda)bodiesAndParameters.get(0);
        ExprDotEvalSumMethodFactory aggMethodFactory = ExprDotForgeSumOf.getAggregatorFactory(first.getBodyForge().getEvaluationType());
        Class returnType = JavaClassHelper.getBoxedType(aggMethodFactory.getValueType());
        super.setTypeInfo(EPTypeHelper.singleValue(returnType));
        if (inputEventType == null) {
            return new EnumSumScalarLambdaForge(first.getBodyForge(), first.getStreamCountIncoming(), aggMethodFactory, (ObjectArrayEventType)first.getGoesToTypes()[0]);
        }
        return new EnumSumEventsForge(first.getBodyForge(), first.getStreamCountIncoming(), aggMethodFactory);
    }

    private static ExprDotEvalSumMethodFactory getAggregatorFactory(Class evalType) {
        if (JavaClassHelper.isFloatingPointClass(evalType)) {
            return ExprDotEvalSumMethodFactoryDouble.INSTANCE;
        }
        if (evalType == BigDecimal.class) {
            return ExprDotEvalSumMethodFactoryBigDecimal.INSTANCE;
        }
        if (evalType == BigInteger.class) {
            return ExprDotEvalSumMethodFactoryBigInteger.INSTANCE;
        }
        if (JavaClassHelper.getBoxedType(evalType) == Long.class) {
            return ExprDotEvalSumMethodFactoryLong.INSTANCE;
        }
        return ExprDotEvalSumMethodFactoryInteger.INSTANCE;
    }

    private static void codegenReturnSumOrNull(CodegenBlock block) {
        block.ifCondition(CodegenExpressionBuilder.equalsIdentity(CodegenExpressionBuilder.ref("cnt"), CodegenExpressionBuilder.constant(0))).blockReturn(CodegenExpressionBuilder.constantNull()).methodReturn(CodegenExpressionBuilder.ref("sum"));
    }

    private static class ExprDotEvalSumMethodInteger
    implements ExprDotEvalSumMethod {
        protected int sum;
        protected long cnt;

        private ExprDotEvalSumMethodInteger() {
        }

        @Override
        public void enter(Object object) {
            if (object == null) {
                return;
            }
            ++this.cnt;
            this.sum += ((Integer)object).intValue();
        }

        @Override
        public Object getValue() {
            if (this.cnt == 0L) {
                return null;
            }
            return this.sum;
        }
    }

    private static class ExprDotEvalSumMethodFactoryInteger
    implements ExprDotEvalSumMethodFactory {
        private static final ExprDotEvalSumMethodFactoryInteger INSTANCE = new ExprDotEvalSumMethodFactoryInteger();

        private ExprDotEvalSumMethodFactoryInteger() {
        }

        @Override
        public ExprDotEvalSumMethod getSumAggregator() {
            return new ExprDotEvalSumMethodInteger();
        }

        @Override
        public Class getValueType() {
            return Integer.class;
        }

        @Override
        public void codegenDeclare(CodegenBlock block) {
            block.declareVar(Integer.TYPE, "sum", CodegenExpressionBuilder.constant(0));
            block.declareVar(Long.TYPE, "cnt", CodegenExpressionBuilder.constant(0));
        }

        @Override
        public void codegenEnterNumberTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.increment("cnt");
            block.assignCompound("sum", "+", (CodegenExpression)value);
        }

        @Override
        public void codegenEnterObjectTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.increment("cnt");
            block.assignCompound("sum", "+", CodegenExpressionBuilder.cast(Integer.class, (CodegenExpression)value));
        }

        @Override
        public void codegenReturn(CodegenBlock block) {
            ExprDotForgeSumOf.codegenReturnSumOrNull(block);
        }
    }

    private static class ExprDotEvalSumMethodLong
    implements ExprDotEvalSumMethod {
        protected long sum;
        protected long cnt;

        private ExprDotEvalSumMethodLong() {
        }

        @Override
        public void enter(Object object) {
            if (object == null) {
                return;
            }
            ++this.cnt;
            this.sum += ((Long)object).longValue();
        }

        @Override
        public Object getValue() {
            if (this.cnt == 0L) {
                return null;
            }
            return this.sum;
        }
    }

    private static class ExprDotEvalSumMethodFactoryLong
    implements ExprDotEvalSumMethodFactory {
        private static final ExprDotEvalSumMethodFactoryLong INSTANCE = new ExprDotEvalSumMethodFactoryLong();

        private ExprDotEvalSumMethodFactoryLong() {
        }

        @Override
        public ExprDotEvalSumMethod getSumAggregator() {
            return new ExprDotEvalSumMethodLong();
        }

        @Override
        public Class getValueType() {
            return Long.class;
        }

        @Override
        public void codegenDeclare(CodegenBlock block) {
            block.declareVar(Long.TYPE, "sum", CodegenExpressionBuilder.constant(0));
            block.declareVar(Long.TYPE, "cnt", CodegenExpressionBuilder.constant(0));
        }

        @Override
        public void codegenEnterNumberTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.increment("cnt");
            block.assignCompound("sum", "+", (CodegenExpression)value);
        }

        @Override
        public void codegenEnterObjectTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.increment("cnt");
            block.assignCompound("sum", "+", CodegenExpressionBuilder.cast(Long.class, (CodegenExpression)value));
        }

        @Override
        public void codegenReturn(CodegenBlock block) {
            ExprDotForgeSumOf.codegenReturnSumOrNull(block);
        }
    }

    private static class ExprDotEvalSumMethodBigInteger
    implements ExprDotEvalSumMethod {
        protected BigInteger sum = BigInteger.valueOf(0L);
        protected long cnt;

        @Override
        public void enter(Object object) {
            if (object == null) {
                return;
            }
            ++this.cnt;
            this.sum = this.sum.add((BigInteger)object);
        }

        @Override
        public Object getValue() {
            if (this.cnt == 0L) {
                return null;
            }
            return this.sum;
        }
    }

    private static class ExprDotEvalSumMethodFactoryBigInteger
    implements ExprDotEvalSumMethodFactory {
        private static final ExprDotEvalSumMethodFactoryBigInteger INSTANCE = new ExprDotEvalSumMethodFactoryBigInteger();

        private ExprDotEvalSumMethodFactoryBigInteger() {
        }

        @Override
        public ExprDotEvalSumMethod getSumAggregator() {
            return new ExprDotEvalSumMethodBigInteger();
        }

        @Override
        public Class getValueType() {
            return BigInteger.class;
        }

        @Override
        public void codegenDeclare(CodegenBlock block) {
            block.declareVar(BigInteger.class, "sum", CodegenExpressionBuilder.staticMethod(BigInteger.class, "valueOf", CodegenExpressionBuilder.constant(0)));
            block.declareVar(Long.TYPE, "cnt", CodegenExpressionBuilder.constant(0));
        }

        @Override
        public void codegenEnterNumberTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.increment("cnt").assignRef("sum", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("sum"), "add", value));
        }

        @Override
        public void codegenEnterObjectTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.increment("cnt").assignRef("sum", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("sum"), "add", CodegenExpressionBuilder.cast(BigInteger.class, (CodegenExpression)value)));
        }

        @Override
        public void codegenReturn(CodegenBlock block) {
            ExprDotForgeSumOf.codegenReturnSumOrNull(block);
        }
    }

    private static class ExprDotEvalSumMethodBigDecimal
    implements ExprDotEvalSumMethod {
        protected BigDecimal sum = new BigDecimal(0.0);
        protected long cnt;

        @Override
        public void enter(Object object) {
            if (object == null) {
                return;
            }
            ++this.cnt;
            this.sum = this.sum.add((BigDecimal)object);
        }

        @Override
        public Object getValue() {
            if (this.cnt == 0L) {
                return null;
            }
            return this.sum;
        }
    }

    private static class ExprDotEvalSumMethodFactoryBigDecimal
    implements ExprDotEvalSumMethodFactory {
        private static final ExprDotEvalSumMethodFactoryBigDecimal INSTANCE = new ExprDotEvalSumMethodFactoryBigDecimal();

        private ExprDotEvalSumMethodFactoryBigDecimal() {
        }

        @Override
        public ExprDotEvalSumMethod getSumAggregator() {
            return new ExprDotEvalSumMethodBigDecimal();
        }

        @Override
        public Class getValueType() {
            return BigDecimal.class;
        }

        @Override
        public void codegenDeclare(CodegenBlock block) {
            block.declareVar(BigDecimal.class, "sum", CodegenExpressionBuilder.newInstance(BigDecimal.class, CodegenExpressionBuilder.constant(0.0)));
            block.declareVar(Long.TYPE, "cnt", CodegenExpressionBuilder.constant(0));
        }

        @Override
        public void codegenEnterNumberTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.increment("cnt").assignRef("sum", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("sum"), "add", value));
        }

        @Override
        public void codegenEnterObjectTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.increment("cnt").assignRef("sum", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("sum"), "add", CodegenExpressionBuilder.cast(BigDecimal.class, (CodegenExpression)value)));
        }

        @Override
        public void codegenReturn(CodegenBlock block) {
            ExprDotForgeSumOf.codegenReturnSumOrNull(block);
        }
    }

    private static class ExprDotEvalSumMethodDouble
    implements ExprDotEvalSumMethod {
        protected double sum;
        protected long cnt;

        private ExprDotEvalSumMethodDouble() {
        }

        @Override
        public void enter(Object object) {
            if (object == null) {
                return;
            }
            ++this.cnt;
            this.sum += ((Double)object).doubleValue();
        }

        @Override
        public Object getValue() {
            if (this.cnt == 0L) {
                return null;
            }
            return this.sum;
        }
    }

    private static class ExprDotEvalSumMethodFactoryDouble
    implements ExprDotEvalSumMethodFactory {
        private static final ExprDotEvalSumMethodFactoryDouble INSTANCE = new ExprDotEvalSumMethodFactoryDouble();

        private ExprDotEvalSumMethodFactoryDouble() {
        }

        @Override
        public ExprDotEvalSumMethod getSumAggregator() {
            return new ExprDotEvalSumMethodDouble();
        }

        @Override
        public Class getValueType() {
            return Double.class;
        }

        @Override
        public void codegenDeclare(CodegenBlock block) {
            block.declareVar(Double.TYPE, "sum", CodegenExpressionBuilder.constant(0));
            block.declareVar(Long.TYPE, "cnt", CodegenExpressionBuilder.constant(0));
        }

        @Override
        public void codegenEnterNumberTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.increment("cnt");
            block.assignCompound("sum", "+", (CodegenExpression)value);
        }

        @Override
        public void codegenEnterObjectTypedNonNull(CodegenBlock block, CodegenExpressionRef value) {
            block.increment("cnt");
            block.assignCompound("sum", "+", CodegenExpressionBuilder.cast(Double.class, (CodegenExpression)value));
        }

        @Override
        public void codegenReturn(CodegenBlock block) {
            ExprDotForgeSumOf.codegenReturnSumOrNull(block);
        }
    }
}

