/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.reformatop;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRelational;
import com.espertech.esper.epl.datetime.eval.DatetimeLongCoercerFactory;
import com.espertech.esper.epl.datetime.eval.DatetimeLongCoercerLocalDateTime;
import com.espertech.esper.epl.datetime.eval.DatetimeLongCoercerZonedDateTime;
import com.espertech.esper.epl.datetime.eval.DatetimeMethodEnum;
import com.espertech.esper.epl.datetime.reformatop.ReformatForge;
import com.espertech.esper.epl.datetime.reformatop.ReformatOp;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.dot.ExprDotNodeFilterAnalyzerInput;
import com.espertech.esper.epl.join.plan.FilterExprAnalyzerAffector;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class ReformatBetweenConstantParamsForge
implements ReformatForge,
ReformatOp {
    private long first;
    private long second;
    private TimeZone timeZone;

    public ReformatBetweenConstantParamsForge(List<ExprNode> parameters, TimeZone timeZone) throws ExprValidationException {
        this.timeZone = timeZone;
        long paramFirst = this.getLongValue(parameters.get(0));
        long paramSecond = this.getLongValue(parameters.get(1));
        if (paramFirst > paramSecond) {
            this.second = paramFirst;
            this.first = paramSecond;
        } else {
            this.first = paramFirst;
            this.second = paramSecond;
        }
        if (parameters.size() > 2) {
            if (!this.getBooleanValue(parameters.get(2))) {
                ++this.first;
            }
            if (!this.getBooleanValue(parameters.get(3))) {
                --this.second;
            }
        }
    }

    @Override
    public ReformatOp getOp() {
        return this;
    }

    private long getLongValue(ExprNode exprNode) throws ExprValidationException {
        Object value = exprNode.getForge().getExprEvaluator().evaluate(null, true, null);
        if (value == null) {
            throw new ExprValidationException("Date-time method 'between' requires non-null parameter values");
        }
        return DatetimeLongCoercerFactory.getCoercer(value.getClass(), this.timeZone).coerce(value);
    }

    private boolean getBooleanValue(ExprNode exprNode) throws ExprValidationException {
        Object value = exprNode.getForge().getExprEvaluator().evaluate(null, true, null);
        if (value == null) {
            throw new ExprValidationException("Date-time method 'between' requires non-null parameter values");
        }
        return (Boolean)value;
    }

    @Override
    public Object evaluate(Long ts, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        if (ts == null) {
            return null;
        }
        return this.evaluateInternal(ts);
    }

    @Override
    public Object evaluate(Date d, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        if (d == null) {
            return null;
        }
        return this.evaluateInternal(d.getTime());
    }

    @Override
    public CodegenExpression codegenDate(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return this.codegenLong(CodegenExpressionBuilder.exprDotMethod(inner, "getTime", new CodegenExpression[0]), codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public Object evaluate(Calendar cal, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        if (cal == null) {
            return null;
        }
        return this.evaluateInternal(cal.getTimeInMillis());
    }

    @Override
    public CodegenExpression codegenCal(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return this.codegenLong(CodegenExpressionBuilder.exprDotMethod(inner, "getTimeInMillis", new CodegenExpression[0]), codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public Object evaluate(LocalDateTime ldt, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        if (ldt == null) {
            return null;
        }
        return this.evaluateInternal(DatetimeLongCoercerLocalDateTime.coerceLDTToMilliWTimezone(ldt, this.timeZone));
    }

    @Override
    public CodegenExpression codegenLDT(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMember tz = codegenClassScope.makeAddMember(TimeZone.class, this.timeZone);
        return this.codegenLong(CodegenExpressionBuilder.staticMethod(DatetimeLongCoercerLocalDateTime.class, "coerceLDTToMilliWTimezone", inner, CodegenExpressionBuilder.member(tz.getMemberId())), codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public Object evaluate(ZonedDateTime zdt, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        if (zdt == null) {
            return null;
        }
        return this.evaluateInternal(DatetimeLongCoercerZonedDateTime.coerceZDTToMillis(zdt));
    }

    @Override
    public CodegenExpression codegenZDT(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return this.codegenLong(CodegenExpressionBuilder.staticMethod(DatetimeLongCoercerZonedDateTime.class, "coerceZDTToMillis", inner), codegenMethodScope, exprSymbol, codegenClassScope);
    }

    public Object evaluateInternal(long ts) {
        return this.first <= ts && ts <= this.second;
    }

    @Override
    public CodegenExpression codegenLong(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.and(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.constant(this.first), CodegenExpressionRelational.CodegenRelational.LE, inner), CodegenExpressionBuilder.relational(inner, CodegenExpressionRelational.CodegenRelational.LE, CodegenExpressionBuilder.constant(this.second)), new CodegenExpression[0]);
    }

    @Override
    public Class getReturnType() {
        return Boolean.class;
    }

    @Override
    public FilterExprAnalyzerAffector getFilterDesc(EventType[] typesPerStream, DatetimeMethodEnum currentMethod, List<ExprNode> currentParameters, ExprDotNodeFilterAnalyzerInput inputDesc) {
        return null;
    }
}

